/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.summary;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.index.summary.DefaultIndexSummarizer;
import com.atlassian.jira.index.summary.IndexReplicationQueueSummary;
import com.atlassian.jira.index.summary.IndexSummarizer;
import com.atlassian.jira.index.summary.IssueIndexSummary;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Map;

public class AuthorizingIndexSummarizer
implements IndexSummarizer {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final DefaultIndexSummarizer defaultIndexSummarizer;

    public AuthorizingIndexSummarizer(JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, DefaultIndexSummarizer defaultIndexSummarizer) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.defaultIndexSummarizer = defaultIndexSummarizer;
    }

    public ServiceOutcome<IssueIndexSummary> summarizeIssueIndex() {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, loggedInUser)) {
            return this.defaultIndexSummarizer.summarizeIssueIndex();
        }
        return ServiceOutcomeImpl.error("Admin permission required", ErrorCollection.Reason.FORBIDDEN);
    }

    public ServiceOutcome<Map<String, IndexReplicationQueueSummary>> summarizeIndexReplicationQueues() {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, loggedInUser)) {
            return this.defaultIndexSummarizer.summarizeIndexReplicationQueues();
        }
        return ServiceOutcomeImpl.error("Admin permission required", ErrorCollection.Reason.FORBIDDEN);
    }
}

