/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.analytics.api.events.AnalyticsPluginReadyEvent;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.monitoring.AppMonitoringMetricsService;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.monitoring.jmx.analytics.AppMonitoringStartupAnalyticsEvent;
import com.atlassian.jira.monitoring.jmx.analytics.AppMonitoringToggledAnalyticsEvent;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.MetricsFilter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@EventComponent
public class DefaultAppMonitoringMetricsService
implements AppMonitoringMetricsService,
InitializingComponent {
    public static final List<String> APP_MONITORING_METRIC_NAMES = ImmutableList.of((Object)"cluster.lock.held.duration", (Object)"cluster.lock.waited.duration", (Object)"db.ao.entityManager.count", (Object)"db.ao.entityManager.create", (Object)"db.ao.entityManager.delete", (Object)"db.ao.entityManager.deleteWithSQL", (Object)"db.ao.entityManager.find", (Object)"db.ao.entityManager.get", (Object)"db.ao.entityManager.stream", (Object)"db.ao.executeInTransaction", (Object)"db.ao.upgradeTask", (Object)"db.core.executionTime", (Object[])new String[]{"db.sal.transactionalExecutor", "web.resource.condition", "web.resource.transform", "cache.removeAll", "cacheManager.flushAll", "cachedReference.reset", "customFields.searcher", "cluster.lock.held.duration", "cluster.lock.waited.duration", "task", "longRunningTask", "http.rest.request", "http.sal.request", "indexing.field.addIndex", "indexing.field.isFieldIndexableForIssue", "webTemplateRenderer", "web.fragment.condition", "plugin.disabled.counter", "plugin.enabled.counter", "search.index", "comment.reindexing", "issue.reindexing"});
    public static final String ITA_DENY_DARK_FEATURE = "com.atlassian.profiling.ita.metrics.deny";
    @VisibleForTesting
    static final MetricsFilter ITA_METRICS_DENY_FILTER = MetricsFilter.deny(APP_MONITORING_METRIC_NAMES);
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final JmxMetricsExposer jmxMetricsExposer;

    public DefaultAppMonitoringMetricsService(@Nonnull EventPublisher eventPublisher, @Nonnull FeatureManager featureManager, @Nonnull JmxMetricsExposer jmxMetricsExposer) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.featureManager = Objects.requireNonNull(featureManager, "featureManager");
        this.jmxMetricsExposer = Objects.requireNonNull(jmxMetricsExposer, "jmxMetricsExposer");
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.updateMetricsState();
    }

    public void setAppMonitoringEnabled(boolean isEnabled) {
        if (isEnabled && !this.jmxMetricsExposer.isJmxEnabled()) {
            this.jmxMetricsExposer.startExposing();
        }
        this.internalSetAppMonitoringEnabled(isEnabled);
        this.eventPublisher.publish((Object)new AppMonitoringToggledAnalyticsEvent(isEnabled));
    }

    public boolean isAppMonitoringEnabled() {
        return !this.featureManager.isEnabled(ITA_DENY_DARK_FEATURE);
    }

    @EventListener
    public void onFeatureEvent(FeatureEvent featureEvent) {
        if (ITA_DENY_DARK_FEATURE.equals(featureEvent.feature())) {
            this.updateMetricsState();
        }
    }

    private void updateMetricsState() {
        if (this.isAppMonitoringEnabled()) {
            Metrics.getConfiguration().setFilter(MetricsFilter.ACCEPT_ALL);
        } else {
            Metrics.getConfiguration().setFilter(ITA_METRICS_DENY_FILTER);
        }
    }

    @EventListener
    public void onAnalyticsPluginReadyEvent(AnalyticsPluginReadyEvent event) {
        this.eventPublisher.publish((Object)new AppMonitoringStartupAnalyticsEvent(this.isAppMonitoringEnabled()));
    }

    @EventListener
    public void onJmxConfigurationChangedEvent(JmxConfigurationChangedEvent jmxConfigurationChangedEvent) {
        if (!jmxConfigurationChangedEvent.isEnabled()) {
            this.internalSetAppMonitoringEnabled(false);
        }
    }

    private void internalSetAppMonitoringEnabled(boolean enabled) {
        if (enabled) {
            this.featureManager.disableSiteDarkFeature(ITA_DENY_DARK_FEATURE);
        } else {
            this.featureManager.enableSiteDarkFeature(ITA_DENY_DARK_FEATURE);
        }
        this.updateMetricsState();
    }
}

