/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.AbsoluteCounter;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.DerivedCounter;
import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.InstrumentRegistry;
import com.atlassian.instrumentation.operations.OpCounter;
import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.instrumentation.operations.ThreadOpTimerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.instrumentation.external.ExternalGauges;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.util.log.OneShotLogger;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class Instrumentation
implements Startable {
    private static final OneShotLogger log = new OneShotLogger(Logger.getLogger(Instrument.class));
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final DatabaseConfigurationLoader databaseConfigurationLoader;
    private final EventPublisher eventPublisher;

    public Instrumentation(VelocityRequestContextFactory velocityRequestContextFactory, DatabaseConfigurationLoader databaseConfigurationLoader, EventPublisher eventPublisher) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.databaseConfigurationLoader = databaseConfigurationLoader;
        this.eventPublisher = eventPublisher;
    }

    private static InstrumentRegistry getInstance() {
        return (InstrumentRegistry)ComponentAccessor.getComponent(InstrumentRegistry.class);
    }

    public static Instrument putInstrument(Instrument instrument) {
        return Instrumentation.getInstance().putInstrument(instrument);
    }

    public static Instrument getInstrument(String name) {
        return Instrumentation.getInstance().getInstrument(name);
    }

    public static AbsoluteCounter pullAbsoluteCounter(String name) {
        return Instrumentation.getInstance().pullAbsoluteCounter(name);
    }

    public static AbsoluteCounter pullAbsoluteCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getInstance().pullAbsoluteCounter(instrumentationName.getInstrumentName());
    }

    public static Counter pullCounter(String name) {
        return Instrumentation.getInstance().pullCounter(name);
    }

    public static Counter pullCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getInstance().pullCounter(instrumentationName.getInstrumentName());
    }

    public static DerivedCounter pullDerivedCounter(String name) {
        return Instrumentation.getInstance().pullDerivedCounter(name);
    }

    public static DerivedCounter pullDerivedCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getInstance().pullDerivedCounter(instrumentationName.getInstrumentName());
    }

    public static Gauge pullGauge(String name) {
        return Instrumentation.getInstance().pullGauge(name);
    }

    public static Gauge pullGauge(InstrumentationName instrumentationName) {
        return Instrumentation.getInstance().pullGauge(instrumentationName.getInstrumentName());
    }

    public static OpCounter pullOpCounter(String name) {
        return Instrumentation.getInstance().pullOpCounter(name);
    }

    public static OpCounter pullOpCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getInstance().pullOpCounter(instrumentationName.getInstrumentName());
    }

    public static OpTimer pullTimer(String name) {
        return Instrumentation.getInstance().pullTimer(name);
    }

    public static OpTimer pullTimer(InstrumentationName instrumentationName) {
        return Instrumentation.getInstance().pullTimer(instrumentationName.getInstrumentName());
    }

    public static List<Instrument> snapshotInstruments() {
        return Instrumentation.getInstance().snapshotInstruments();
    }

    public static List<OpSnapshot> snapshotThreadLocalOperationsAndClear(OpTimerFactory opTimerFactory) {
        if (opTimerFactory instanceof ThreadOpTimerFactory) {
            ThreadOpTimerFactory threadLocalOpTimerFactory = (ThreadOpTimerFactory)opTimerFactory;
            return threadLocalOpTimerFactory.snapshotAndClear();
        }
        log.error((Object)("Unable to snapshot thread local operations (implementation of OpTimerFactory is not a ThreadLocalOpTimerFactory): " + opTimerFactory));
        return Collections.emptyList();
    }

    public static List<OpSnapshot> snapshotThreadLocalOperations(OpTimerFactory opTimerFactory) {
        if (opTimerFactory instanceof ThreadOpTimerFactory) {
            ThreadOpTimerFactory threadLocalOpTimerFactory = (ThreadOpTimerFactory)opTimerFactory;
            return threadLocalOpTimerFactory.getOpRegistry().snapshot();
        }
        log.error((Object)("Unable to snapshot thread local operations (implementation of OpTimerFactory is not a ThreadLocalOpTimerFactory): " + opTimerFactory));
        return Collections.emptyList();
    }

    public void start() {
        new ExternalGauges(this.velocityRequestContextFactory, this.databaseConfigurationLoader, this.eventPublisher).installInstruments();
        Instrumentation.pullOpCounter(InstrumentationName.WEB_REQUESTS);
        Instrumentation.pullOpCounter(InstrumentationName.DB_READS);
        Instrumentation.pullOpCounter(InstrumentationName.DB_WRITES);
        Instrumentation.pullOpCounter(InstrumentationName.ISSUE_INDEX_READS);
        Instrumentation.pullOpCounter(InstrumentationName.ISSUE_INDEX_WRITES);
        Instrumentation.pullGauge(InstrumentationName.QUICKSEARCH_CONCURRENT_REQUESTS);
        JmxMetricsExposer jmxMetricsExposer = (JmxMetricsExposer)ComponentAccessor.getComponent(JmxMetricsExposer.class);
        if (jmxMetricsExposer != null) {
            jmxMetricsExposer.init();
        }
    }
}

