/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.micrometer.MicrometerStrategy;
import com.atlassian.util.profiling.micrometer.analytics.AnalyticsMeterRegistry;
import com.atlassian.util.profiling.micrometer.analytics.AnalyticsRegistryConfig;
import com.atlassian.util.profiling.micrometer.util.QualifiedCompatibleHierarchicalNameMapper;
import com.atlassian.util.profiling.micrometer.util.UnescapedObjectNameFactory;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventComponent
public class MicrometerMetrics
implements Startable {
    @VisibleForTesting
    public static final String JMX_DOMAIN = "com.atlassian.jira";
    private static final MeterFilter IGNORE_ANALYTIC_TAGS = MeterFilter.ignoreTags((String[])new String[]{"atl-analytics"});
    private static final Logger log = LoggerFactory.getLogger(MicrometerMetrics.class);
    private final JmxMetricsExposer jmxMetricsExposer;
    @VisibleForTesting
    final JmxMeterRegistry jmxRegistry;
    @VisibleForTesting
    final AnalyticsMeterRegistry analyticsRegistry;
    private final MicrometerStrategy micrometerStrategy;
    private final CompositeMeterRegistry compositeMeterRegistry;

    @Autowired
    public MicrometerMetrics(JmxMetricsExposer jmxMetricsExposer, EventPublisher eventPublisher) {
        this(Clock.SYSTEM, jmxMetricsExposer, eventPublisher);
    }

    @VisibleForTesting
    MicrometerMetrics(Clock clock, JmxMetricsExposer jmxMetricsExposer, EventPublisher eventPublisher) {
        this.jmxMetricsExposer = jmxMetricsExposer;
        this.jmxRegistry = MicrometerMetrics.createJmxRegistry(clock);
        this.analyticsRegistry = new AnalyticsMeterRegistry(AnalyticsRegistryConfig.DEFAULT, eventPublisher, clock, AnalyticsMeterRegistry.DEFAULT_THREAD_FACTORY);
        this.compositeMeterRegistry = new CompositeMeterRegistry().add((MeterRegistry)this.jmxRegistry).add((MeterRegistry)this.analyticsRegistry);
        this.micrometerStrategy = new MicrometerStrategy((MeterRegistry)this.compositeMeterRegistry);
    }

    public void start() throws Exception {
        StrategiesRegistry.addMetricStrategy((MetricStrategy)this.micrometerStrategy);
        this.setEnabled(this.jmxMetricsExposer.isJmxEnabled());
    }

    @PreDestroy
    public void stop() {
        StrategiesRegistry.removeMetricStrategy((MetricStrategy)this.micrometerStrategy);
    }

    @EventListener
    public void onJmxMetricsEvent(JmxConfigurationChangedEvent event) {
        this.setEnabled(event.isEnabled());
    }

    private synchronized void setEnabled(boolean jmxEnabled) {
        Metrics.getConfiguration().setEnabled(jmxEnabled);
        if (jmxEnabled) {
            this.jmxRegistry.start();
            this.analyticsRegistry.start(AnalyticsMeterRegistry.DEFAULT_THREAD_FACTORY);
            log.debug("Started exposing micrometer metrics");
        } else {
            this.jmxRegistry.stop();
            this.analyticsRegistry.stop();
            this.compositeMeterRegistry.forEachMeter(Meter::close);
            this.compositeMeterRegistry.clear();
            log.debug("Stopped exposing micrometer metrics");
        }
    }

    private static JmxMeterRegistry createJmxRegistry(Clock clock) {
        MetricRegistry metricRegistry = new MetricRegistry();
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain(JMX_DOMAIN).createsObjectNamesWith((ObjectNameFactory)new UnescapedObjectNameFactory()).build();
        QualifiedCompatibleHierarchicalNameMapper nameMapper = new QualifiedCompatibleHierarchicalNameMapper();
        JmxMeterRegistry registry = new JmxMeterRegistry(JmxConfig.DEFAULT, clock, (HierarchicalNameMapper)nameMapper, metricRegistry, jmxReporter);
        registry.config().namingConvention(NamingConvention.dot).meterFilter(IGNORE_ANALYTIC_TAGS).onMeterRemoved(MicrometerMetrics.getMeterCleanupConsumer(metricRegistry, (HierarchicalNameMapper)nameMapper, registry));
        return registry;
    }

    private static Consumer<Meter> getMeterCleanupConsumer(MetricRegistry metricRegistry, HierarchicalNameMapper nameMapper, JmxMeterRegistry registry) {
        return meter -> {
            if (meter instanceof LongTaskTimer) {
                for (Statistic statistic : Statistic.values()) {
                    metricRegistry.remove(nameMapper.toHierarchicalName(meter.getId().withTag(statistic), registry.config().namingConvention()));
                }
            }
        };
    }
}

