/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.event.DashboardViewEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueSearchEvent;
import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.util.Predicate;
import java.util.concurrent.atomic.LongAdder;

class EventExternalGauges {
    EventExternalGauges(EventPublisher eventPublisher) {
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.ISSUE_CREATED_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof IssueEvent && ((IssueEvent)event).getEventTypeId().equals(EventType.ISSUE_CREATED_ID)))));
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.ISSUE_UPDATED_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof IssueEvent && ((IssueEvent)event).getEventTypeId().equals(EventType.ISSUE_UPDATED_ID)))));
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.ISSUE_ASSIGNED_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof IssueEvent && ((IssueEvent)event).getEventTypeId().equals(EventType.ISSUE_ASSIGNED_ID)))));
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.ISSUE_WORKLOGGED_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof IssueEvent && ((IssueEvent)event).getEventTypeId().equals(EventType.ISSUE_WORKLOGGED_ID)))));
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.ISSUE_LINK_CREATED_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof IssueLinkCreatedEvent))));
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.ISSUE_SEARCH_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof IssueSearchEvent))));
        Instrumentation.putInstrument((Instrument)new ExternalGauge(InstrumentationName.DASHBOARD_VIEW_COUNT.getInstrumentName(), (ExternalValue)new EventCounter(eventPublisher, (Predicate<Object>)((Predicate)event -> event instanceof DashboardViewEvent))));
    }

    public static final class EventCounter
    implements ExternalValue {
        private final LongAdder eventCountAdder = new LongAdder();
        private final Predicate<Object> eventFilter;

        public EventCounter(EventPublisher eventPublisher, Predicate<Object> eventFilter) {
            this.eventFilter = eventFilter;
            eventPublisher.register((Object)this);
        }

        @EventListener
        public void handleEvent(Object event) {
            if (this.eventFilter.evaluate(event)) {
                this.eventCountAdder.increment();
            }
        }

        public long getValue() {
            return this.eventCountAdder.longValue();
        }
    }
}

