/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.instrumentation.CachedExternalValue;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.instrumentation.GenericInstrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.instrumentation.util.InstrumentFactory;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.util.Supplier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class InternalStatisticsExternalGauges {
    InternalStatisticsExternalGauges() {
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_ISSUES, (ExternalValue)new OfBizViewExternalValue("Issue")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_PROJECTS, (ExternalValue)new OfBizViewExternalValue("Project")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_CUSTOMFIELDS, (ExternalValue)new OfBizViewExternalValue("CustomField")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_WORKFLOWS, (ExternalValue)new OfBizViewExternalValue("Workflow")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_USERS, (ExternalValue)new OfBizViewExternalValue("User")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_GROUPS, (ExternalValue)new OfBizViewExternalValue("Group")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_FILTERS, (ExternalValue)new OfBizViewExternalValue("SearchRequest")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_ATTACHMENTS, (ExternalValue)new OfBizViewExternalValue("FileAttachment")));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_VERSIONS, () -> ComponentAccessor.getVersionManager().getTotalVersionCount()));
        Instrumentation.putInstrument((Instrument)InstrumentFactory.newExternalGauge(InstrumentationName.TOTAL_COMPONENTS, () -> ComponentAccessor.getProjectComponentManager().getTotalComponentCount()));
        this.registerLicenceInstruments();
    }

    private void registerLicenceInstruments() {
        final JiraLicenseManager licenseManager = (JiraLicenseManager)ComponentAccessor.getComponent(JiraLicenseManager.class);
        final ApplicationRoleManager roleManager = (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
        if (licenseManager != null && roleManager != null) {
            Instrumentation.putInstrument(new GenericInstrument(InstrumentationName.LICENSE_INFO.getInstrumentName(), (Map<String, Supplier<Object>>)new HashMap<String, Supplier<Object>>(){
                {
                    for (LicenseDetails licenseDetails : licenseManager.getLicenses()) {
                        LicensedApplications applications = licenseDetails.getLicensedApplications();
                        for (ApplicationKey applicationKey : applications.getKeys()) {
                            this.put(applicationKey.value() + ".max.user.count", () -> applications.getUserLimit(applicationKey));
                            this.put(applicationKey.value() + ".current.user.count", () -> roleManager.getUserCountAsync(applicationKey));
                        }
                    }
                }
            }));
        }
    }

    private static class OfBizViewExternalValue
    extends CachedExternalValue {
        private final String entityName;

        private OfBizViewExternalValue(String entityName) {
            super(120L, TimeUnit.SECONDS);
            this.entityName = entityName;
        }

        protected long computeValue() {
            try {
                return ComponentAccessor.getOfBizDelegator().getCount(this.entityName);
            }
            catch (DataAccessException e) {
                return -1L;
            }
        }
    }
}

