/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.ipd.InProductDiagnosticDisabledEvent;
import com.atlassian.jira.ipd.InProductDiagnosticEnabledEvent;

public class InProductDiagnosticFeatureFlagRePublisher {
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    public InProductDiagnosticFeatureFlagRePublisher(EventPublisher eventPublisher, FeatureManager featureManager) {
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onFeatureEnabledEvent(FeatureEnabledEvent featureEnabledEvent) {
        if (this.isIPDFeatureFlagEvent((FeatureEvent)featureEnabledEvent)) {
            this.publishEvent();
        }
    }

    @EventListener
    public void onFeatureDisabledEvent(FeatureDisabledEvent featureDisabledEvent) {
        if (this.isIPDFeatureFlagEvent((FeatureEvent)featureDisabledEvent)) {
            this.publishEvent();
        }
    }

    private void publishEvent() {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS)) {
            this.eventPublisher.publish((Object)new InProductDiagnosticEnabledEvent());
        } else {
            this.eventPublisher.publish((Object)new InProductDiagnosticDisabledEvent());
        }
    }

    private boolean isIPDFeatureFlagEvent(FeatureEvent featureEvent) {
        return featureEvent.feature().equals(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.enabledFeatureKey()) || featureEvent.feature().equals(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.disabledFeatureKey());
    }
}

