/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProductDiagnosticUtils {
    public static final long NO_VALUE = -1L;
    private static final Logger log = LoggerFactory.getLogger(InProductDiagnosticUtils.class);
    public static final ObjectName JIRA_MBEAN_NAME;

    private InProductDiagnosticUtils() {
    }

    public static MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static Set<ObjectName> findObjectName(String nameQuery) {
        try {
            ObjectName objectNameQuery = new ObjectName(nameQuery);
            return InProductDiagnosticUtils.getPlatformMBeanServer().queryNames(objectNameQuery, null);
        }
        catch (MalformedObjectNameException e) {
            log.error("Can't find objectName", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public static Optional<Object> getMbeanAttribute(ObjectName name, String attribute) {
        try {
            return Optional.of(InProductDiagnosticUtils.getPlatformMBeanServer().getAttribute(name, attribute));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            log.error("Can't get attribute", (Throwable)e);
            return Optional.empty();
        }
    }

    static {
        try {
            JIRA_MBEAN_NAME = new ObjectName("com.atlassian.jira:name=BasicDataSource");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }
}

