/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.diagnostics.internal.ipd.DefaultIpdMainRegistryConfiguration;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistryConfiguration;
import com.atlassian.diagnostics.ipd.internal.spi.IpdLoggingService;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;

public class JiraIpdMainRegistry {
    private static final DefaultIpdMainRegistryConfiguration ipdConfiguration = new DefaultIpdMainRegistryConfiguration("com.atlassian.jira");
    private static final IpdMainRegistry ipdMainRegistry = new IpdMainRegistry((IpdMainRegistryConfiguration)ipdConfiguration);

    public JiraIpdMainRegistry(FeatureManager featureManager, IpdLoggingService ipdLoggingService) {
        ipdConfiguration.setFFSupplier(() -> featureManager.isEnabled(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS));
        ipdConfiguration.setWipFFSupplier(() -> featureManager.isEnabled(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS_WIP));
        ipdConfiguration.setMetricLogOnDemandListener(metric -> ipdLoggingService.logMetric(metric, featureManager.isEnabled(JiraFeatureFlagRegistrar.IPD_EXTRA_LOGGING)));
    }

    public static IpdMainRegistry instance() {
        return ipdMainRegistry;
    }
}

