/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistryLogger;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ipd.IpdExecutors;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIpdScheduler
implements Startable {
    private static final Logger regularLogger = LoggerFactory.getLogger((String)"ipd-monitoring");
    private static final int DEFAULT_INTERVAL_SECONDS = 60;
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private static final int EMITTER_INITIAL_DELAY_SECONDS = 0;
    private static final int COLLECTOR_INITIAL_DELAY_SECONDS = 30;
    @VisibleForTesting
    private static final String OBJECTS_NAME_PREFIX = "com.atlassian.jira";
    private static final String IPD_THREAD_WORKER = "ipd-worker";
    private static final String COLLECTOR_INTERVAL_PROPERTY_KEY = "jira.diagnostics.ipdlog.poll.seconds";
    private final ScheduledExecutorService scheduledExecutorService;
    private final IpdMainRegistryLogger ipdMainRegistryLogger;
    private final IpdJobRunner ipdJobRunner;
    private final FeatureManager featureManager;
    private final IpdMainRegistry ipdMainRegistry;

    public JiraIpdScheduler(IpdMainRegistryLogger ipdMainRegistryLogger, IpdMainRegistry ipdMainRegistry, IpdJobRunner ipdJobRunner, FeatureManager featureManager, IpdExecutors ipdExecutors) {
        this(ipdMainRegistryLogger, ipdMainRegistry, ipdJobRunner, featureManager, ipdExecutors.createSingleThreadScheduledExecutorService(IPD_THREAD_WORKER));
    }

    @VisibleForTesting
    JiraIpdScheduler(IpdMainRegistryLogger ipdMainRegistryLogger, IpdMainRegistry ipdMainRegistry, IpdJobRunner ipdJobRunner, FeatureManager featureManager, ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
        this.ipdMainRegistryLogger = Objects.requireNonNull(ipdMainRegistryLogger);
        this.ipdMainRegistry = ipdMainRegistry;
        this.ipdJobRunner = Objects.requireNonNull(ipdJobRunner);
        this.featureManager = Objects.requireNonNull(featureManager);
    }

    public void start() throws Exception {
        regularLogger.info("Scheduling {} with poll interval of {} seconds", (Object)"IPDMONITORING", (Object)60);
        this.scheduledExecutorService.scheduleAtFixedRate(JiraThreadLocalUtils.wrap(this::ipdEmitterIteration), 0L, 60L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(JiraThreadLocalUtils.wrap(this::ipdCollectorIteration), 30L, this.getCollectorIntervalSeconds().intValue(), TimeUnit.SECONDS);
    }

    @VisibleForTesting
    void ipdEmitterIteration() {
        try {
            this.ipdMainRegistry.unregisterAllDisabledMetrics();
            this.ipdJobRunner.runJobs();
        }
        catch (Exception ex) {
            regularLogger.error("Unable to complete IPD emitting iteration.", (Throwable)ex);
        }
    }

    @VisibleForTesting
    void ipdCollectorIteration() {
        try {
            this.ipdMainRegistryLogger.logRegisteredMetrics(this.isExtraLoggingInfoEnabled());
        }
        catch (Exception ex) {
            regularLogger.error("Unable to complete IPD data logging iteration.", (Throwable)ex);
        }
    }

    private boolean isExtraLoggingInfoEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.IPD_EXTRA_LOGGING);
    }

    private Integer getCollectorIntervalSeconds() {
        int collectorIntervalSeconds = 60;
        String pollingIntervalSecondsString = ComponentAccessor.getApplicationProperties().getDefaultBackedString(COLLECTOR_INTERVAL_PROPERTY_KEY);
        try {
            collectorIntervalSeconds = Integer.parseInt(pollingIntervalSecondsString);
        }
        catch (NumberFormatException nfe) {
            regularLogger.warn("Pooling interval seconds from application properties is not an integer, but: {}", (Object)pollingIntervalSecondsString);
        }
        return collectorIntervalSeconds;
    }
}

