/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.db;

import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdCounterMetric;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.util.profiling.MetricTag;

public class DatabaseConnectionFailuresInProductDiagnosticJob
implements IpdJob {
    private static final long DB_DISCONNECTED_INCREMENT_VALUE = 1L;
    private static final long DB_CONNECTED_INCREMENT_VALUE = 0L;
    private final DatabaseConnectionStateService databaseConnectionStateService;
    private final IpdCounterMetric connectionFailuresMetric;

    public DatabaseConnectionFailuresInProductDiagnosticJob(DatabaseConnectionStateService databaseConnectionStateService, IpdJobRunner inProductDiagnosticScheduler, IpdMainRegistry ipdMainRegistry) {
        this.databaseConnectionStateService = databaseConnectionStateService;
        inProductDiagnosticScheduler.register((IpdJob)this);
        this.connectionFailuresMetric = ipdMainRegistry.counterMetric("db.connection.failures", new MetricTag.RequiredMetricTag[0]);
    }

    public void runJob() {
        DatabaseConnectionStateService.DatabaseConnectionState state = this.databaseConnectionStateService.getState();
        this.connectionFailuresMetric.increment(state == DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED ? 1L : 0L);
    }
}

