/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.db;

import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.wrapper.IpdValueAndStatsMetricWrapper;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabasePoolDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabasePoolDiagnosticProvider;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.util.profiling.MetricTag;
import java.util.Optional;

public class DatabaseConnectionPoolInProductDiagnosticJob
implements IpdJob {
    private final DatabaseConnectionStateService databaseConnectionStateService;
    private final IpdValueAndStatsMetricWrapper idleValueAndStats;
    private final IpdValueAndStatsMetricWrapper activeValueAndStats;

    public DatabaseConnectionPoolInProductDiagnosticJob(DatabaseConnectionStateService databaseConnectionStateService, IpdJobRunner inProductDiagnosticScheduler, IpdMainRegistry ipdMainRegistry) {
        this.databaseConnectionStateService = databaseConnectionStateService;
        inProductDiagnosticScheduler.register((IpdJob)this);
        IpdMetricRegistry registry = ipdMainRegistry.createRegistry("db.connection.pool", new MetricTag.RequiredMetricTag[0]);
        this.idleValueAndStats = registry.valueAndStatsMetric("numIdle", new MetricTag.RequiredMetricTag[0]);
        this.activeValueAndStats = registry.valueAndStatsMetric("numActive", new MetricTag.RequiredMetricTag[0]);
    }

    public void runJob() {
        DatabaseConnectionStateService.DatabaseConnectionState dbState = this.databaseConnectionStateService.getState();
        DatabasePoolDiagnostic diagnostic = this.getDiagnostics();
        if (dbState == DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED || diagnostic.isEmpty()) {
            this.activeValueAndStats.updateValue(Long.valueOf(-1L));
            this.idleValueAndStats.updateValue(Long.valueOf(-1L));
            return;
        }
        this.activeValueAndStats.update(Long.valueOf(diagnostic.getActiveConnections()));
        this.idleValueAndStats.update(Long.valueOf(diagnostic.getIdleConnections()));
    }

    private DatabasePoolDiagnostic getDiagnostics() {
        return Optional.ofNullable(ComponentAccessor.getOSGiComponentInstanceOfType(DatabasePoolDiagnosticProvider.class)).map(DatabasePoolDiagnosticProvider::getDiagnostic).orElse(DatabasePoolDiagnostic.EMPTY);
    }
}

