/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.filesystem;

import com.atlassian.jira.ipd.filesystem.IpdFileWriteLatencyMeter;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;

public class IpdLocalFileWriteLatencyMeter
extends IpdFileWriteLatencyMeter {
    private final File file;

    public IpdLocalFileWriteLatencyMeter(File file, int numberOfMeasurements) {
        super(numberOfMeasurements);
        this.file = file;
    }

    /*
     * Loose catch block
     */
    @Override
    protected Duration measureWriteLatency() throws IOException {
        Files.createParentDirs((File)this.file);
        try {
            try (FileOutputStream fileStream = new FileOutputStream(this.file);){
                long start = System.nanoTime();
                fileStream.write(SAMPLE_DATA);
                fileStream.getFD().sync();
                long end = System.nanoTime();
                Duration duration = Duration.ofNanos(end - start);
                return duration;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                this.file.delete();
            }
            catch (Exception exception) {}
        }
    }
}

