/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.filesystem;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.wrapper.IpdValueAndStatsMetricWrapper;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.ipd.IpdExecutors;
import com.atlassian.jira.ipd.filesystem.IpdFileWriteLatencyMeter;
import com.atlassian.jira.ipd.filesystem.IpdSharedFileWriteLatencyMeter;
import com.atlassian.util.profiling.MetricTag;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SharedHomeLatencyIpdJob
implements IpdJob {
    private static final int TIMEOUT = 15;
    private static final int NUM_OF_MEASUREMENTS = 3;
    private final IpdValueAndStatsMetricWrapper sharedHomeLatency;
    private final ClusterService clusterService;
    private final IpdFileWriteLatencyMeter ipdFileWriteLatencyMeter;
    private final ExecutorService executorService;

    public SharedHomeLatencyIpdJob(IpdJobRunner ipdJobRunner, FileStores fileStores, IpdMainRegistry ipdMainRegistry, ClusterService clusterService, IpdExecutors ipdExecutors) {
        this(ipdJobRunner, ipdMainRegistry, clusterService, ipdExecutors.createSingleTaskExecutorService("ipd-shared-home"), new IpdSharedFileWriteLatencyMeter(SharedHomeLatencyIpdJob.getSharedTmpFile(fileStores, clusterService), 3));
    }

    @VisibleForTesting
    SharedHomeLatencyIpdJob(IpdJobRunner ipdJobRunner, IpdMainRegistry ipdMainRegistry, ClusterService clusterService, ExecutorService executorService, IpdFileWriteLatencyMeter ipdFileWriteLatencyMeter) {
        this.clusterService = clusterService;
        ipdJobRunner.register((IpdJob)this);
        this.sharedHomeLatency = ipdMainRegistry.valueAndStatsMetric("home.shared.write.latency", new MetricTag.RequiredMetricTag[0]);
        this.executorService = executorService;
        this.ipdFileWriteLatencyMeter = ipdFileWriteLatencyMeter;
    }

    public void runJob() {
        if (!this.clusterService.isAvailable()) {
            return;
        }
        Future<List> measurementFuture = null;
        try {
            measurementFuture = this.executorService.submit(this.ipdFileWriteLatencyMeter::makeWriteLatencyMeasurements);
            List<Long> latenciesInMillis = measurementFuture.get(15L, TimeUnit.SECONDS).stream().map(Duration::toMillis).collect(Collectors.toList());
            latenciesInMillis.forEach(arg_0 -> ((IpdValueAndStatsMetricWrapper)this.sharedHomeLatency).updateStats(arg_0));
            this.sharedHomeLatency.updateValue(Long.valueOf(IpdFileWriteLatencyMeter.getMedian(latenciesInMillis)));
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.sharedHomeLatency.updateValue(Long.valueOf(-1L));
        }
        finally {
            if (measurementFuture != null) {
                measurementFuture.cancel(true);
            }
        }
    }

    private static FileStore.Path getSharedTmpFile(FileStores fileStores, ClusterService clusterService) {
        return fileStores.getHomePath().path(new String[]{"tmp", "latency-check-" + clusterService.getNodeId() + ".tmp"});
    }
}

