/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.http;

import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.wrapper.IpdValueAndStatsMetricWrapper;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.ipd.http.HttpActiveSessionsService;
import com.atlassian.util.profiling.MetricTag;

public class HttpActiveSessionInProductDiagnosticJob
implements IpdJob {
    private final IpdValueAndStatsMetricWrapper valueAndStatsActiveSessions;
    private final HttpActiveSessionsService httpActiveSessionsService;

    public HttpActiveSessionInProductDiagnosticJob(IpdJobRunner inProductDiagnosticScheduler, HttpActiveSessionsService httpActiveSessionsService, IpdMainRegistry ipdMainRegistry) {
        this.httpActiveSessionsService = httpActiveSessionsService;
        inProductDiagnosticScheduler.register((IpdJob)this);
        this.valueAndStatsActiveSessions = ipdMainRegistry.valueAndStatsMetric("http.connection.sessions.active", new MetricTag.RequiredMetricTag[0]);
    }

    public void runJob() {
        Long activeSessions = this.httpActiveSessionsService.getActiveSessions();
        if (activeSessions != -1L) {
            this.valueAndStatsActiveSessions.updateStats(activeSessions);
        }
        this.valueAndStatsActiveSessions.updateValue(activeSessions);
    }
}

