/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.http;

import com.atlassian.core.util.Clock;
import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdValueMetric;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.atlassian.util.profiling.MetricTag;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;

public class HttpRecentSessionsInProductDiagnosticJob
implements IpdJob {
    private static final int RECENTLY_ACTIVE_SESSIONS_PERIOD_IN_MINUTES = 60;
    private final JiraUserSessionTracker jiraUserSessionTracker;
    private final Clock clock;
    private final IpdValueMetric recentHttpSessionsMetric;

    public HttpRecentSessionsInProductDiagnosticJob(IpdJobRunner inProductDiagnosticScheduler, JiraUserSessionTracker jiraUserSessionTracker, Clock clock, IpdMainRegistry ipdMainRegistry) {
        this.jiraUserSessionTracker = jiraUserSessionTracker;
        this.clock = clock;
        inProductDiagnosticScheduler.register((IpdJob)this);
        this.recentHttpSessionsMetric = ipdMainRegistry.valueMetric("http.connection.sessions.recent", new MetricTag.RequiredMetricTag[0]);
    }

    public void runJob() {
        long recentSessions = this.getRecentlyActiveSessionsCount();
        this.recentHttpSessionsMetric.update(Long.valueOf(recentSessions));
    }

    private long getRecentlyActiveSessionsCount() {
        List<JiraUserSession> sessions = this.jiraUserSessionTracker.getSnapshot();
        Instant currentTime = this.clock.getCurrentDate().toInstant();
        Instant startTime = currentTime.minus(60L, ChronoUnit.MINUTES);
        return sessions.stream().map(JiraUserSession::getLastAccessTime).filter(Objects::nonNull).filter(lastAccess -> lastAccess.toInstant().isAfter(startTime)).count();
    }
}

