/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.mail;

import com.atlassian.mail.server.MailServer;
import java.util.Properties;
import javax.mail.Session;

interface ConnectionVerifier {
    public void verifyConnection(MailServer var1) throws Exception;

    public static Session cloneSessionWithMaxTimeout(Session session, long maxTimeout) {
        Properties props = (Properties)session.getProperties().clone();
        String protocol = props.getProperty("mail.transport.protocol");
        String connectionTimeout = String.format("mail.%s.connectiontimeout", protocol);
        String socketTimeout = String.format("mail.%s.timeout", protocol);
        ConnectionVerifier.optionallyOverrideTimeout(props, connectionTimeout, maxTimeout);
        ConnectionVerifier.optionallyOverrideTimeout(props, socketTimeout, maxTimeout);
        return Session.getInstance((Properties)props, null);
    }

    public static void optionallyOverrideTimeout(Properties properties, String propertyName, long maxTimeout) {
        String property = properties.getProperty(propertyName);
        if (property == null) {
            properties.setProperty(propertyName, String.valueOf(maxTimeout));
            return;
        }
        try {
            long currentTimeout = Long.parseLong(property);
            if (Long.parseLong(property) > maxTimeout) {
                properties.setProperty(propertyName, String.valueOf(maxTimeout));
            }
        }
        catch (NumberFormatException e) {
            properties.setProperty(propertyName, String.valueOf(maxTimeout));
        }
    }
}

