/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.mail;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ipd.mail.ConnectionVerifier;
import com.atlassian.mail.MailException;
import com.atlassian.mail.auth.JiraMailOAuth2Credentials;
import com.atlassian.mail.msgraph.service.ExternalMailPuller;
import com.atlassian.mail.msgraph.settings.dto.MailSettingsDTO;
import com.atlassian.mail.msgraph.settings.providers.MicrosoftOAuthMailConnectionSettingsProvider;
import com.atlassian.mail.server.AbstractMSGraphMailServer;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.AuthenticationContextAware;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenStorageService;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncomingConnectionVerifier
implements ConnectionVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIncomingConnectionVerifier.class);
    private static final long MAX_TIMEOUT = 10000L;
    private static final long OAUTH_REFRESH_DURATION_IN_MIN = 5L;
    private final ClientTokenStorageService clientTokenStorageService;
    private final TokenHandler tokenHandler;
    private final Function<MailServer, MicrosoftOAuthMailConnectionSettingsProvider> createProvider;

    @VisibleForTesting
    DefaultIncomingConnectionVerifier(ClientTokenStorageService clientTokenStorageService, TokenHandler tokenHandler, Function<MailServer, MicrosoftOAuthMailConnectionSettingsProvider> createProvider) {
        this.clientTokenStorageService = clientTokenStorageService;
        this.tokenHandler = tokenHandler;
        this.createProvider = createProvider;
    }

    public DefaultIncomingConnectionVerifier() {
        this.clientTokenStorageService = (ClientTokenStorageService)ComponentAccessor.getOSGiComponentInstanceOfType(ClientTokenStorageService.class);
        this.tokenHandler = (TokenHandler)ComponentAccessor.getOSGiComponentInstanceOfType(TokenHandler.class);
        this.createProvider = this::defaultCreateProvider;
    }

    @Override
    public void verifyConnection(MailServer mailServer) throws Exception {
        try {
            if (mailServer instanceof AbstractMSGraphMailServer) {
                this.doVerifyMSGraphServer(mailServer);
            } else {
                this.doVerify(mailServer);
            }
        }
        catch (Exception ex) {
            throw new MailException("Failed to connect to incoming mail server", (Throwable)ex);
        }
    }

    private void doVerify(MailServer server) throws NamingException, MailException, MessagingException {
        try (Store store = this.getStore(server);){
            if (server instanceof AuthenticationContextAware) {
                ((AuthenticationContextAware)server).smartConnect((Service)store);
            } else {
                store.connect(server.getHostname(), Integer.parseInt(server.getPort()), server.getUsername(), server.getPassword());
            }
            DefaultIncomingConnectionVerifier.verifyAccess(store);
        }
    }

    private void doVerifyMSGraphServer(MailServer server) throws MailException {
        MicrosoftOAuthMailConnectionSettingsProvider provider = this.createProvider.apply(server);
        Option httpMailClientOption = provider.getHttpMailClient();
        if (!httpMailClientOption.isDefined()) {
            throw new MailException("HTTP mail client is not defined.");
        }
        ExternalMailPuller mailClient = (ExternalMailPuller)httpMailClientOption.get();
        Either either = mailClient.verifyConnection();
        if (either.isLeft()) {
            throw new MailException("Failed to verify MSGraph mail server connection.", (Throwable)either.left().get());
        }
    }

    private Option<String> getOAuthToken(String tokenId) {
        Optional token = this.clientTokenStorageService.getById(tokenId);
        if (!token.isPresent()) {
            LOG.debug("Token with id {} cannot be found", (Object)tokenId);
            return Option.none();
        }
        try {
            ClientToken refreshedToken = this.tokenHandler.getRefreshedToken(tokenId, Duration.ofMinutes(5L));
            return Option.some((Object)refreshedToken.getAccessToken());
        }
        catch (UnrecoverableTokenException e) {
            LOG.debug("OAuth token is unrecoverable - manual re-authorisation required", (Throwable)e);
            return Option.none();
        }
        catch (RecoverableTokenException e) {
            LOG.debug("Recoverable exception fetching OAuth token", (Throwable)e);
            return Option.none();
        }
    }

    private static void verifyAccess(Store store) throws MessagingException {
        store.getFolder("INBOX").open(1);
    }

    private Store getStore(MailServer mailServer) throws NamingException, MailException, NoSuchProviderException {
        Session session = ConnectionVerifier.cloneSessionWithMaxTimeout(mailServer.getSession(), 10000L);
        if (mailServer instanceof AuthenticationContextAware) {
            return session.getStore(new URLName(mailServer.getMailProtocol().getProtocol(), null, Integer.parseInt(mailServer.getPort()), null, null, null));
        }
        return session.getStore(mailServer.getMailProtocol().getProtocol());
    }

    private MicrosoftOAuthMailConnectionSettingsProvider defaultCreateProvider(MailServer server) {
        AuthenticationContext authenticationContext = ((AbstractMSGraphMailServer)server).getAuthenticationContext();
        JiraMailOAuth2Credentials credentials = (JiraMailOAuth2Credentials)authenticationContext.getCredentials();
        MailSettingsDTO mailSettingsDTO = new MailSettingsDTO(0, server.getUsername(), 0L, 10000L, "inbox");
        return new MicrosoftOAuthMailConnectionSettingsProvider(mailSettingsDTO, () -> this.getOAuthToken(credentials.getTokenId()));
    }
}

