/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving.query;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QOSPropertyDate;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArchiveQuery {
    private final List<QueryClause> clauses;
    private final int maxResults;
    private static final QIssue Q_ISSUE = new QIssue("issue");
    private static final QOSPropertyDate Q_ARCHIVED_DATE_VALUE = new QOSPropertyDate("date_value");
    private static final QOSPropertyNumber Q_ARCHIVED_BY_VALUE = new QOSPropertyNumber("by_value");
    private static final ClauseType<Project[]> PROJECTS = projects -> ArchiveQuery.Q_ISSUE.project.in(ArchiveQuery.extract(projects, Project::getId));
    private static final ClauseType<IssueType[]> ISSUE_TYPE = issueTypes -> ArchiveQuery.Q_ISSUE.type.in(ArchiveQuery.extract(issueTypes, IssueConstant::getId));
    private static final ClauseType<ApplicationUser[]> REPORTER = reporters -> ArchiveQuery.Q_ISSUE.reporter.in(ArchiveQuery.extract(reporters, ApplicationUser::getKey));
    private static final ClauseType<ApplicationUser[]> ARCHIVED_BY = archivedBy -> ArchiveQuery.Q_ISSUE.archivedby.in(ArchiveQuery.extract(archivedBy, ApplicationUser::getKey)).or((Predicate)ArchiveQuery.Q_ARCHIVED_BY_VALUE.value.in(ArchiveQuery.extract(archivedBy, WithId::getId)));
    private static final ClauseType<Timestamp> ARCHIVED_AFTER = archivedAfter -> ArchiveQuery.Q_ISSUE.archiveddate.coalesce(new Expression[]{ArchiveQuery.Q_ARCHIVED_DATE_VALUE.value}).getValue().goe((Comparable)archivedAfter);
    private static final ClauseType<Timestamp> ARCHIVED_BEFORE = archivedBefore -> ArchiveQuery.Q_ISSUE.archiveddate.coalesce(new Expression[]{ArchiveQuery.Q_ARCHIVED_DATE_VALUE.value}).getValue().loe((Comparable)archivedBefore);

    private ArchiveQuery(List<QueryClause> clauses, int maxResults) {
        this.clauses = ImmutableList.copyOf(clauses);
        this.maxResults = maxResults;
    }

    protected Collection<QueryClause> getClauses() {
        return this.clauses;
    }

    public List<Project> getProjects() {
        return this.clauses.stream().filter(clause -> ((QueryClause)clause).type.equals(PROJECTS)).map(clause -> Arrays.asList((Project[])((QueryClause)clause).value)).findFirst().orElse(Collections.emptyList());
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean isEmpty() {
        return this.clauses.isEmpty();
    }

    public String toString() {
        return "ArchiveQuery{clauses=" + this.clauses + ", maxResults=" + this.maxResults + '}';
    }

    private static <T, D> Collection<T> extract(D[] values, Function<D, T> function) {
        return Stream.of(values).map(function).collect(Collectors.toList());
    }

    public static class Builder {
        private List<QueryClause> clauses = new ArrayList<QueryClause>();
        private int maxResults = Integer.MAX_VALUE;

        public Builder project(Project ... projects) {
            this.clauses.add(new QueryClause(PROJECTS, projects.length == 0 ? null : projects));
            return this;
        }

        public Builder archivedAfter(Timestamp archivedAfter) {
            this.clauses.add(new QueryClause(ARCHIVED_AFTER, archivedAfter));
            return this;
        }

        public Builder archivedBefore(Timestamp archivedBefore) {
            this.clauses.add(new QueryClause(ARCHIVED_BEFORE, archivedBefore));
            return this;
        }

        public Builder archivedBy(ApplicationUser ... archivedBys) {
            this.clauses.add(new QueryClause(ARCHIVED_BY, archivedBys.length == 0 ? null : archivedBys));
            return this;
        }

        public Builder reporter(ApplicationUser ... reporters) {
            this.clauses.add(new QueryClause(REPORTER, reporters.length == 0 ? null : reporters));
            return this;
        }

        public Builder issueType(IssueType ... issueTypes) {
            this.clauses.add(new QueryClause(ISSUE_TYPE, issueTypes.length == 0 ? null : issueTypes));
            return this;
        }

        public Builder maxResults(int maxResults) {
            this.maxResults = maxResults > 0 ? maxResults : Integer.MAX_VALUE;
            return this;
        }

        public ArchiveQuery build() {
            return new ArchiveQuery(this.clauses.stream().filter(QueryClause::isValid).collect(Collectors.toList()), this.maxResults);
        }
    }

    protected static class QueryClause<T> {
        private ClauseType<T> type;
        private T value;

        private QueryClause(ClauseType<T> type, T value) {
            this.type = type;
            this.value = value;
        }

        public BooleanExpression toExpression() {
            return this.isValid() ? this.type.toExpression(this.value) : null;
        }

        public boolean isValid() {
            return this.value != null;
        }
    }

    static interface ClauseType<T> {
        public BooleanExpression toExpression(T var1);
    }
}

