/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.filestore.FileStoreAnalyticInfo;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.StreamAttachmentStoreStats;
import com.atlassian.jira.util.RuntimeIOException;
import com.google.common.base.Stopwatch;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;

@ThreadSafe
public class AttachmentFileGetData
implements AttachmentGetData {
    final FileStore.Path fileStorePath;
    private final StreamAttachmentStoreStats streamAttachmentStoreStats;
    private final FileStoreAnalyticInfo fileStoreAnalyticInfo;
    private InputStream inputStream;
    private boolean closed;
    private final ReentrantLock lock = new ReentrantLock();

    public AttachmentFileGetData(FileStore.Path fileStorePath) {
        this(fileStorePath, null, null);
    }

    public AttachmentFileGetData(FileStore.Path fileStorePath, @Nullable StreamAttachmentStoreStats streamAttachmentStoreStats, @Nullable FileStoreAnalyticInfo fileStoreAnalyticInfo) {
        this.fileStorePath = Objects.requireNonNull(fileStorePath, "fileStorePath");
        this.streamAttachmentStoreStats = streamAttachmentStoreStats;
        this.fileStoreAnalyticInfo = fileStoreAnalyticInfo;
    }

    public FileStore.Path getFile() {
        return this.fileStorePath;
    }

    public void close() {
        InputStream prevValue;
        this.lock.lock();
        try {
            prevValue = this.inputStream;
            this.inputStream = null;
            this.closed = true;
        }
        finally {
            this.lock.unlock();
        }
        if (prevValue != null) {
            IOUtils.closeQuietly((InputStream)prevValue);
        }
    }

    @Override
    public long getSize() {
        try {
            return this.fileStorePath.getFileSize().getBytes();
        }
        catch (IOException e) {
            throw new DataAccessException("Error getting file size of " + this.fileStorePath.getPathName(), (Throwable)e);
        }
    }

    @Override
    public InputStream getInputStream() {
        this.lock.lock();
        try {
            if (this.inputStream != null) {
                throw new IllegalStateException("Input stream already obtained");
            }
            if (this.closed) {
                throw new IllegalStateException("This object was already closed");
            }
            try {
                if (this.streamAttachmentStoreStats != null) {
                    Stopwatch timer = Stopwatch.createStarted();
                    this.inputStream = new AttachmentStatsInputStream(this.fileStorePath.fileReader().openInputStream(), timer);
                } else {
                    this.inputStream = this.fileStorePath.fileReader().openInputStream();
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            InputStream inputStream = this.inputStream;
            return inputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    public class AttachmentStatsInputStream
    extends FilterInputStream {
        private final Stopwatch timer;
        private long totalLength;
        private Duration ttfb;

        public AttachmentStatsInputStream(InputStream input, Stopwatch timer) {
            super(input);
            this.totalLength = 0L;
            this.timer = timer;
        }

        @Override
        public synchronized int read() throws IOException {
            int result = super.read();
            this.updateStats(result, 1);
            return result;
        }

        @Override
        public synchronized int read(@Nonnull byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            this.updateStats(result, result);
            return result;
        }

        private void updateStats(int readResult, int length) {
            if (this.totalLength == 0L) {
                this.ttfb = this.timer.elapsed();
            }
            if (readResult == -1 && AttachmentFileGetData.this.streamAttachmentStoreStats != null) {
                AttachmentFileGetData.this.streamAttachmentStoreStats.getAttachmentData(this.ttfb, this.timer.elapsed(), this.totalLength, AttachmentFileGetData.this.fileStoreAnalyticInfo);
            } else {
                this.totalLength += (long)length;
            }
        }
    }
}

