/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.AttachmentsDisabledException;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.issue.attachment.StoreAttachmentBeanMapper;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.web.util.AttachmentException;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultAttachmentStore
implements AttachmentStore {
    private final AttachmentDirectoryAccessor directoryAccessor;
    private final StreamAttachmentStore streamAttachmentStore;
    private final ThumbnailAccessor thumbnailAccessor;

    public DefaultAttachmentStore(AttachmentDirectoryAccessor directoryAccessor, AttachmentKeyMapper attachmentKeyMapper, StoreAttachmentBeanMapper storeAttachmentBeanMapper, StreamAttachmentStore streamAttachmentStore, ThumbnailAccessor thumbnailAccessor) {
        this.directoryAccessor = Objects.requireNonNull(directoryAccessor);
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
        this.thumbnailAccessor = Objects.requireNonNull(thumbnailAccessor);
    }

    @Nonnull
    public File getThumbnailDirectory(Issue issue) {
        return this.directoryAccessor.getThumbnailDirectory(issue);
    }

    public File getAttachmentDirectory(Issue issue, boolean createDirectory) {
        return this.directoryAccessor.getAttachmentDirectory(issue, createDirectory);
    }

    @Nonnull
    public File getTemporaryAttachmentDirectory() {
        return this.directoryAccessor.getTemporaryAttachmentDirectory();
    }

    public File getAttachmentDirectory(String attachmentDirectory, String projectKey, String issueKey) {
        return this.directoryAccessor.getAttachmentDirectory(attachmentDirectory, projectKey, issueKey);
    }

    public File getAttachmentFile(Issue issue, Attachment attachment) throws DataAccessException {
        try {
            return ((FilesystemPath)this.streamAttachmentStore.getAttachmentPath(attachment)).asJavaFile();
        }
        catch (AttachmentsDisabledException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public File getAttachmentFile(AttachmentStore.AttachmentAdapter adapter, File attachmentDir) {
        return FileAttachments.getAttachmentFileFromIssueDirectory(adapter, attachmentDir);
    }

    @Nonnull
    public File getThumbnailFile(Attachment attachment) {
        return ((FilesystemPath)this.thumbnailAccessor.getThumbnailFilePath(attachment)).asJavaFile();
    }

    @Nonnull
    public File getThumbnailFile(Issue issue, Attachment attachment) {
        return ((FilesystemPath)this.thumbnailAccessor.getThumbnailFilePath(issue, attachment)).asJavaFile();
    }

    public File getLegacyThumbnailFile(Attachment attachment) {
        return this.thumbnailAccessor.getLegacyThumbnailFile(attachment);
    }

    public void checkValidAttachmentDirectory(Issue issue) throws AttachmentException {
        this.directoryAccessor.checkValidAttachmentDirectory(issue);
    }

    public void checkValidTemporaryAttachmentDirectory() throws AttachmentException {
        this.directoryAccessor.checkValidTemporaryAttachmentDirectory();
    }
}

