/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemAccess;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentCopyException;
import com.atlassian.jira.issue.attachment.AttachmentFileGetData;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.AttachmentKeys;
import com.atlassian.jira.issue.attachment.AttachmentMoveException;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.AttachmentsDisabledException;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.StreamAttachmentStoreStats;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.store.LocalTemporaryFileStore;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ExecutorServiceWrapper;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultStreamAttachmentStore
implements StreamAttachmentStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultStreamAttachmentStore.class);
    private final AttachmentConfigStore attachmentConfigStore;
    private final AttachmentKeyMapper attachmentKeyMapper;
    private final EventPublisher eventPublisher;
    private final ExecutorServiceWrapper managedExecutor;
    private final LocalTemporaryFileStore localTemporaryFileStore;
    private final ProjectManager projectManager;
    private final StreamAttachmentStoreStats streamAttachmentStoreStats;

    public DefaultStreamAttachmentStore(AttachmentConfigStore attachmentConfigStore, AttachmentKeyMapper attachmentKeyMapper, EventPublisher eventPublisher, ExecutorServiceWrapper managedExecutor, LocalTemporaryFileStore localTemporaryFileStore, ProjectManager projectManager, StreamAttachmentStoreStats streamAttachmentStoreStats) {
        this.attachmentConfigStore = Objects.requireNonNull(attachmentConfigStore);
        this.attachmentKeyMapper = Objects.requireNonNull(attachmentKeyMapper);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.localTemporaryFileStore = Objects.requireNonNull(localTemporaryFileStore);
        this.managedExecutor = Objects.requireNonNull(managedExecutor);
        this.projectManager = Objects.requireNonNull(projectManager);
        this.streamAttachmentStoreStats = Objects.requireNonNull(streamAttachmentStoreStats);
    }

    @Override
    public Promise<StoreAttachmentResult> putAttachment(StoreAttachmentBean storeAttachmentBean) {
        InputStream dataStream = storeAttachmentBean.getStream();
        AttachmentKey attachmentKey = storeAttachmentBean.getAttachmentKey();
        return this.putAttachment(dataStream, storeAttachmentBean.getSize(), attachmentKey);
    }

    private Promise<StoreAttachmentResult> putAttachment(InputStream inputStream, Long size, AttachmentKey attachmentKey) {
        return this.putTemporaryAttachment(inputStream, size).flatMap(temporaryAttachmentId -> this.moveTemporaryToAttachment((TemporaryAttachmentId)temporaryAttachmentId, attachmentKey).flatMap(input -> Promises.promise((Object)StoreAttachmentResult.created())));
    }

    @Override
    public <A> Promise<A> getAttachment(AttachmentKey attachmentKey, Function<InputStream, A> inputStreamProcessor) {
        return this.getAttachmentData(attachmentKey, attachmentGetData -> inputStreamProcessor.apply(attachmentGetData.getInputStream()));
    }

    @Override
    public <A> Promise<A> getAttachmentData(AttachmentKey attachmentKey, Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        FileStore.Path attachmentFile;
        try {
            attachmentFile = this.getAttachmentPath(attachmentKey);
        }
        catch (AttachmentsDisabledException e) {
            return Promises.rejected((Throwable)new NoAttachmentDataException((Throwable)e));
        }
        if (!attachmentFile.tryFileExists()) {
            return Promises.rejected((Throwable)new NoAttachmentDataException("Attachment does not exist " + attachmentFile));
        }
        return this.managedExecutor.submit(() -> {
            try (AttachmentFileGetData attachmentGetData = new AttachmentFileGetData(attachmentFile, this.streamAttachmentStoreStats, this.attachmentConfigStore.getFileStoreAnalyticInfo());){
                Object r = attachmentGetDataProcessor.apply(attachmentGetData);
                return r;
            }
        });
    }

    @Override
    public FileStore.Path getAttachmentPath(Attachment attachment) {
        return this.getAttachmentPath(this.attachmentKeyMapper.fromAttachment(attachment));
    }

    @Override
    public FileStore.Path getAttachmentPath(AttachmentKey attachmentKey) throws AttachmentsDisabledException {
        Optional<FileStore.Path> rootAttachmentPath = this.attachmentConfigStore.getConfig().getAttachmentPath();
        return rootAttachmentPath.map(attachmentPath -> FileAttachments.getAttachmentPathFromRoot(attachmentKey, attachmentPath)).orElseThrow(() -> new AttachmentsDisabledException("Path cannot be found because attachments are disabled"));
    }

    @Override
    public Promise<Unit> deleteAttachmentContainerForIssue(Issue issue) {
        Objects.requireNonNull(issue);
        Optional<FileStore.Path> attachmentPath = this.getAttachmentPathForIssue(issue);
        return attachmentPath.filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).map(file -> {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
            }
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.ATTACHMENT, (File)file));
            return Promises.promise((Object)Unit.VALUE);
        }).orElse(Promises.rejected((Throwable)new AttachmentCleanupException("Invalid attachment path " + attachmentPath)));
    }

    @Override
    public Optional<FileStore.Path> getAttachmentPathForIssue(Issue issue) {
        return Optional.ofNullable(issue.getProjectObject()).flatMap(project -> this.attachmentConfigStore.getConfig().getAttachmentPath().map(rootPath -> FileAttachments.getAttachmentDirectoryForIssue(rootPath, project.getOriginalKey(), issue.getKey())));
    }

    @Override
    public FileStore.Path getAttachmentPath(FileStore.Path rootAttachmentPath, String projectKey, String issueKey) {
        String projectOriginalKey = Optional.ofNullable(this.projectManager.getProjectObjByKey(projectKey)).map(Project::getOriginalKey).orElse(projectKey);
        return FileAttachments.getAttachmentDirectoryForIssue(rootAttachmentPath, projectOriginalKey, issueKey);
    }

    @Override
    public Promise<Void> move(Attachment attachment, String newIssueKey) {
        AttachmentKey oldAttachmentKey = this.attachmentKeyMapper.fromAttachment(attachment);
        IssueKey ik = IssueKey.from((String)newIssueKey);
        Project project = this.projectManager.getProjectObjByKey(ik.getProjectKey());
        String originalProjectKey = project.getOriginalKey();
        AttachmentKey newAttachmentKey = AttachmentKeys.from(originalProjectKey, newIssueKey, oldAttachmentKey.getAttachmentFilename(), oldAttachmentKey.getAttachmentId());
        return this.moveAttachment(oldAttachmentKey, newAttachmentKey).map(unit -> null);
    }

    @VisibleForTesting
    Promise<Unit> moveAttachment(AttachmentKey oldAttachmentKey, AttachmentKey newAttachmentKey) {
        try {
            FileStore.Path oldAttachmentFile = this.getAttachmentPath(oldAttachmentKey);
            FileStore.Path newAttachmentFile = this.getAttachmentPath(newAttachmentKey);
            return this.moveFile(oldAttachmentFile, newAttachmentFile, false);
        }
        catch (AttachmentsDisabledException e) {
            return Promises.rejected((Throwable)e);
        }
    }

    private Promise<Unit> moveFile(FileStore.Path sourcePath, FileStore.Path destinationPath, boolean isTemporary) {
        if (!sourcePath.tryFileExists()) {
            return Promises.rejected((Throwable)new NoAttachmentDataException("Source file does not exist " + sourcePath));
        }
        try {
            sourcePath.moveFile(destinationPath);
            if (!isTemporary && sourcePath instanceof FilesystemPath) {
                this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.ATTACHMENT, ((FilesystemPath)sourcePath).asJavaFile()));
            }
            if (destinationPath instanceof FilesystemPath) {
                this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.ATTACHMENT, ((FilesystemPath)destinationPath).asJavaFile()));
            }
            return Promises.promise((Object)Unit.VALUE);
        }
        catch (IOException e) {
            log.warn("Unable to create target file {}", (Object)destinationPath);
            return Promises.rejected((Throwable)new AttachmentMoveException());
        }
    }

    @Override
    public Promise<Unit> copyAttachment(AttachmentKey sourceAttachmentKey, AttachmentKey newAttachmentKey) {
        FileStore.Path sourcePath = this.getAttachmentPath(sourceAttachmentKey);
        FileStore.Path destinationPath = this.getAttachmentPath(newAttachmentKey);
        try {
            sourcePath.copyFile(destinationPath);
            if (destinationPath instanceof FilesystemPath) {
                this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.ATTACHMENT, ((FilesystemPath)destinationPath).asJavaFile()));
            }
            return Promises.promise((Object)Unit.VALUE);
        }
        catch (IOException e) {
            return Promises.rejected((Throwable)new AttachmentCopyException((Throwable)e));
        }
    }

    @Override
    public Promise<Unit> deleteAttachment(AttachmentKey attachmentKey) {
        try {
            FileStore.Path attachmentPath = this.getAttachmentPath(attachmentKey);
            if (attachmentPath.tryFileExists()) {
                attachmentPath.deleteFile();
                if (attachmentPath instanceof FilesystemPath) {
                    this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.ATTACHMENT, ((FilesystemPath)attachmentPath).asJavaFile()));
                }
            } else {
                log.warn("Trying to delete non-existent attachment: [{}] ..ignoring", (Object)attachmentPath);
            }
        }
        catch (AttachmentsDisabledException | IOException e) {
            return Promises.rejected((Throwable)new AttachmentCleanupException(e));
        }
        return Promises.promise((Object)Unit.VALUE);
    }

    @Override
    public Promise<TemporaryAttachmentId> putTemporaryAttachment(InputStream inputStream, long size) {
        return this.managedExecutor.submit(() -> this.localTemporaryFileStore.createTemporaryFile(inputStream, size));
    }

    @Override
    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        Either<Exception, File> tempFileEitherException = this.localTemporaryFileStore.getTemporaryAttachmentFile(temporaryAttachmentId);
        return (Promise)tempFileEitherException.fold(Promises::rejected, tempFile -> {
            FilesystemPath tempPath = FilesystemFileStore.forFile((File)tempFile);
            try {
                FileStore.Path destinationPath = this.getAttachmentPath(destinationKey);
                return this.moveFile((FileStore.Path)tempPath, destinationPath, true);
            }
            catch (AttachmentsDisabledException e) {
                return Promises.rejected((Throwable)e);
            }
        });
    }

    @Override
    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        return this.localTemporaryFileStore.deleteTemporaryAttachment(temporaryAttachmentId);
    }

    @Override
    public <A> Promise<A> getTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId, Function<InputStream, A> inputStreamProcessor) {
        File attachmentFile;
        try {
            Either<Exception, File> tempFileEitherException = this.localTemporaryFileStore.getTemporaryAttachmentFile(temporaryAttachmentId);
            if (tempFileEitherException.isLeft()) {
                return Promises.rejected((Throwable)((Throwable)tempFileEitherException.left().get()));
            }
            attachmentFile = (File)tempFileEitherException.right().get();
        }
        catch (DataAccessException e) {
            return Promises.rejected((Throwable)new AttachmentReadException((Throwable)e));
        }
        if (!attachmentFile.exists() || !attachmentFile.isFile()) {
            return Promises.rejected((Throwable)new NoAttachmentDataException("Attachment does not exist in filesystem " + attachmentFile));
        }
        return this.managedExecutor.submit(() -> {
            try (AttachmentFileGetData attachmentGetData = new AttachmentFileGetData((FileStore.Path)FilesystemFileStore.forFile((File)attachmentFile));){
                Object r = inputStreamProcessor.apply(attachmentGetData.getInputStream());
                return r;
            }
        });
    }

    @Override
    public Promise<Boolean> exists(AttachmentKey attachmentKey) {
        try {
            FileStore.Path attachmentPath = this.getAttachmentPath(attachmentKey);
            return Promises.promise((Object)attachmentPath.tryFileExists());
        }
        catch (AttachmentsDisabledException e) {
            return Promises.rejected((Throwable)e);
        }
    }
}

