/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeys;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileAttachments {
    private static final Logger log = LoggerFactory.getLogger(FileAttachments.class);
    private static final long BUCKET_SIZE = 10000L;

    public static FileStore.Path getAttachmentDirectoryForIssue(FileStore.Path rootDir, String originalProjectKey, String issueKey) {
        FileStore.Path projectDir = rootDir.path(new String[]{originalProjectKey});
        FileStore.Path bucketDir = projectDir.path(new String[]{FileAttachments.computeIssueBucketDir(issueKey)});
        return bucketDir.path(new String[]{FileAttachments.computeIssueKeyForOriginalProjectKey(originalProjectKey, issueKey)});
    }

    public static String computeIssueKeyForOriginalProjectKey(String originalProjectKey, String issueKey) {
        long issueNumber = IssueKey.from((String)issueKey).getIssueNumber();
        return IssueKey.format((String)originalProjectKey, (long)issueNumber);
    }

    public static FileStore.Path getAttachmentPathFromRoot(AttachmentKey attachment, FileStore.Path rootAttachmentDir) {
        FileStore.Path attachmentDir = FileAttachments.getAttachmentDirectoryForIssue(rootAttachmentDir, attachment.getProjectKey(), attachment.getIssueKey());
        FileStore.Path defaultFile = FileAttachments.getDefaultAttachmentFile(attachment, attachmentDir);
        if (defaultFile.tryFileExists()) {
            return defaultFile;
        }
        FileStore.Path projectIssueFile = FileAttachments.getProjectIssueFile(attachment, rootAttachmentDir);
        if (projectIssueFile.tryFileExists()) {
            return projectIssueFile;
        }
        FileStore.Path legacyFile = FileAttachments.getLegacyAttachmentFile(attachment, FileAttachments.getProjectIssueDirectory(attachment, rootAttachmentDir));
        if (legacyFile.tryFileExists()) {
            return legacyFile;
        }
        FileStore.Path legacyBucketFile = FileAttachments.getLegacyAttachmentFile(attachment, attachmentDir);
        if (legacyBucketFile.tryFileExists()) {
            return legacyBucketFile;
        }
        FileStore.Path legacyAttachmentById = FileAttachments.findLegacyAttachmentById(attachment, FileAttachments.getProjectIssueDirectory(attachment, rootAttachmentDir));
        if (legacyAttachmentById == null) {
            return defaultFile;
        }
        return legacyAttachmentById;
    }

    @Deprecated
    public static File getAttachmentFileFromIssueDirectory(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        File currentDir;
        String issueKey = attachmentDir.getName();
        String projectKey = IssueKey.from((String)issueKey).getProjectKey();
        AttachmentKey attachmentKey = AttachmentKeys.from(projectKey, issueKey, attachment.getFilename(), attachment.getId());
        for (currentDir = attachmentDir; currentDir != null && !currentDir.getName().equals(projectKey); currentDir = currentDir.getParentFile()) {
        }
        if (currentDir == null) {
            return new File(attachmentDir, Long.toString(attachment.getId()));
        }
        FilesystemPath rootAttachmentDir = FilesystemFileStore.forFile((File)currentDir.getParentFile());
        return ((FilesystemPath)FileAttachments.getAttachmentPathFromRoot(attachmentKey, (FileStore.Path)rootAttachmentDir)).asJavaFile();
    }

    public static String computeIssueBucketDir(@Nonnull String issueKey) {
        long issueNumber = IssueKey.from((String)issueKey).getIssueNumber();
        long issueBucket = ((issueNumber - 1L) / 10000L + 1L) * 10000L;
        return Long.toString(issueBucket);
    }

    private static FileStore.Path findLegacyAttachmentById(AttachmentKey attachment, FileStore.Path attachmentDir) {
        List matchedFiles;
        Pattern allFilesPattern = Pattern.compile("^" + attachment.getAttachmentId() + "_.+");
        try {
            matchedFiles = attachmentDir.getFileDescendents().filter(descendant -> descendant.getLeafName().map(allFilesPattern::matcher).map(Matcher::matches).orElse(false)).collect(Collectors.toList());
        }
        catch (IOException e) {
            return null;
        }
        if (matchedFiles.isEmpty()) {
            return null;
        }
        if (matchedFiles.size() > 1) {
            Pattern thumbnailExcludingPattern = Pattern.compile("^" + attachment.getAttachmentId() + "_(?!thumb_).+");
            List nonThumbnailMatches = matchedFiles.stream().filter(matchedFile -> matchedFile.getLeafName().map(thumbnailExcludingPattern::matcher).map(Matcher::matches).orElse(false)).collect(Collectors.toList());
            if (!nonThumbnailMatches.isEmpty()) {
                if (nonThumbnailMatches.size() > 1) {
                    log.warn("More than one file found for attachment id {} in {}. The first entry will be returned.", (Object)attachment.getAttachmentId(), (Object)attachmentDir);
                }
                return (FileStore.Path)nonThumbnailMatches.get(0);
            }
        }
        return (FileStore.Path)matchedFiles.get(0);
    }

    private static FileStore.Path getProjectIssueFile(AttachmentKey attachment, FileStore.Path rootAttachmentDirectory) {
        return FileAttachments.getProjectIssueDirectory(attachment, rootAttachmentDirectory).path(new String[]{attachment.getAttachmentId().toString()});
    }

    private static FileStore.Path getProjectIssueDirectory(AttachmentKey attachment, FileStore.Path rootAttachmentDirectory) {
        String issueKey = attachment.getIssueKey();
        FileStore.Path baseDirectory = rootAttachmentDirectory.path(new String[]{attachment.getProjectKey()});
        return baseDirectory.path(new String[]{issueKey});
    }

    private static FileStore.Path getDefaultAttachmentFile(AttachmentKey attachment, FileStore.Path attachmentDirectory) {
        return attachmentDirectory.path(new String[]{attachment.getAttachmentId().toString()});
    }

    private static FileStore.Path getLegacyAttachmentFile(AttachmentKey attachment, FileStore.Path attachmentDir) {
        return attachmentDir.path(new String[]{attachment.getAttachmentId() + "_" + attachment.getAttachmentFilename()});
    }

    private FileAttachments() {
    }
}

