/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.AttachmentStorageUnavailableException;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentStorageUnavailableException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.util.AttachmentException;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAttachmentDirectoryAccessor
implements AttachmentDirectoryAccessor {
    private static final Logger log = LoggerFactory.getLogger(FileSystemAttachmentDirectoryAccessor.class);
    protected final ProjectManager projectManager;
    private final AttachmentConfigManager attachmentConfigManager;
    private final AttachmentPathManager attachmentPathManager;
    private final StreamAttachmentStore streamAttachmentStore;

    public FileSystemAttachmentDirectoryAccessor(ProjectManager projectManager, AttachmentPathManager attachmentPathManager, StreamAttachmentStore streamAttachmentStore, AttachmentConfigManager attachmentConfigManager) {
        this.projectManager = projectManager;
        this.attachmentPathManager = attachmentPathManager;
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
    }

    @Override
    @Nonnull
    public File getThumbnailDirectory(@Nonnull Issue issue) {
        return this.getThumbnailDirectory(issue, true);
    }

    @Override
    @Nonnull
    public File getThumbnailDirectory(@Nonnull Issue issue, boolean createDirectory) {
        File thumbDir = new File(this.getAttachmentDirectory(issue, createDirectory), "thumbs");
        if (createDirectory && !thumbDir.exists() && !thumbDir.mkdirs()) {
            log.warn("Unable to make thumbnail directory {}", (Object)thumbDir.getAbsolutePath());
        }
        return thumbDir;
    }

    @Override
    public File getAttachmentDirectory(@Nonnull Issue issue) {
        return this.getAttachmentDirectory(issue, true);
    }

    @Override
    @Nullable
    public File getAttachmentDirectory(@Nonnull String issueKey) {
        IssueKey ik = IssueKey.from((String)issueKey);
        Project project = this.projectManager.getProjectObjByKey(ik.getProjectKey());
        if (project != null) {
            return this.getAttachmentDirectory(this.getAttachmentDirName(), project.getOriginalKey(), IssueKey.format((String)project.getOriginalKey(), (long)ik.getIssueNumber()));
        }
        return null;
    }

    @Override
    public File getAttachmentDirectory(@Nonnull Issue issue, boolean createDirectory) {
        Project project = issue.getProjectObject();
        File directory = this.getAttachmentDirectory(this.getAttachmentDirName(), project.getKey(), issue.getKey());
        if (createDirectory) {
            directory.mkdirs();
        }
        return directory;
    }

    @Override
    @Nonnull
    public File getTemporaryAttachmentDirectory() {
        return this.attachmentConfigManager.getTemporaryAttachmentDirectory();
    }

    @Override
    public File getAttachmentDirectory(String attachmentDirectory, String projectKey, String issueKey) {
        FileStore.Path attachmentPath = this.streamAttachmentStore.getAttachmentPath((FileStore.Path)FilesystemFileStore.forFile((File)new File(attachmentDirectory)), projectKey, issueKey);
        if (!(attachmentPath instanceof FilesystemPath)) {
            throw new AttachmentStorageUnavailableException("Only filesystem paths are supported.");
        }
        return ((FilesystemPath)attachmentPath).asJavaFile();
    }

    @Override
    public void checkValidAttachmentDirectory(Issue issue) throws AttachmentException {
        try {
            File directory = this.getAttachmentDirectory(issue);
            if (!directory.canWrite()) {
                throw new AttachmentStorageUnavailableException(directory.getAbsolutePath());
            }
            this.checkValidTemporaryAttachmentDirectory();
        }
        catch (Exception e) {
            throw new AttachmentStorageUnavailableException((Throwable)e);
        }
    }

    @Override
    public void checkValidTemporaryAttachmentDirectory() throws AttachmentException {
        File tempDirectory = this.getTemporaryAttachmentDirectory();
        if (!tempDirectory.canWrite()) {
            throw new TemporaryAttachmentStorageUnavailableException(tempDirectory.getAbsolutePath());
        }
    }

    private String getAttachmentDirName() {
        String attachmentPath = this.attachmentPathManager.getAttachmentPath();
        return attachmentPath == null ? this.attachmentPathManager.getDefaultAttachmentPath() : attachmentPath;
    }

    @Override
    public File getAttachmentRootPath() {
        return new File(this.getAttachmentDirName());
    }
}

