/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.util.Window;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ChangeHistorySplicer {
    private List<ChangeHistory> history;
    private int hiddenAtStart;
    private int hiddenAtEnd;

    private ChangeHistorySplicer(List<ChangeHistory> history, int hiddenAtStart, int hiddenAtEnd) {
        if (history.isEmpty() && (hiddenAtStart != 0 || hiddenAtEnd != 0)) {
            throw new IllegalArgumentException("Cannot hide sth that does not exists");
        }
        this.history = history;
        this.hiddenAtStart = hiddenAtStart;
        this.hiddenAtEnd = hiddenAtEnd;
    }

    public static ChangeHistorySplicer hideOneAtEnd(List<ChangeHistory> history) {
        if (!history.isEmpty()) {
            return new ChangeHistorySplicer(history, 0, 1);
        }
        return new ChangeHistorySplicer(history, 0, 0);
    }

    public static ChangeHistorySplicer hideOneAtStart(List<ChangeHistory> history) {
        if (!history.isEmpty()) {
            return new ChangeHistorySplicer(history, 1, 0);
        }
        return new ChangeHistorySplicer(history, 0, 0);
    }

    public static ChangeHistorySplicer hideNothing(List<ChangeHistory> history) {
        return new ChangeHistorySplicer(history, 0, 0);
    }

    public Optional<Date> duplicatesFoundAtEnd() {
        Optional<Date> secondToLast;
        Optional<Date> last = this.lastItemDate();
        if (this.optionalsPresentAndEqual(last, secondToLast = this.secondToLastItemDate())) {
            return last;
        }
        return Optional.empty();
    }

    public Optional<Date> duplicatesFoundAtStart() {
        Optional<Date> second;
        Optional<Date> first = this.firstItemDate();
        if (this.optionalsPresentAndEqual(first, second = this.secondItemDate())) {
            return first;
        }
        return Optional.empty();
    }

    private boolean optionalsPresentAndEqual(Optional<Date> a, Optional<Date> b) {
        if (a.isPresent() && b.isPresent()) {
            return a.equals(b);
        }
        return false;
    }

    public void prependWithDistinct(Collection<ChangeHistory> newHistory) {
        this.history = Stream.concat(newHistory.stream(), this.history.stream()).distinct().collect(Collectors.toList());
        this.hiddenAtStart = 0;
    }

    public void appendWithDistinct(Collection<ChangeHistory> newHistory) {
        this.history = Stream.concat(this.history.stream(), newHistory.stream()).distinct().collect(Collectors.toList());
        this.hiddenAtEnd = 0;
    }

    public void append(Collection<ChangeHistory> newHistory) {
        this.history = Stream.concat(this.history.stream(), newHistory.stream()).collect(Collectors.toList());
    }

    public void prepend(Collection<ChangeHistory> newHistory) {
        this.history = Stream.concat(newHistory.stream(), this.history.stream()).collect(Collectors.toList());
    }

    public void appendAndHide(Collection<ChangeHistory> newHistory) {
        this.history = Stream.concat(this.history.stream(), newHistory.stream()).collect(Collectors.toList());
        this.hiddenAtEnd += newHistory.size();
    }

    public void prependAndHide(Collection<ChangeHistory> newHistory) {
        this.history = Stream.concat(newHistory.stream(), this.history.stream()).collect(Collectors.toList());
        this.hiddenAtStart += newHistory.size();
    }

    public Optional<Date> lastItemDate() {
        if (!this.history.isEmpty()) {
            return Optional.of(this.history.get(this.history.size() - 1).getTimePerformed());
        }
        return Optional.empty();
    }

    private Optional<Date> secondToLastItemDate() {
        if (this.history.size() > 1) {
            return Optional.of(this.history.get(this.history.size() - 2).getTimePerformed());
        }
        return Optional.empty();
    }

    private Optional<Date> firstItemDate() {
        if (!this.history.isEmpty()) {
            return Optional.of(this.history.get(0).getTimePerformed());
        }
        return Optional.empty();
    }

    private Optional<Date> secondItemDate() {
        if (this.history.size() > 1) {
            return Optional.of(this.history.get(1).getTimePerformed());
        }
        return Optional.empty();
    }

    public int size() {
        return this.history.size();
    }

    public Window<ChangeHistory> toWindow() {
        return Window.of(this.history).shrinkFromStart(this.history.size() - this.hiddenAtStart).shrinkFromEnd(this.history.size() - (this.hiddenAtStart + this.hiddenAtEnd));
    }
}

