/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.jql.query.IssueIdCollector;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryProjectRoleAndGroupPermissionsDecorator;
import com.atlassian.jira.jql.util.DateRange;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.plugin.jql.function.IssueHistoryFunction;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateHistoryAccessor {
    private final SearchProviderFactory searchProviderFactory;
    private final QueryProjectRoleAndGroupPermissionsDecorator queryPermissionsDecorator;
    private final JqlDateSupport jqlDateSupport;
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryFunction.class);

    public UpdateHistoryAccessor(SearchProviderFactory searchProviderFactory, QueryProjectRoleAndGroupPermissionsDecorator queryPermissionsDecorator, JqlDateSupport jqlDateSupport) {
        this.searchProviderFactory = (SearchProviderFactory)Assertions.notNull((String)"searchProviderFactory", (Object)searchProviderFactory);
        this.queryPermissionsDecorator = (QueryProjectRoleAndGroupPermissionsDecorator)Assertions.notNull((String)"queryPermissionsDecorator", (Object)queryPermissionsDecorator);
        this.jqlDateSupport = (JqlDateSupport)Assertions.notNull((String)"jqlDateSupport", (Object)jqlDateSupport);
    }

    public Set<String> searchForIssues(List<String> userIds, DateRange fromDate, DateRange toDate, QueryCreationContext queryCreationContext) {
        try {
            Assertions.notNull((String)"userIds", userIds);
            Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
            log.debug("search for issues updated by user: %s  dateFrom: %s dateTo: %s ", new Object[]{userIds, fromDate, toDate});
            IssueIdCollector idCollector = this.getIdCollector();
            log.debug("searching change index...");
            this.searchChanges(idCollector, fromDate, toDate, userIds);
            log.debug("searching comments index...");
            this.searchComments(idCollector, fromDate, toDate, userIds, queryCreationContext);
            log.debug("Completed search for issuesUpdatedBy user");
            return idCollector.getIssueIds();
        }
        catch (IOException e) {
            log.error("Error during search for issues updated by user", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    IssueIdCollector getIdCollector() {
        return new IssueIdCollector(BooleanQuery.getMaxClauseCount());
    }

    void searchChanges(IssueIdCollector idCollector, DateRange fromDate, DateRange toDate, List<String> userIds) throws IOException {
        BooleanQuery.Builder mainChangeQuery = new BooleanQuery.Builder();
        ManagedIndexSearcher changeSearcher = this.searchProviderFactory.getSearcher("changes");
        this.addUserAndDatesQuery("ch_date", fromDate, toDate, "ch_who", this.transformKeysForChangeIndexActioner(userIds), mainChangeQuery);
        BooleanQuery boolQuery = mainChangeQuery.build();
        log.debug("executing query: {}", (Object)boolQuery);
        changeSearcher.search((Query)boolQuery, (Collector)idCollector);
    }

    private List<String> transformKeysForChangeIndexActioner(List<String> userIds) {
        return userIds.stream().map(uk -> "ch-" + uk).collect(Collectors.toList());
    }

    private void addUserAndDatesQuery(String dateKey, DateRange fromDate, DateRange toDate, String docKey, List<String> userIds, BooleanQuery.Builder mainChangeQuery) {
        BooleanQuery.Builder userQuery = new BooleanQuery.Builder();
        for (String userKey : userIds) {
            userQuery.add((Query)new TermQuery(new Term(docKey, userKey)), BooleanClause.Occur.SHOULD);
        }
        mainChangeQuery.add((Query)userQuery.build(), BooleanClause.Occur.MUST);
        this.addDatesQuery(fromDate, toDate, mainChangeQuery, dateKey);
    }

    void searchComments(IssueIdCollector idCollector, DateRange fromDate, DateRange toDate, List<String> userIds, QueryCreationContext queryCreationContext) throws IOException {
        BooleanQuery.Builder mainCommentsQuery = new BooleanQuery.Builder();
        ManagedIndexSearcher commentSearcher = this.searchProviderFactory.getSearcher("comments");
        BooleanQuery.Builder commentCreatorQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder commentUpdaterQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder commentUsersQuery = new BooleanQuery.Builder();
        this.addUserAndDatesQuery("comment_created", fromDate, toDate, "comment_author", userIds, commentCreatorQuery);
        this.addUserAndDatesQuery("comment_updated", fromDate, toDate, "comment_update_author", userIds, commentUpdaterQuery);
        commentUsersQuery.add((Query)commentCreatorQuery.build(), BooleanClause.Occur.SHOULD);
        commentUsersQuery.add((Query)commentUpdaterQuery.build(), BooleanClause.Occur.SHOULD);
        mainCommentsQuery.add((Query)commentUsersQuery.build(), BooleanClause.Occur.MUST);
        Query queryWithPermissionFilter = this.queryPermissionsDecorator.appendPermissionFilterQuery((Query)mainCommentsQuery.build(), queryCreationContext, "level", "role_level");
        log.debug("executing query: {}", (Object)queryWithPermissionFilter);
        commentSearcher.search(queryWithPermissionFilter, (Collector)idCollector);
    }

    void addDatesQuery(DateRange fromDate, DateRange toDate, BooleanQuery.Builder mainQuery, String dateFieldName) {
        if (fromDate != null || toDate != null) {
            long fromDateRef = this.getMinimalDateRef();
            long toDateRef = this.getMaximalDateRef();
            if (fromDate != null) {
                fromDateRef = fromDate.getLowerDate().getTime();
            }
            if (toDate != null) {
                toDateRef = toDate.getUpperDate().getTime();
            }
            mainQuery.add(new BooleanClause(LongPoint.newRangeQuery((String)dateFieldName, (long)fromDateRef, (long)(toDateRef - TimeUnit.SECONDS.toMillis(1L))), BooleanClause.Occur.MUST));
        }
    }

    long getMaximalDateRef() {
        return Long.MAX_VALUE;
    }

    long getMinimalDateRef() {
        return 0L;
    }
}

