/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentOrderManager;
import com.atlassian.jira.plugin.issuetabpanel.TabPanelOrder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import java.util.Collections;
import java.util.List;

public class CommentOrderManagerImpl
implements CommentOrderManager {
    private final CommentManager commentManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;

    public CommentOrderManagerImpl(CommentManager commentManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.commentManager = commentManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = (UserPreferencesManager)ComponentAccessor.getComponentOfType(UserPreferencesManager.class);
    }

    @Override
    public void setIssueCommentsOrder(TabPanelOrder order) throws AtlassianCoreException {
        this.getUserPreferences().setString("user.issue.comments.order", order.asText());
    }

    @Override
    public TabPanelOrder getIssueCommentsOrder() {
        String order = this.getUserPreferences().getString("user.issue.comments.order");
        if (order == null) {
            return TabPanelOrder.NEWEST_FIRST;
        }
        return TabPanelOrder.fromString((String)order);
    }

    @Override
    public List<Comment> getSortedComments(Issue issue, ApplicationUser user) {
        List comments = this.commentManager.getCommentsForUser(issue, user);
        if (TabPanelOrder.NEWEST_FIRST == this.getIssueCommentsOrder()) {
            Collections.reverse(comments);
        }
        return comments;
    }

    private Preferences getUserPreferences() {
        return this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getLoggedInUser());
    }
}

