/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments.pin;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.comments.pin.CommentPinManager;
import com.atlassian.jira.model.querydsl.CommentPinDTO;
import com.atlassian.jira.model.querydsl.QCommentPin;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ofbiz.core.entity.GenericValue;

public class DefaultCommentPinManager
implements CommentPinManager,
Startable {
    private static final String SD_PIN_COMMENT_FEATURE_FLAG = "sd.comment.pin";
    private final QueryDslAccessor dslAccessor;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    public DefaultCommentPinManager(QueryDslAccessor dslAccessor, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, FeatureManager featureManager) {
        this.dslAccessor = dslAccessor;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onCommentDeleted(CommentDeletedEvent event) {
        if (Objects.nonNull(event.getComment())) {
            this.unpinComment(event.getComment().getId());
        }
    }

    @Override
    public CommentPinDTO pinComment(long issueId, long commentId, String userKey, Instant created) {
        CommentPinDTO commentPinDTO = CommentPinDTO.builder().issueId(issueId).commentId(commentId).pinnedBy(userKey).pinnedDate(Timestamp.from(created)).build();
        GenericValue value = this.ofBizDelegator.createValue("CommentPin", (Map)commentPinDTO.toGenericValue(this.ofBizDelegator));
        return CommentPinDTO.fromGenericValue(value);
    }

    @Override
    public void unpinComment(long commentId) {
        this.dslAccessor.execute(conn -> conn.delete((RelationalPath<?>)QCommentPin.COMMENT_PIN).where((Predicate)QCommentPin.COMMENT_PIN.commentId.eq((Object)commentId)).execute());
    }

    @Override
    public boolean isPinned(long commentId) {
        return this.dslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QCommentPin.COMMENT_PIN.id).from((Expression)QCommentPin.COMMENT_PIN)).where((Predicate)QCommentPin.COMMENT_PIN.commentId.eq((Object)commentId))).fetchCount()) > 0L;
    }

    @Override
    public List<CommentPinDTO> getPinnedComments(long issueId) {
        return this.dslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QCommentPin.COMMENT_PIN).from((Expression)QCommentPin.COMMENT_PIN)).where((Predicate)QCommentPin.COMMENT_PIN.issueId.eq((Object)issueId))).orderBy(QCommentPin.COMMENT_PIN.pinnedDate.desc())).fetch());
    }

    @Override
    public boolean isFeatureEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PIN_COMMENTS);
    }

    @Override
    public boolean isFeatureEnabledForServiceDesk() {
        return this.featureManager.isEnabled(SD_PIN_COMMENT_FEATURE_FLAG);
    }
}

