/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments.reactions;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.comments.reactions.CommentReactionManager;
import com.atlassian.jira.model.querydsl.CommentReactionDTO;
import com.atlassian.jira.model.querydsl.QCommentReaction;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class DefaultCommentReactionManager
implements CommentReactionManager {
    private final QueryDslAccessor dslAccessor;
    private final OfBizDelegator ofBizDelegator;

    public DefaultCommentReactionManager(QueryDslAccessor dslAccessor, OfBizDelegator ofBizDelegator) {
        this.dslAccessor = dslAccessor;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public CommentReactionDTO create(long commentId, String emoticon, String userKey, Instant created) {
        CommentReactionDTO commentReactionDTO = CommentReactionDTO.builder().author(userKey).commentId(commentId).createdDate(Timestamp.from(created)).emoticon(emoticon).build();
        GenericValue value = this.ofBizDelegator.createValue("CommentReaction", (Map)commentReactionDTO.toGenericValue(this.ofBizDelegator));
        return CommentReactionDTO.fromGenericValue(value);
    }

    @Override
    public CommentReactionDTO findById(long id) {
        return this.dslAccessor.executeQuery(dbConnection -> (CommentReactionDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QCommentReaction.COMMENT_REACTION).from((Expression)QCommentReaction.COMMENT_REACTION)).where((Predicate)QCommentReaction.COMMENT_REACTION.id.eq((Object)id))).fetchOne());
    }

    @Override
    public void delete(long commentId, String emoticon, String userKey) {
        this.dslAccessor.execute(conn -> conn.delete((RelationalPath<?>)QCommentReaction.COMMENT_REACTION).where((Predicate)QCommentReaction.COMMENT_REACTION.author.eq((Object)userKey).and((Predicate)QCommentReaction.COMMENT_REACTION.commentId.eq((Object)commentId).and((Predicate)QCommentReaction.COMMENT_REACTION.emoticon.eq((Object)emoticon)))).execute());
    }

    @Override
    public Collection<CommentReactionDTO> findByCommentId(long commentId) {
        return this.dslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QCommentReaction.COMMENT_REACTION).from((Expression)QCommentReaction.COMMENT_REACTION)).where((Predicate)QCommentReaction.COMMENT_REACTION.commentId.eq((Object)commentId))).orderBy(QCommentReaction.COMMENT_REACTION.createdDate.desc())).fetch());
    }

    @Override
    public long getReactionCount(long commentId, String emoticon) {
        return this.dslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QCommentReaction.COMMENT_REACTION.id).from((Expression)QCommentReaction.COMMENT_REACTION)).where((Predicate)QCommentReaction.COMMENT_REACTION.commentId.eq((Object)commentId))).where((Predicate)QCommentReaction.COMMENT_REACTION.emoticon.eq((Object)emoticon))).fetchCount());
    }

    @Override
    public Collection<CommentReactionDTO> findByCommentAndEmoticon(long commentId, String emoticon) {
        return this.dslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QCommentReaction.COMMENT_REACTION).from((Expression)QCommentReaction.COMMENT_REACTION)).where((Predicate)QCommentReaction.COMMENT_REACTION.commentId.eq((Object)commentId).and((Predicate)QCommentReaction.COMMENT_REACTION.emoticon.eq((Object)emoticon)))).fetch());
    }

    @Override
    public boolean exists(long commentId, String emoticon, String userKey) {
        return this.dslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QCommentReaction.COMMENT_REACTION.id).from((Expression)QCommentReaction.COMMENT_REACTION)).where((Predicate)QCommentReaction.COMMENT_REACTION.commentId.eq((Object)commentId).and((Predicate)QCommentReaction.COMMENT_REACTION.emoticon.eq((Object)emoticon)).and((Predicate)QCommentReaction.COMMENT_REACTION.author.eq((Object)userKey)))).fetchCount()) > 0L;
    }

    @Override
    public void deleteAllByCommentId(long commentId) {
        this.dslAccessor.execute(conn -> conn.delete((RelationalPath<?>)QCommentReaction.COMMENT_REACTION).where((Predicate)QCommentReaction.COMMENT_REACTION.commentId.eq((Object)commentId)).execute());
    }
}

