/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments.util;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.util.CommentIterator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.collections.iterators.ObjectArrayIterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LuceneCommentIterator
implements CommentIterator {
    private static final Logger log = LoggerFactory.getLogger(LuceneCommentIterator.class);
    private final CommentService commentService;
    private final ApplicationUser user;
    private final TopDocs hits;
    private final Iterator<ScoreDoc> luceneHitsIterator;
    private final ManagedIndexSearcher searcher;
    private Comment nextComment = null;

    public LuceneCommentIterator(ApplicationUser user, CommentService commentService, TopDocs hits, ManagedIndexSearcher searcher) {
        this.searcher = searcher;
        this.commentService = (CommentService)Assertions.notNull((String)"commentService", (Object)commentService);
        this.hits = hits;
        this.luceneHitsIterator = hits == null ? null : new ObjectArrayIterator((Object[])hits.scoreDocs);
        this.user = user;
    }

    public boolean hasNext() {
        this.populateNextCommentIfNull();
        return this.nextComment != null;
    }

    public Comment nextComment() {
        this.populateNextCommentIfNull();
        if (this.nextComment == null) {
            throw new NoSuchElementException();
        }
        Comment comment = this.nextComment;
        this.nextComment = null;
        return comment;
    }

    private void populateNextCommentIfNull() {
        if (this.nextComment == null) {
            this.pullNextComment();
        }
    }

    private Iterator<ScoreDoc> getLuceneHitsIterator() {
        return this.luceneHitsIterator;
    }

    private void pullNextComment() {
        Iterator<ScoreDoc> iterator = this.getLuceneHitsIterator();
        if (iterator == null || !iterator.hasNext()) {
            this.nextComment = null;
            return;
        }
        do {
            try {
                ScoreDoc hit = iterator.next();
                Document doc = this.searcher.doc(hit.doc);
                Long commentId = new Long(doc.getField("id").stringValue());
                this.nextComment = this.commentService.getCommentById(this.user, commentId, (ErrorCollection)new SimpleErrorCollection());
            }
            catch (NoSuchElementException e) {
                return;
            }
            catch (IOException e) {
                log.error("Failed to retrieve Lucene comment document", (Throwable)e);
                return;
            }
        } while (this.nextComment == null && iterator.hasNext());
    }

    public void close() {
    }

    public Comment next() {
        return this.nextComment();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        if (this.hits != null) {
            return (int)this.hits.totalHits;
        }
        return 0;
    }
}

