/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.I18nHelper;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DatePickerConverterImpl
implements DatePickerConverter {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final DateFieldFormat dateFieldFormat;

    public DatePickerConverterImpl(JiraAuthenticationContext jiraAuthenticationContext, DateFieldFormat dateFieldFormat) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.dateFieldFormat = dateFieldFormat;
    }

    public String getString(Date value) {
        if (value == null) {
            return "";
        }
        return this.dateFieldFormat.formatDatePicker(value);
    }

    public Timestamp getTimestamp(String stringValue) throws FieldValidationException {
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return null;
        }
        try {
            Date date = this.dateFieldFormat.parseDatePicker(stringValue);
            long time = date.getTime();
            LocalDateFactory.toIsoBasic((LocalDate)LocalDateFactory.from((Date)date));
            return new Timestamp(time);
        }
        catch (IllegalArgumentException e) {
            I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
            throw new FieldValidationException(i18nBean.getText("fields.validation.data.format", this.dateFieldFormat.getFormatHint()));
        }
    }
}

