/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalLabel;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValueImpl;
import com.atlassian.jira.imports.project.parser.LabelParserImpl;
import com.atlassian.jira.issue.customfields.ProjectImportLabelFieldParser;
import com.atlassian.jira.util.dbc.Null;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ProjectImportLabelFieldParserImpl
implements ProjectImportLabelFieldParser {
    public String getEntityName() {
        return "Label";
    }

    public ExternalCustomFieldValue parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String customFieldIdString = (String)attributes.get("fieldid");
        if (StringUtils.isNotBlank((CharSequence)customFieldIdString)) {
            LabelParserImpl parser = new LabelParserImpl();
            ExternalLabel externalLabel = parser.parse(attributes);
            ExternalCustomFieldValueImpl label = new ExternalCustomFieldValueImpl(externalLabel.getId(), externalLabel.getCustomFieldId(), externalLabel.getIssueId());
            label.setStringValue(externalLabel.getLabel());
            return label;
        }
        return null;
    }

    public EntityRepresentation getEntityRepresentation(ExternalCustomFieldValue customFieldValue) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("id", customFieldValue.getId());
        attributes.put("issue", customFieldValue.getIssueId());
        attributes.put("fieldid", customFieldValue.getCustomFieldId());
        attributes.put("label", customFieldValue.getStringValue());
        return new EntityRepresentationImpl(this.getEntityName(), attributes);
    }
}

