/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.SelectCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.DefaultNonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.SelectCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.CustomFieldOptionJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.jql.resolver.CustomFieldOptionResolver;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCFType
extends AbstractSingleFieldType<Option>
implements MultipleSettableCustomFieldType<Option, Option>,
SortableCustomField<String>,
GroupSelectorField,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    private final OptionsManager optionsManager;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;
    private static final Logger log = LoggerFactory.getLogger(SelectCFType.class);

    public SelectCFType(CustomFieldValuePersister customFieldValuePersister, OptionsManager optionsManager, GenericConfigManager genericConfigManager, JiraBaseUrls jiraBaseUrls) {
        super(customFieldValuePersister, genericConfigManager);
        this.optionsManager = optionsManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectCustomFieldImporter = new SelectCustomFieldImporter();
    }

    public Set<Long> remove(CustomField field) {
        Set issues = super.remove(field);
        this.optionsManager.removeCustomFieldOptions(field);
        return issues;
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    protected Object getDbValueFromObject(Option customFieldObject) {
        return this.getStringFromSingularObject(customFieldObject);
    }

    protected Option getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return this.getSingularObjectFromString((String)databaseValue);
    }

    public void removeValue(CustomField field, Issue issue, Option option) {
        this.updateValue(field, issue, null);
    }

    public Option getSingularObjectFromString(String string) throws FieldValidationException {
        if ("-1".equals(string)) {
            return null;
        }
        return this.getOptionFromStringValue(string);
    }

    private Option getOptionFromStringValue(String selectValue) throws FieldValidationException {
        Long aLong = OptionUtils.safeParseLong((String)selectValue);
        if (aLong != null) {
            return this.optionsManager.findByOptionId(aLong);
        }
        return null;
    }

    public String getStringFromSingularObject(Option optionObject) {
        if (optionObject == null) {
            return null;
        }
        return optionObject.getOptionId().toString();
    }

    public Set<Long> getIssueIdsWithValue(CustomField field, Option option) {
        if (option != null) {
            return this.customFieldValuePersister.getIssueIdsWithValue(field, PersistenceFieldType.TYPE_LIMITED_TEXT, (Object)option.getOptionId().toString());
        }
        return Collections.emptySet();
    }

    @Nonnull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new SettableOptionsConfigItem((CustomFieldType)this, this.optionsManager));
        return configurationItemTypes;
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        String selectedString = (String)relevantParams.getFirstValueForNullKey();
        if (StringUtils.isNotBlank((CharSequence)selectedString) && !"-1".equals(selectedString)) {
            Options options = this.optionsManager.getOptions(config);
            Preconditions.checkNotNull((Object)options);
            CustomField customField = config.getCustomField();
            Long optionId = Longs.tryParse((String)selectedString);
            if (optionId == null) {
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + selectedString + "'", "'" + customField + "'", this.createValidOptionsString(options)), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (options.getOptionById(optionId) == null) {
                if (this.formHasTheSameValueAsDatabase(relevantParams, customField, optionId)) {
                    return;
                }
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + selectedString + "'", "'" + customField + "'", this.createValidOptionsString(options)), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    private boolean formHasTheSameValueAsDatabase(CustomFieldParams relevantParams, CustomField customField, Long optionId) {
        String issueId = (String)relevantParams.getFirstValueForKey(CustomFieldUtils.getParamKeyIssueId());
        if (issueId != null) {
            Option databaseValue = (Option)this.getValueFromIssue(customField, Longs.tryParse((String)issueId), null);
            return databaseValue != null && Objects.equals(databaseValue.getOptionId(), optionId);
        }
        return false;
    }

    public void setDefaultValue(FieldConfig fieldConfig, Option option) {
        Long id = null;
        if (option != null) {
            id = option.getOptionId();
        }
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), (Object)id);
    }

    public Option getDefaultValue(FieldConfig fieldConfig) {
        Long optionId = (Long)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (optionId == null) {
            return null;
        }
        return this.optionsManager.findByOptionId(optionId);
    }

    public String getChangelogString(CustomField field, Option value) {
        return value == null ? null : value.getValue();
    }

    private String createValidOptionsString(@Nonnull Options options) {
        List rootOptions = options.getRootOptions();
        StringBuilder validOptions = new StringBuilder();
        Iterator optionIterator = rootOptions.iterator();
        while (optionIterator.hasNext()) {
            Option option = (Option)optionIterator.next();
            validOptions.append(option.getOptionId()).append("[").append(option.getValue()).append("]");
            if (!optionIterator.hasNext()) continue;
            validOptions.append(", ");
        }
        validOptions.append(", -1");
        return validOptions.toString();
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(@Nullable Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null) {
            velocityParams.put("databaseOption", this.getValueFromIssue(field, issue));
        }
        return velocityParams;
    }

    public Options getOptions(FieldConfig config, @Nullable JiraContextNode jiraContextNode) {
        return this.optionsManager.getOptions(config);
    }

    public int compare(@Nonnull String customFieldObjectValue1, @Nonnull String customFieldObjectValue2, FieldConfig fieldConfig) {
        Options options = this.getOptions(fieldConfig, null);
        if (options != null) {
            int v2;
            int v1 = options.indexOf((Object)options.getOptionById(Long.valueOf(customFieldObjectValue1)));
            if (v1 > (v2 = options.indexOf((Object)options.getOptionById(Long.valueOf(customFieldObjectValue2))))) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
        log.info("No options were found.");
        return 0;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitSelect(this);
        }
        return super.accept(visitor);
    }

    public List<String> getIdentifiersForGroup(String groupName) {
        return ((CustomFieldOptionResolver)ComponentAccessor.getComponent(CustomFieldOptionResolver.class)).getIdsFromName(groupName);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        Option value = (Option)this.getValueFromIssue(context.getCustomField(), issue);
        if (value != null) {
            return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)value.getValue());
        }
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)"");
    }

    public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return ((Object)((Object)this)).getClass() == SelectCFType.class ? new DefaultNonNullCustomFieldProvider(this.customFieldValuePersister) : null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        FieldConfig config = ((CustomField)fieldTypeInfoContext.getOderableField()).getRelevantConfig(fieldTypeInfoContext.getIssueContext());
        Options options = this.optionsManager.getOptions(config);
        Collection optionBeans = CustomFieldOptionJsonBean.shortBeans((Collection)options, (JiraBaseUrls)this.jiraBaseUrls);
        return new FieldTypeInfo(optionBeans, null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"option", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Option valueFromIssue = (Option)this.getValueFromIssue(field, issue);
        if (valueFromIssue == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        return new FieldJsonRepresentation(new JsonData((Object)CustomFieldOptionJsonBean.shortBean((Option)valueFromIssue, (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new SelectCustomFieldOperationsHandler(this.optionsManager, field, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        Option defaultValue = (Option)field.getCustomFieldType().getDefaultValue(config);
        return defaultValue == null ? null : new JsonData((Object)CustomFieldOptionJsonBean.shortBean((Option)defaultValue, (JiraBaseUrls)this.jiraBaseUrls));
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitSelect(SelectCFType var1);
    }
}

