/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.VersionCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.DefaultNonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.RequiresProjectSelectedMarker;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.VersionOptionsConfigItem;
import com.atlassian.jira.issue.customfields.config.item.VersionOrderConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.MultiVersionCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.impl.rest.SingleVersionCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.LongIdsValueHolder;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.VersionJsonBean;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import io.atlassian.fugue.Option;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCFType
extends AbstractMultiCFType<Version>
implements RequiresProjectSelectedMarker,
SortableCustomField,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionCFType.class);
    public static final String SINGLE_VERSION_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:version";
    public static final String MULTIPLE_VERSION_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:multiversion";
    private static final String NO_VERSION_STRING = "-1";
    private static final PersistenceFieldType DB_TYPE = PersistenceFieldType.TYPE_DECIMAL;
    private static final String MULTIPLE_PARAM_KEY = "multiple";
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final VersionHelperBean versionHelperBean;
    private final VersionCustomFieldImporter versionCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;
    private final GenericConfigManager genericConfigManager;

    public VersionCFType(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, VersionManager versionManager, CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, VersionHelperBean versionHelperBean, JiraBaseUrls jiraBaseUrls) {
        super(customFieldValuePersister, genericConfigManager);
        this.permissionManager = permissionManager;
        this.authenticationContext = jiraAuthenticationContext;
        this.versionManager = versionManager;
        this.versionHelperBean = versionHelperBean;
        this.jiraBaseUrls = jiraBaseUrls;
        this.versionCustomFieldImporter = new VersionCustomFieldImporter();
        this.genericConfigManager = genericConfigManager;
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        String bad;
        LongIdsValueHolder versionIds = new LongIdsValueHolder(relevantParams.getValuesForNullKey());
        if (versionIds != null && !versionIds.isEmpty()) {
            this.versionHelperBean.validateVersionIds((Collection)versionIds, errorCollectionToAddTo, this.authenticationContext.getI18nHelper(), config.getFieldId());
        }
        if (versionIds != null && !StringUtils.isEmpty((CharSequence)(bad = versionIds.getInputText()))) {
            errorCollectionToAddTo.addError(config.getFieldId(), this.authenticationContext.getI18nHelper().getText("issue.field.versions.invalid.version.id", bad), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public Collection<Version> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        Collection allValues = parameters.getValuesForNullKey();
        Collection collection = CollectionUtils.collect((Collection)allValues, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String versionIdString = (String)input;
                Long versionId = VersionCFType.this.getLongFromString(versionIdString);
                return VersionCFType.this.versionManager.getVersion(versionId);
            }
        });
        if (CustomFieldUtils.isCollectionNotEmpty((Collection)collection)) {
            return collection;
        }
        return null;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getValuesForNullKey();
    }

    public String getChangelogString(CustomField field, Collection<Version> versions) {
        if (versions != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<Version> iterator = versions.iterator();
            while (iterator.hasNext()) {
                Version version = iterator.next();
                if (version == null) continue;
                sb.append(version.getName());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }

    public String getStringFromSingularObject(Version version) {
        if (version == null) {
            return NO_VERSION_STRING;
        }
        return String.valueOf(version.getId());
    }

    public Version getSingularObjectFromString(String string) throws FieldValidationException {
        if (StringUtils.isEmpty((CharSequence)string) || NO_VERSION_STRING.equals(string)) {
            return null;
        }
        Long versionId = this.getLongFromString(string);
        return this.versionManager.getVersion(versionId);
    }

    public int compare(@Nonnull Object customFieldObjectValue1, @Nonnull Object customFieldObjectValue2, FieldConfig fieldConfig) {
        if (customFieldObjectValue1 instanceof GenericValue && customFieldObjectValue2 instanceof GenericValue) {
            LOGGER.debug("Comparing generic values instead of versions!");
            return OfBizComparators.NAME_COMPARATOR.compare((GenericValue)customFieldObjectValue1, (GenericValue)customFieldObjectValue2);
        }
        if (customFieldObjectValue1 instanceof Version && customFieldObjectValue2 instanceof Version) {
            return new VersionComparator().compare((Version)customFieldObjectValue1, (Version)customFieldObjectValue2);
        }
        throw new IllegalArgumentException("The objects are not of the expected type.");
    }

    @Nonnull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new VersionOptionsConfigItem(this.versionManager, this.authenticationContext));
        configurationItemTypes.add(new VersionOrderConfigItem(this.versionManager, this.genericConfigManager, this.authenticationContext.getI18nHelper()));
        return configurationItemTypes;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (bulkEditBean.isMultipleProjects()) {
            return "bulk.edit.unavailable.multipleprojects";
        }
        if (this.versionManager.getVersions(bulkEditBean.getSingleProject()).isEmpty()) {
            return "bulk.edit.unavailable.noversions";
        }
        return null;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParameters = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null) {
            Collection releasedversion = this.versionManager.getVersionsReleasedDesc(issue.getProjectId(), false);
            Collection unreleasedversion = this.versionManager.getVersionsUnreleased(issue.getProjectId(), false);
            Collection currentlySelectedArchivedVersions = this.getCurrentlySelectedArchivedVersions(issue, field);
            velocityParameters.put("unknownVersionId", -1L);
            velocityParameters.put("releasedVersion", releasedversion);
            velocityParameters.put("unreleasedVersion", unreleasedversion);
            velocityParameters.put("archivedVersions", currentlySelectedArchivedVersions);
            velocityParameters.put("unreleasedFirst", this.getUnreleasedVersionFirst(field.getRelevantConfig(issue)));
            if (fieldLayoutItem != null) {
                velocityParameters.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
        }
        velocityParameters.put("collection", new CollectionUtils());
        velocityParameters.put(MULTIPLE_PARAM_KEY, Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY)));
        return velocityParameters;
    }

    private boolean getUnreleasedVersionFirst(FieldConfig fieldConfig) {
        Object versionOrder;
        if (fieldConfig != null && (versionOrder = this.genericConfigManager.retrieve(VersionOrder.getDatabaseType(), fieldConfig.getId().toString())) != null) {
            return versionOrder.equals(VersionOrder.UNRELEASED_FIRST.getId());
        }
        return false;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.versionCustomFieldImporter;
    }

    public boolean isMultiple() {
        return Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY));
    }

    private Collection getCurrentlySelectedArchivedVersions(Issue issue, CustomField field) {
        Collection selectedVersions = this.getValueFromIssue(field, issue);
        if (selectedVersions != null && !selectedVersions.isEmpty()) {
            return CollectionUtils.select((Collection)selectedVersions, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Version version = (Version)object;
                    return version.isArchived();
                }
            });
        }
        return Collections.emptyList();
    }

    protected Comparator<Version> getTypeComparator() {
        return new VersionComparator();
    }

    protected Object convertTypeToDbValue(Version value) {
        if (value != null) {
            return new Double(value.getId().longValue());
        }
        return null;
    }

    protected Version convertDbValueToType(Object input) {
        if (input != null) {
            Double versionIdDouble = (Double)input;
            Long versionId = new Long(versionIdDouble.longValue());
            return this.versionManager.getVersion(versionId);
        }
        return null;
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return DB_TYPE;
    }

    private Long getLongFromString(String stringValue) throws FieldValidationException {
        try {
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Version Id is not a number '" + stringValue + "'");
        }
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitVersion(this);
        }
        return super.accept(visitor);
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        if (this.isMultiple()) {
            return new MultiVersionCustomFieldOperationsHandler(field, this.versionManager, this.authenticationContext.getI18nHelper());
        }
        return new SingleVersionCustomFieldOperationsHandler(field, this.versionManager, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        List projects = this.versionManager.getVersions(issueCtx.getProjectObject());
        return new JsonData((Object)VersionJsonBean.shortBeans((Collection)projects, (JiraBaseUrls)this.jiraBaseUrls));
    }

    public NonNullCustomFieldProvider getNonNullCustomFieldProvider() {
        return ((Object)((Object)this)).getClass() == VersionCFType.class ? new DefaultNonNullCustomFieldProvider(this.customFieldValuePersister) : null;
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        List versions = this.getValueFromIssue(context.getCustomField(), issue);
        if (versions == null) {
            versions = Collections.emptyList();
        }
        Stream<String> values = versions.stream().map(Version::getName).sorted(Collator.getInstance(this.authenticationContext.getLocale()));
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), values);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        List projects = this.versionManager.getVersions(fieldTypeInfoContext.getIssueContext().getProjectObject());
        return new FieldTypeInfo(VersionJsonBean.shortBeans((Collection)projects, (JiraBaseUrls)this.jiraBaseUrls), null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        if (this.isMultiple()) {
            return JsonTypeBuilder.customArray((String)"version", (String)this.getKey(), (Long)customField.getIdAsLong());
        }
        return JsonTypeBuilder.custom((String)"version", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Collection versions = this.getValueFromIssue(field, issue);
        if (versions == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        if (this.isMultiple()) {
            return new FieldJsonRepresentation(new JsonData((Object)VersionJsonBean.shortBeans((Collection)versions, (JiraBaseUrls)this.jiraBaseUrls)));
        }
        if (versions.isEmpty()) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        return new FieldJsonRepresentation(new JsonData((Object)VersionJsonBean.shortBean((Version)((Version)versions.iterator().next()), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitVersion(VersionCFType var1);
    }

    public static enum VersionOrder {
        RELEASED_FIRST(0, "admin.issuefields.customfields.versionorder.releasedfirst"),
        UNRELEASED_FIRST(1, "admin.issuefields.customfields.versionorder.unreleasedfirst");

        private final int id;
        private final String i18nKey;

        private VersionOrder(int id, String i18nKey) {
            this.id = id;
            this.i18nKey = i18nKey;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslation(I18nHelper i18nHelper) {
            return i18nHelper.getText(this.i18nKey);
        }

        public static String getDatabaseType() {
            return "VersionOrder";
        }

        public String asHtml(I18nHelper i18nHelper) {
            return "<p>" + this.getTranslation(i18nHelper) + "</p>";
        }

        @NotNull
        public static Option<VersionOrder> findById(@Nullable Object id) {
            if (id != null) {
                for (VersionOrder version : VersionOrder.values()) {
                    if (!id.equals(version.getId())) continue;
                    return Option.some((Object)((Object)version));
                }
            }
            return Option.none();
        }
    }
}

