/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class SelectCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<String> {
    private final OptionsManager optionsManager;

    public SelectCustomFieldOperationsHandler(OptionsManager optionsManager, CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
        this.optionsManager = optionsManager;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName());
    }

    protected String handleSetOperation(IssueContext issueCtx, Issue issue, String currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operationValue.isNull()) {
            return null;
        }
        String optionId = operationValue.asObjectWithProperty("id", this.field.getId(), errors);
        if (optionId == null) {
            String value = operationValue.asObjectWithProperty("value", this.field.getId(), errors);
            if (value != null) {
                FieldConfig config = this.field.getRelevantConfig(issueCtx);
                Options options = this.optionsManager.getOptions(config);
                for (Option option : options) {
                    if (!option.getValue().equals(value)) continue;
                    optionId = option.getOptionId().toString();
                    break;
                }
                if (optionId == null) {
                    errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.id.invalid", optionId), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else {
                errors.addError(this.field.getId(), this.i18nHelper.getText("rest.custom.field.option.parent.no.name.or.id"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
        return optionId;
    }

    protected String getInitialValue(Issue issue, ErrorCollection errors) {
        Option option = (Option)this.field.getValue(issue);
        return option == null ? null : option.getOptionId().toString();
    }

    protected String getInitialCreateValue(IssueContext issueCtx) {
        return null;
    }

    protected void finaliseOperation(String finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), new String[]{finalValue != null ? finalValue.toString() : null});
    }
}

