/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.statistics.AbstractCustomFieldStatisticsMapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.SearchRequestUtils;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CustomFieldSearchRequestAppender
implements SearchRequestAppender {
    private final CustomField customField;
    private final AbstractCustomFieldStatisticsMapper customFieldStatisticsMapper;

    public CustomFieldSearchRequestAppender(CustomField customField, AbstractCustomFieldStatisticsMapper customFieldStatisticsMapper) {
        this.customField = (CustomField)Assertions.notNull((Object)customField);
        this.customFieldStatisticsMapper = (AbstractCustomFieldStatisticsMapper)Assertions.notNull((Object)customFieldStatisticsMapper);
    }

    public SearchRequest appendInclusiveSingleValueClause(Object value, SearchRequest searchRequest) {
        if (searchRequest != null) {
            JqlQueryBuilder newQueryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
            JqlClauseBuilder whereClauseBuilder = newQueryBuilder.where().defaultAnd();
            if (!this.populateValueClause(value, searchRequest.getQuery(), whereClauseBuilder)) {
                return null;
            }
            return new SearchRequest(whereClauseBuilder.buildQuery());
        }
        return null;
    }

    public SearchRequest appendExclusiveMultiValueClause(Iterable values, SearchRequest searchRequest) {
        if (searchRequest != null) {
            JqlQueryBuilder newQueryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
            JqlClauseBuilder whereClauseBuilder = newQueryBuilder.where().and().not().sub();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                whereClauseBuilder.sub().defaultAnd();
                if (!this.populateValueClause(value, searchRequest.getQuery(), whereClauseBuilder)) {
                    return null;
                }
                whereClauseBuilder.endsub();
                if (!iter.hasNext()) continue;
                whereClauseBuilder.or();
            }
            whereClauseBuilder.endsub();
            return new SearchRequest(whereClauseBuilder.buildQuery());
        }
        return null;
    }

    private boolean populateValueClause(Object value, Query baseQuery, JqlClauseBuilder whereClauseBuilder) {
        if (value != null) {
            SearchService searchService = (SearchService)ComponentAccessor.getComponent(SearchService.class);
            ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
            SearchContext searchRequestContext = searchService.getSearchContext(user, baseQuery);
            SearchContext possibleContext = this.customFieldStatisticsMapper.getSearchContextFromValue(value);
            SearchContext combinedSearchContext = SearchRequestUtils.getCombinedSearchContext((SearchContext)searchRequestContext, (SearchContext)possibleContext);
            CustomFieldSearcher searcher = this.customField.getCustomFieldSearcher();
            if (searcher.getSearchRenderer().isShown(user, combinedSearchContext)) {
                List issueTypeIds;
                List projectIds = combinedSearchContext.getProjectIds();
                if (projectIds != null && !projectIds.isEmpty()) {
                    whereClauseBuilder.project().inNumbers((Collection)projectIds);
                }
                if ((issueTypeIds = combinedSearchContext.getIssueTypeIds()) != null && !issueTypeIds.isEmpty()) {
                    whereClauseBuilder.issueType().inStrings((Collection)issueTypeIds);
                }
                whereClauseBuilder.addStringCondition(JqlCustomFieldId.toString((long)this.customField.getIdAsLong()), this.customFieldStatisticsMapper.getSearchValue(value));
                return true;
            }
            return false;
        }
        return false;
    }
}

