/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractPickerFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.LongIdsValueHolder;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.VersionJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.views.SearchLinkGenerator;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.VersionProxy;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.DefaultBulkMoveHelper;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.opensymphony.util.TextUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;

public abstract class AbstractVersionsSystemField
extends AbstractPickerFieldImpl<Collection<Version>>
implements HideableField,
RequirableField,
RestAwareField,
ExportableSystemField {
    public static final Long UNKNOWN_VERSION_ID = -1L;
    public static final Long UNRELEASED_VERSION_ID = -2L;
    public static final Long RELEASED_VERSION_ID = -3L;
    private static final String PARAM_VERSIONS = "versions";
    protected final VersionManager versionManager;
    protected final VersionHelperBean versionHelperBean;
    protected final SearchLinkGenerator searchLinkGenerator;
    private final JiraBaseUrls jiraBaseUrls;
    private final JqlStringSupport jqlStringSupport;
    private Predicate<Long> validVersionId = new Predicate<Long>(){

        public boolean apply(Long versionId) {
            if (UNKNOWN_VERSION_ID.equals(versionId) || UNRELEASED_VERSION_ID.equals(versionId) || RELEASED_VERSION_ID.equals(versionId)) {
                return true;
            }
            Version version = AbstractVersionsSystemField.this.versionManager.getVersion(versionId);
            return version != null;
        }
    };

    protected AbstractVersionsSystemField(String id, String name, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, VersionManager versionManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, VersionHelperBean versionHelperBean, SearchHandlerFactory searchHandlerFactory, SearchLinkGenerator searchLinkGenerator, JiraBaseUrls jiraBaseUrls, JqlStringSupport jqlStringSupport) {
        super(id, name, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.versionManager = versionManager;
        this.versionHelperBean = versionHelperBean;
        this.searchLinkGenerator = searchLinkGenerator;
        this.jiraBaseUrls = jiraBaseUrls;
        this.jqlStringSupport = jqlStringSupport;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters, this.getAuthenticationContext().getI18nHelper());
        boolean shouldUseRestEndpoint = this.shouldUseRestEndpoint(operationContext);
        this.populateCommonParametersForEditTemplate(issue, fieldLayoutItem, operationContext, shouldUseRestEndpoint, velocityParams);
        LongIdsValueHolder currentVersionsIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), operationContext.getFieldValuesHolder());
        this.populateCommonVersionRelatedParametersForEditTemplate(currentVersionsIds, issue, shouldUseRestEndpoint, velocityParams);
        return this.renderTemplate("versions-edit.vm", velocityParams);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters, this.getAuthenticationContext().getI18nHelper());
        boolean shouldUseRestEndpoint = this.shouldUseRestEndpoint(operationContext);
        this.populateCommonParametersForEditTemplate(issue, fieldLayoutItem, operationContext, shouldUseRestEndpoint, velocityParams);
        LongIdsValueHolder currentVersionsIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), operationContext.getFieldValuesHolder());
        if (currentVersionsIds != null) {
            currentVersionsIds.validateIds(this.validVersionId);
        }
        this.populateCommonVersionRelatedParametersForEditTemplate(currentVersionsIds, issue, shouldUseRestEndpoint, velocityParams);
        Function getArchivedVersionJQL = version -> JiraUrlCodec.encode((String)this.jqlStringSupport.generateJqlString(this.queryArchivedVersionsField(JqlQueryBuilder.newBuilder().where().project(new Long[]{issue.getProjectObject().getId()}).and(), (Version)version).endWhere().orderBy().priority(SortOrder.ASC).buildQuery()));
        velocityParams.put("archivedVersions", this.getArchivedVersionsThatAreSelected(issue, this.getCurrentVersions(issue)));
        velocityParams.put("archivedVersionsTitle", this.getArchivedVersionsFieldTitle());
        velocityParams.put("getArchivedVersionJQL", getArchivedVersionJQL);
        velocityParams.put("frotherInputText", currentVersionsIds == null ? null : currentVersionsIds.getInputText());
        velocityParams.put("project", issue.getProject());
        if (displayParameters.get("bulkEdit") != null) {
            velocityParams.put("bulkEdit", displayParameters.get("bulkEdit"));
        }
        return this.renderTemplate("versions-edit.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull((String)"bulkEditBean", (Object)bulkEditBean);
        Assertions.notEmpty((String)"selectedIssues", (Collection)bulkEditBean.getSelectedIssues());
        if ("BulkMove".equals(bulkEditBean.getOperationName())) {
            FieldLayoutItem fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem((OrderableField)this);
            DefaultBulkMoveHelper bulkMoveHelper = new DefaultBulkMoveHelper();
            Function versionNameResolver = input -> this.versionManager.getVersion((Long)input).getName();
            Function issueValueResolver = input -> {
                LinkedHashMap<String, Object> fieldValuesHolder = new LinkedHashMap<String, Object>();
                this.populateFromIssue((Map<String, Object>)fieldValuesHolder, (Issue)input);
                return (Collection)fieldValuesHolder.get(this.getId());
            };
            Map distinctVersionValues = bulkMoveHelper.getDistinctValuesForMove(bulkEditBean, this, issueValueResolver, versionNameResolver);
            Issue issue = bulkEditBean.getFirstTargetIssueObject();
            Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
            velocityParams.put("valuesToMap", distinctVersionValues);
            velocityParams.put("bulkMoveHelper", bulkMoveHelper);
            velocityParams.put("unknownVersionId", UNKNOWN_VERSION_ID);
            velocityParams.put("unreleasedVersionId", UNRELEASED_VERSION_ID);
            velocityParams.put("releasedVersionId", RELEASED_VERSION_ID);
            velocityParams.put(PARAM_VERSIONS, this.getPossibleVersions(issue.getProjectObject(), this.getUnreleasedVersionsFirst()));
            if (fieldLayoutItem != null) {
                velocityParams.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
            return this.renderTemplate("versions-bulkmove.vm", velocityParams);
        }
        return super.getBulkEditHtml(operationContext, action, bulkEditBean, displayParameters);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(PARAM_VERSIONS, this.getCurrentVersions(issue));
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Collection<Version> value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put(PARAM_VERSIONS, value);
        return this.getViewHtml(velocityParams);
    }

    protected Map<String, Object> addViewVelocityParams() {
        return FieldMap.build((String)"linkToBrowseFixFor", (Object)Boolean.FALSE);
    }

    private String getViewHtml(Map<String, Object> velocityParams) {
        return this.renderTemplate("versions-view.vm", velocityParams);
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        LongIdsValueHolder versionIds = new LongIdsValueHolder(params.get(this.getId()));
        versionIds.validateIds(this.validVersionId);
        return versionIds;
    }

    public Collection<Version> getValueFromParams(Map params) {
        LongIdsValueHolder versionIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), params);
        if (versionIds == null || versionIds.contains(UNKNOWN_VERSION_ID)) {
            return Collections.emptyList();
        }
        return this.versionManager.getVersions(new LinkedList<Long>(versionIds));
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), new LongIdsValueHolder(this.getVersionIds(issue, stringValue)));
    }

    private List<Long> getVersionIds(Issue issue, String stringValue) throws FieldValidationException {
        HashSet<Long> versions = new HashSet<Long>();
        if (TextUtils.stringSet((String)stringValue)) {
            String[] versionParams;
            for (String versionParam : versionParams = StringUtils.split((String)stringValue, (String)",")) {
                try {
                    versions.add(Long.valueOf(versionParam));
                }
                catch (NumberFormatException e) {
                    Version version = this.versionManager.getVersion(issue.getProjectId(), versionParam);
                    if (version != null) {
                        versions.add(version.getId());
                        continue;
                    }
                    throw new FieldValidationException("Invalid version name '" + versionParam + "'.");
                }
            }
        }
        return new ArrayList<Long>(versions);
    }

    public void populateFromIssue(Map<String, Object> params, Issue issue) {
        params.put(this.getId(), this.getCurrentVersionIds(issue));
    }

    private void populateCommonParametersForEditTemplate(Issue issue, FieldLayoutItem fieldLayoutItem, OperationContext operationContext, boolean shouldUseRestEndpoint, Map<String, Object> velocityParams) {
        if (fieldLayoutItem != null) {
            velocityParams.put("isFrotherControl", HackyRendererType.fromKey((String)fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
        }
        velocityParams.put("createPermission", this.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, issue.getProjectObject(), this.authenticationContext.getLoggedInUser()));
        if (shouldUseRestEndpoint) {
            AbstractVersionsSystemField.populateRestDependentParametersForEditTemplate(operationContext, velocityParams);
        }
    }

    private static void populateRestDependentParametersForEditTemplate(OperationContext operationContext, Map<String, Object> velocityParams) {
        String operationNameKey = operationContext.getIssueOperation().getNameKey();
        velocityParams.put("useRestEndpoint", operationNameKey.equals("admin.issue.operations.edit") || operationNameKey.equals("admin.issue.operations.create"));
    }

    private void populateCommonVersionRelatedParametersForEditTemplate(@Nullable LongIdsValueHolder currentVersionsIds, @Nonnull Issue issue, boolean useRestEndpoint, @Nonnull Map<String, Object> velocityParams) {
        velocityParams.put("unknownVersionId", UNKNOWN_VERSION_ID);
        velocityParams.put("unreleasedVersionId", UNRELEASED_VERSION_ID);
        velocityParams.put("releasedVersionId", RELEASED_VERSION_ID);
        Project project = issue.getProjectObject();
        List<VersionProxy> versions = project != null ? this.getPossibleVersions(project, this.getUnreleasedVersionsFirst()) : Collections.emptyList();
        int versionsCount = versions.size();
        List<VersionProxy> currentVersions = this.getCurrentVersions(versions, currentVersionsIds);
        int limit = useRestEndpoint ? 100 : versionsCount;
        velocityParams.put("limit", limit);
        velocityParams.put("optionsLeft", versions.size() - currentVersions.size() - limit);
        List<VersionProxy> limitedVersions = versionsCount <= limit ? versions : versions.subList(0, limit);
        velocityParams.put("currentVersions", currentVersions);
        velocityParams.put("currentVersionsIds", currentVersionsIds);
        velocityParams.put(PARAM_VERSIONS, limitedVersions);
    }

    private List<VersionProxy> getCurrentVersions(@Nonnull List<VersionProxy> versions, @Nullable LongIdsValueHolder currentVersionsIds) {
        if (currentVersionsIds == null) {
            return Collections.emptyList();
        }
        return versions.stream().filter(version -> currentVersionsIds.contains(version.getKey())).collect(Collectors.toList());
    }

    protected LongIdsValueHolder getCurrentVersionIds(Issue issue) {
        LinkedList<Long> currentVersionIds = new LinkedList<Long>();
        for (Version version : this.getCurrentVersions(issue)) {
            currentVersionIds.add(version.getId());
        }
        return new LongIdsValueHolder((List<Long>)currentVersionIds);
    }

    protected abstract Collection<Version> getCurrentVersions(Issue var1);

    protected abstract String getArchivedVersionsFieldTitle();

    protected abstract JqlClauseBuilder queryArchivedVersionsField(JqlClauseBuilder var1, Version var2);

    protected abstract boolean getUnreleasedVersionsFirst();

    protected List<VersionProxy> getPossibleVersions(@Nonnull Project project, boolean unreleasedFirst) {
        ArrayList<VersionProxy> unreleased = new ArrayList<VersionProxy>();
        Iterator unreleasedIter = this.versionManager.getVersionsUnreleased(project.getId(), false).iterator();
        if (unreleasedIter.hasNext()) {
            unreleased.add(new VersionProxy(UNRELEASED_VERSION_ID.intValue(), this.getAuthenticationContext().getI18nHelper().getText("common.filters.unreleasedversions")));
            while (unreleasedIter.hasNext()) {
                Version version = (Version)unreleasedIter.next();
                unreleased.add(new VersionProxy(version));
            }
        }
        ArrayList<VersionProxy> released = new ArrayList<VersionProxy>();
        ArrayList releasedIter = new ArrayList(this.versionManager.getVersionsReleased(project.getId(), false));
        if (!releasedIter.isEmpty()) {
            released.add(new VersionProxy(RELEASED_VERSION_ID.intValue(), this.getAuthenticationContext().getI18nHelper().getText("common.filters.releasedversions")));
            Collections.reverse(releasedIter);
            for (Object aReleasedIter : releasedIter) {
                released.add(new VersionProxy((Version)aReleasedIter));
            }
        }
        ArrayList<VersionProxy> versions = new ArrayList<VersionProxy>();
        if (unreleasedFirst) {
            versions.addAll(unreleased);
            versions.addAll(released);
        } else {
            versions.addAll(released);
            versions.addAll(unreleased);
        }
        return versions;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        LongIdsValueHolder versionIds = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), operationContext.getFieldValuesHolder());
        this.validateForRequiredField(errorCollection, i18n, issue, fieldScreenRenderLayoutItem, versionIds);
        boolean validIds = this.versionHelperBean.validateVersionIds((Collection)versionIds, errorCollection, i18n, this.getId());
        if (validIds) {
            this.versionHelperBean.validateVersionForProject((Collection)versionIds, issue.getProjectObject(), errorCollection, i18n, this.getId());
        }
        if (versionIds != null) {
            String bad = versionIds.getInputText();
            if (StringUtils.isNotBlank((CharSequence)bad)) {
                errorCollection.addError(this.getId(), i18n.getText("issue.field.versions.invalid.version.id", bad), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (!versionIds.getValuesToAdd().isEmpty()) {
                this.versionHelperBean.validateVersionsToCreate(this.authenticationContext.getUser(), i18n, issue.getProjectObject(), this.getId(), versionIds.getValuesToAdd(), errorCollection);
            }
        }
    }

    @VisibleForTesting
    void validateForRequiredField(ErrorCollection errorCollection, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem, LongIdsValueHolder versionIds) {
        boolean noExistingVersionsSpecified = versionIds == null || versionIds.isEmpty() || versionIds.contains(UNKNOWN_VERSION_ID);
        boolean noNewVersionsSpecified = versionIds != null && versionIds.getValuesToAdd().isEmpty();
        boolean noArchivedVersionsSpecified = this.getArchivedVersionsThatAreSelected(issue, this.getCurrentVersions(issue)).isEmpty();
        if (fieldScreenRenderLayoutItem.isRequired() && noExistingVersionsSpecified && noNewVersionsSpecified && noArchivedVersionsSpecified) {
            this.addFieldRequiredErrorMessage(issue, errorCollection, i18n);
        }
    }

    protected abstract void addFieldRequiredErrorMessage(Issue var1, ErrorCollection var2, I18nHelper var3);

    protected abstract String getModifiedWithoutPermissionErrorMessage(I18nHelper var1);

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Collection currentVersions = (Collection)modifiedValue.getOldValue();
        Collection<Version> value = this.getUpdatedVersions(issue, (Collection)modifiedValue.getNewValue(), currentVersions);
        if (currentVersions == null || currentVersions.isEmpty()) {
            if (value != null) {
                issueChangeHolder.addChangeItems(this.updateIssueValue(issue, value));
            }
        } else if (!this.valuesEqual(value, currentVersions)) {
            issueChangeHolder.addChangeItems(this.updateIssueValue(issue, value));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Object originalIssue1 : originalIssues) {
            Issue originalIssue = (Issue)originalIssue1;
            if (!originalIssue.getProjectObject().equals(targetIssue.getProjectObject())) {
                if (!this.hasValue(originalIssue)) {
                    if (!targetFieldLayoutItem.isRequired()) continue;
                    return new MessagedResult(true);
                }
                return new MessagedResult(true);
            }
            if (!this.getCurrentVersions(originalIssue).isEmpty() || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        Collection<String> currentVersionNames = this.getVersionNames(this.getCurrentVersions(originalIssue));
        List possibleVersions = this.getVersionManager().getVersions(targetIssue.getProjectObject());
        LinkedList<Long> versionIds = new LinkedList<Long>();
        for (Version version : possibleVersions) {
            if (!currentVersionNames.contains(version.getName())) continue;
            versionIds.add(version.getId());
        }
        fieldValuesHolder.put(this.getId(), versionIds);
    }

    public boolean hasValue(Issue issue) {
        Collection<Version> currentVersions = this.getCurrentVersions(issue);
        return currentVersions != null && !currentVersions.isEmpty();
    }

    private Collection<String> getVersionNames(Collection<Version> versions) {
        HashSet<String> versionNames = new HashSet<String>();
        for (Version version : versions) {
            versionNames.add(version.getName());
        }
        return versionNames;
    }

    private Collection<Version> getUpdatedVersions(Issue issue, Collection<Version> selectedVersions, Collection currentVersions) {
        Collection<Version> affectedVersionNumbers = this.getArchivedVersionsThatAreSelected(issue, currentVersions);
        if (affectedVersionNumbers != null && !affectedVersionNumbers.isEmpty()) {
            if (selectedVersions == null || selectedVersions.isEmpty()) {
                selectedVersions = new LinkedList<Version>();
            }
            selectedVersions.addAll(affectedVersionNumbers);
        }
        return selectedVersions;
    }

    private Collection<Version> getArchivedVersionsThatAreSelected(Issue issue, Collection selectedVersions) {
        Collection archivedVersions = this.versionManager.getVersionsArchived(issue.getProjectObject());
        archivedVersions.retainAll(selectedVersions);
        return archivedVersions;
    }

    protected abstract List<ChangeItemBean> updateIssueValue(Issue var1, Collection<Version> var2);

    public void createValue(Issue issue, Collection<Version> value) {
        this.updateIssueValue(issue, value);
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), new LongIdsValueHolder(Collections.emptyList()));
    }

    public Collection<Version> getDefaultValue(Issue issue) {
        return Collections.emptyList();
    }

    protected abstract String getChangeItemFieldName();

    protected abstract String getIssueRelationName();

    protected VersionManager getVersionManager() {
        return this.versionManager;
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put(PARAM_VERSIONS, this.getCurrentVersions(issue));
        velocityParams.put("searchLinkGenerator", this.searchLinkGenerator);
        velocityParams.putAll(this.addViewVelocityParams());
        return this.renderTemplate("versions-columnview.vm", velocityParams);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (bulkEditBean.isMultipleProjects()) {
            return "bulk.edit.unavailable.multipleprojects";
        }
        if (this.getVersionManager().getVersions(bulkEditBean.getSingleProject()).isEmpty()) {
            return "bulk.edit.unavailable.noversions";
        }
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        List versions = this.versionManager.getVersions(fieldTypeInfoContext.getIssueContext().getProjectId());
        return new FieldTypeInfo((Collection)versions, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"version", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Collection<Version> versions = this.getCurrentVersions(issue);
        Collection beans = VersionJsonBean.shortBeans(versions, (JiraBaseUrls)this.jiraBaseUrls);
        return new FieldJsonRepresentation(new JsonData((Object)beans));
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Collection<Version> versions = this.getCurrentVersions(issue);
        if (versions != null) {
            Stream<String> values = versions.stream().map(Version::getName).sorted(Collator.getInstance(this.authenticationContext.getLocale()));
            return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), values);
        }
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), Stream.empty());
    }
}

