/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.TextFieldLimitProvider;

public class DefaultTextFieldCharacterLengthValidator
implements TextFieldCharacterLengthValidator {
    static final int UNLIMITED_TEXT_FIELD_CHARACTER_LIMIT = 0;
    private final TextFieldLimitProvider textFieldLimitProvider;

    public DefaultTextFieldCharacterLengthValidator(TextFieldLimitProvider textFieldLimitProvider) {
        this.textFieldLimitProvider = textFieldLimitProvider;
    }

    public boolean isTextTooLong(String text) {
        if (text == null) {
            return false;
        }
        return this.isTextTooLong(text.length());
    }

    public boolean isTextTooLong(int length) {
        long textFieldCharacterLimit = this.getMaximumNumberOfCharacters();
        if (textFieldCharacterLimit == 0L) {
            return false;
        }
        return (long)length > textFieldCharacterLimit;
    }

    public long getMaximumNumberOfCharacters() {
        return this.textFieldLimitProvider.getTextFieldLimit();
    }
}

