/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import java.util.Objects;
import javax.annotation.Nonnull;

@Internal
public final class DefaultValueConfigItem
implements FieldConfigItemType {
    private final DefaultValueField<?> defaultValueField;

    public DefaultValueConfigItem(@Nonnull DefaultValueField<?> defaultValueField) {
        this.defaultValueField = Objects.requireNonNull(defaultValueField);
    }

    public String getDisplayName() {
        return "Default Value For System Field";
    }

    public String getDisplayNameKey() {
        return "admin.issuefields.customfields.config.default.value";
    }

    public String getViewHtml(FieldConfig config, FieldLayoutItem fieldLayoutItem) {
        return this.defaultValueField.getDefaultValueOperations().getViewHtml(config, fieldLayoutItem);
    }

    public String getObjectKey() {
        return "default";
    }

    public Object getConfigurationObject(Issue issue, FieldConfig config) {
        return this.defaultValueField.getDefaultValueOperations().getDefaultValue(config);
    }

    public String getBaseEditUrl() {
        return "ConfigureField.jspa?fieldId=" + this.defaultValueField.getId();
    }
}

