/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.admin.RenderableProperty;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.issue.field.CustomFieldDeletedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.MultiSortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.NaturallyOrderedCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.impl.rest.TextCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldClauseContextHandler;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldClauseSanitiserHandler;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.customfields.view.NullCustomFieldParams;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldDescription;
import com.atlassian.jira.issue.fields.CustomFieldParamsUtil;
import com.atlassian.jira.issue.fields.CustomFieldScope;
import com.atlassian.jira.issue.fields.CustomFieldScopeFactory;
import com.atlassian.jira.issue.fields.DefaultValueOperations;
import com.atlassian.jira.issue.fields.DefaultValueOperationsCF;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.IssueComparator;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.constants.DefaultClauseInformation;
import com.atlassian.jira.issue.search.parameters.lucene.sort.DefaultIssueSortComparator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.DocumentSortComparatorSource;
import com.atlassian.jira.issue.search.parameters.lucene.sort.LongSortComparatorSource;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparatorSource;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.CustomFieldClauseContextFactory;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.CustomFieldClausePermissionChecker;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.model.querydsl.CustomFieldDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptors;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptors;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NameComparator;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import com.atlassian.jira.web.bean.DefaultBulkMoveHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import io.atlassian.util.concurrent.LazyReference;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class ImmutableCustomField
implements CustomField {
    private static final Logger log = LoggerFactory.getLogger(ImmutableCustomField.class);
    private final Long id;
    private final String customFieldTypeKey;
    private final String customFieldSearcherKey;
    private final String name;
    private final String description;
    private final String defaultValue;
    private final Long fieldType;
    private final Long project;
    private final String issueType;
    private final Timestamp lastValueUpdate;
    private final Long issuesWithValue;
    private final LazyReference<PropertySet> propertySetRef = new LazyReference<PropertySet>(){

        protected PropertySet create() {
            return OFBizPropertyUtils.getCachingPropertySet("CustomField", ImmutableCustomField.this.id);
        }
    };
    private final Supplier<CustomFieldType> typeRef;
    private final Supplier<CustomFieldSearcher> searcherRef;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final PermissionManager permissionManager;
    private final RendererManager rendererManager;
    private final FieldConfigSchemeClauseContextUtil contextUtil;
    private final CustomFieldDescription customFieldDescription;
    private final FeatureManager featureManager;
    private final TranslationManager translationManager;
    private final CustomFieldScopeFactory scopeFactory;
    private final CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors;
    private final CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors;
    private final OfBizDelegator ofBizDelegator;
    private final String customFieldId;
    private final EventPublisher eventPublisher;

    ImmutableCustomField(CustomFieldDTO customFieldDTO, JiraAuthenticationContext authenticationContext, FieldConfigSchemeManager fieldConfigSchemeManager, PermissionManager permissionManager, RendererManager rendererManager, FieldConfigSchemeClauseContextUtil contextUtil, CustomFieldDescription customFieldDescription, FeatureManager featureManager, TranslationManager translationManager, CustomFieldScopeFactory scopeFactory, CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors, CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors, OfBizDelegator ofBizDelegator) {
        this.id = customFieldDTO.getId();
        this.customFieldTypeKey = customFieldDTO.getCustomfieldtypekey();
        this.customFieldSearcherKey = customFieldDTO.getCustomfieldsearcherkey();
        this.name = customFieldDTO.getName();
        this.description = customFieldDTO.getDescription();
        this.defaultValue = customFieldDTO.getDefault();
        this.lastValueUpdate = customFieldDTO.getLastValueUpdate();
        this.issuesWithValue = customFieldDTO.getIssuesWithValue();
        this.fieldType = customFieldDTO.getFieldtype();
        this.project = customFieldDTO.getProject();
        this.issueType = customFieldDTO.getIssuetype();
        this.authenticationContext = authenticationContext;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.permissionManager = permissionManager;
        this.rendererManager = rendererManager;
        this.contextUtil = contextUtil;
        this.customFieldDescription = customFieldDescription;
        this.translationManager = translationManager;
        this.eventPublisher = this.getEventPublisher();
        this.featureManager = featureManager;
        this.typeRef = Suppliers.memoize(this::loadCustomFieldType);
        this.searcherRef = Suppliers.memoize(this::loadCustomFieldSearcher);
        this.scopeFactory = scopeFactory;
        this.customFieldTypeModuleDescriptors = customFieldTypeModuleDescriptors;
        this.customFieldSearcherModuleDescriptors = customFieldSearcherModuleDescriptors;
        this.ofBizDelegator = ofBizDelegator;
        this.customFieldId = "customfield_" + this.id;
    }

    public boolean isInScope(Project project, List<String> issueTypeIds) {
        List issueContexts = CustomFieldUtils.convertToIssueContexts((Project)project, issueTypeIds);
        return this.isInScope(issueContexts);
    }

    public boolean isInScope(long projectId, String issueTypeId) {
        return this.isRelevantForIssueContext((IssueContext)new IssueContextImpl(Long.valueOf(projectId), issueTypeId));
    }

    public boolean isInScopeForSearch(Project project, List<String> issueTypeIds) {
        List issueContexts = CustomFieldUtils.convertToIssueContexts((Project)project, issueTypeIds);
        return this.isInScopeOfAtLeastOneIssueContext(issueContexts);
    }

    private boolean isInScopeOfAtLeastOneIssueContext(List<IssueContext> issueContexts) {
        CustomFieldScope customFieldScope = this.scopeFactory.createFor(this);
        for (IssueContext issueContext : issueContexts) {
            if (!customFieldScope.isIncludedIn(issueContext)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(List<IssueContext> issueContexts) {
        for (IssueContext issueContext : issueContexts) {
            if (!this.isRelevantForIssueContext(issueContext)) continue;
            return true;
        }
        return false;
    }

    public FieldConfig getReleventConfig(SearchContext searchContext) {
        List issueContexts = searchContext.getAsIssueContexts();
        FieldConfig config = null;
        boolean firstRun = true;
        for (IssueContext issueContext : issueContexts) {
            FieldConfig relevantConfig = this.getRelevantConfig(issueContext);
            if (firstRun) {
                config = relevantConfig;
                firstRun = false;
                continue;
            }
            if (!ImmutableCustomField.areDifferent(config, relevantConfig)) continue;
            log.debug("Different configs found for search context. No configs are returned for " + this.getName());
            return null;
        }
        return config;
    }

    public ClauseNames getClauseNames() {
        return ClauseNames.forCustomField((CustomField)this);
    }

    public boolean isInScope(SearchContext searchContext) {
        List issueContexts = searchContext.getAsIssueContexts();
        for (IssueContext issueContext : issueContexts) {
            if (this.isRelevantForIssueContext(issueContext)) continue;
            return false;
        }
        return true;
    }

    public void validateFromActionParams(Map actionParameters, ErrorCollection errorCollection, FieldConfig config) {
        CustomFieldParams relevantParams = CustomFieldParamsUtil.getRelevantParams(this, actionParameters);
        this.getCustomFieldType().validateFromParams(relevantParams, errorCollection, config);
    }

    public Object getValue(Issue issue) {
        return this.getCustomFieldType().getValueFromIssue((CustomField)this, issue);
    }

    public boolean isRenderable() {
        return this.getCustomFieldType().isRenderable();
    }

    @Nullable
    private String getChangelogValue(Object value) {
        return this.getCustomFieldType().getChangelogValue((CustomField)this, value);
    }

    @Nullable
    private String getChangelogString(Object value) {
        return this.getCustomFieldType().getChangelogString((CustomField)this, value);
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        ChangeItemBean changeItemBean = this.updateValue(fieldLayoutItem, issue, modifiedValue.getNewValue());
        if (changeItemBean != null) {
            issueChangeHolder.addChangeItem(changeItemBean);
        }
    }

    private ChangeItemBean updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, Object newValue) {
        Object existingValue = this.getValue(issue);
        ChangeItemBean cib = null;
        if (existingValue == null) {
            if (newValue != null) {
                newValue = this.processValueThroughRenderer(fieldLayoutItem, newValue);
                this.createValue(issue, newValue);
                String changelogValue = this.getChangelogValue(newValue);
                if (changelogValue != null) {
                    String changelogString = this.getChangelogString(newValue);
                    if (changelogString == null) {
                        changelogString = changelogValue;
                        changelogValue = null;
                    }
                    cib = new ChangeItemBean("custom", this.getNameKey(), null, null, changelogValue, changelogString);
                }
            }
        } else if (!this.valuesEqual(existingValue, newValue)) {
            newValue = this.processValueThroughRenderer(fieldLayoutItem, newValue);
            this.getCustomFieldType().updateValue((CustomField)this, issue, newValue);
            String changelogValue = this.getChangelogValue(newValue);
            if (changelogValue != null) {
                String changelogString = this.getChangelogString(newValue);
                if (changelogString == null) {
                    changelogString = changelogValue;
                    changelogValue = null;
                }
                String oldChangelogString = this.getChangelogString(existingValue);
                String oldChangelogValue = this.getChangelogValue(existingValue);
                if (oldChangelogString == null) {
                    oldChangelogString = oldChangelogValue;
                    oldChangelogValue = null;
                }
                cib = new ChangeItemBean("custom", this.getNameKey(), oldChangelogValue, oldChangelogString, changelogValue, changelogString);
            }
        }
        return cib;
    }

    private Object processValueThroughRenderer(FieldLayoutItem fieldLayoutItem, Object value) {
        if (this.isRenderable()) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            value = this.rendererManager.getRendererForType(rendererType).transformFromEdit(value);
        }
        return value;
    }

    public String prettyPrintChangeHistory(String changeHistory) {
        return changeHistory;
    }

    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        return changeHistory;
    }

    public boolean isEditable() {
        return this.getCustomFieldType().getDescriptor().isEditTemplateExists();
    }

    public Options getOptions(String key, JiraContextNode jiraContextNode) {
        return this.getOptions(key, this.getRelevantConfig(jiraContextNode), jiraContextNode);
    }

    public Options getOptions(String key, FieldConfig config, JiraContextNode contextNode) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof MultipleCustomFieldType) {
            MultipleCustomFieldType multipleCustomFieldType = (MultipleCustomFieldType)customFieldType;
            return multipleCustomFieldType.getOptions(config, contextNode);
        }
        return null;
    }

    public void populateDefaults(Map<String, Object> customFieldValuesHolder, Issue issue) {
        FieldConfig config = this.getRelevantConfig(issue);
        if (config != null) {
            Object defaultValues = this.getDefaultValueForConfig(config);
            if (defaultValues != null) {
                CustomFieldParamsImpl paramsFromIssue = new CustomFieldParamsImpl((CustomField)this, defaultValues);
                paramsFromIssue.transformObjectsToStrings();
                customFieldValuesHolder.put(this.getId(), paramsFromIssue);
                customFieldValuesHolder.put(this.getId() + ":objects", new CustomFieldParamsImpl((CustomField)this, defaultValues));
            }
        } else {
            log.info("No relevant config found for " + this + " for the issue " + issue);
        }
    }

    private Object getDefaultValueForConfig(FieldConfig config) {
        return this.getCustomFieldType().getDefaultValue(config);
    }

    public boolean isRelevantForIssueContext(IssueContext issueContext) {
        return this.fieldConfigSchemeManager.isRelevantForIssueContext(issueContext, (ConfigurableField)this);
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext) {
        return this.fieldConfigSchemeManager.getRelevantConfig(issueContext, (ConfigurableField)this);
    }

    public FieldConfig getRelevantConfig(Issue issue) {
        return this.getRelevantConfig((IssueContext)issue);
    }

    private FieldConfig getRelevantConfig(JiraContextNode contextNode) {
        return this.getRelevantConfig((IssueContext)new IssueContextImpl(contextNode.getProjectObject(), contextNode.getIssueTypeObject()));
    }

    public boolean hasParam(Map parameters) {
        CustomFieldParams relevantParams = CustomFieldParamsUtil.getRelevantParams(this, parameters);
        return !relevantParams.isEmpty();
    }

    public void populateFromParams(Map<String, Object> customFieldValuesHolder, Map<String, String[]> params) {
        CustomFieldParams relevantParams = CustomFieldParamsUtil.getRelevantParams(this, params);
        customFieldValuesHolder.put(this.getId(), relevantParams);
    }

    public void populateFromIssue(Map<String, Object> customFieldValuesHolder, Issue issue) {
        CustomFieldParams paramsFromIssue = this.getCustomFieldParamsFromIssue(issue);
        customFieldValuesHolder.put(this.getId(), paramsFromIssue);
    }

    public Object getValueFromParams(Map params) throws FieldValidationException {
        return this.getCustomFieldType().getValueFromCustomFieldParams((CustomFieldParams)params.get(this.getId()));
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List getConfigurationItemTypes() {
        return this.getCustomFieldType().getConfigurationItemTypes();
    }

    public SearchHandler createAssociatedSearchHandler() {
        ClauseContextFactory clauseContextFactory;
        CustomFieldSearcher customFieldSearcher = this.getCustomFieldSearcher();
        ClauseNames clauseNames = this.getClauseNames();
        if (customFieldSearcher == null) {
            if (this.getCustomFieldType() instanceof SortableCustomField) {
                NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(this.createClausePermissionHandler(null), this.getId(), clauseNames, "jira.jql.validation.field.not.searchable");
                SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)noOpClauseHandler);
                return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(clauseRegistration));
            }
            return null;
        }
        CustomFieldSearcherClauseHandler searcherClauseHandler = customFieldSearcher.getCustomFieldSearcherClauseHandler();
        if (searcherClauseHandler instanceof CustomFieldClauseContextHandler) {
            clauseContextFactory = ((CustomFieldClauseContextHandler)searcherClauseHandler).getClauseContextFactory();
        } else {
            FieldConfigSchemeClauseContextUtil clauseContextUtil = (FieldConfigSchemeClauseContextUtil)ComponentAccessor.getComponentOfType(FieldConfigSchemeClauseContextUtil.class);
            clauseContextFactory = new CustomFieldClauseContextFactory((CustomField)this, clauseContextUtil, ContextSetUtil.getInstance());
        }
        ClauseSanitiser sanitiser = null;
        if (searcherClauseHandler instanceof CustomFieldClauseSanitiserHandler) {
            sanitiser = ((CustomFieldClauseSanitiserHandler)searcherClauseHandler).getClauseSanitiser();
        }
        DefaultClauseInformation clauseInformation = new DefaultClauseInformation(this.getId(), clauseNames, this.getId(), searcherClauseHandler.getSupportedOperators(), searcherClauseHandler.getDataType());
        Object customFieldClauseHandler = searcherClauseHandler instanceof ValueGeneratingClauseHandler ? new DefaultValuesGeneratingClauseHandler((ClauseInformation)clauseInformation, searcherClauseHandler.getClauseQueryFactory(), searcherClauseHandler.getClauseValidator(), this.createClausePermissionHandler(sanitiser), clauseContextFactory, ((ValueGeneratingClauseHandler)searcherClauseHandler).getClauseValuesGenerator()) : new DefaultClauseHandler((ClauseInformation)clauseInformation, searcherClauseHandler.getClauseQueryFactory(), searcherClauseHandler.getClauseValidator(), this.createClausePermissionHandler(sanitiser), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)customFieldClauseHandler);
        return new SearchHandler(customFieldSearcher.getSearchInformation().getRelatedIndexers(), new SearchHandler.SearcherRegistration((IssueSearcher)customFieldSearcher, clauseRegistration));
    }

    private ClausePermissionHandler createClausePermissionHandler(ClauseSanitiser sanitiser) {
        CustomFieldClausePermissionChecker.Factory factory = (CustomFieldClausePermissionChecker.Factory)ComponentAccessor.getComponentOfType(CustomFieldClausePermissionChecker.Factory.class);
        ClausePermissionChecker checker = factory.createPermissionChecker(this, this.contextUtil);
        if (sanitiser == null) {
            return new DefaultClausePermissionHandler(checker);
        }
        return new DefaultClausePermissionHandler(checker, sanitiser);
    }

    public void createValue(Issue issue, Object value) {
        if (value != null) {
            this.getCustomFieldType().createValue((CustomField)this, issue, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map params = operationContext.getFieldValuesHolder();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        FieldConfig config = this.getRelevantConfig(issue);
        if (params.containsKey(this.getId())) {
            CustomFieldParams customFieldParams = (CustomFieldParams)params.get(this.getId());
            this.getCustomFieldType().validateFromParams(this.addAdditionalParametersForValidation(customFieldParams, issue), (ErrorCollection)errorCollection, config);
        }
        if (!errorCollection.hasAnyErrors()) {
            try {
                CustomFieldType customFieldType;
                if (!this.isEditable() || fieldScreenRenderLayoutItem == null || !fieldScreenRenderLayoutItem.isRequired() || (customFieldType = this.getCustomFieldType()).areAllRequiredParametersPresent(params, this.getId())) return;
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", this.getName()), ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
            catch (FieldValidationException e) {
                log.error("Error occurred while validating a custom field", (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            errorCollectionToAddTo.addErrorCollection((ErrorCollection)errorCollection);
        }
    }

    private CustomFieldParams addAdditionalParametersForValidation(CustomFieldParams customFieldParams, Issue issue) {
        if (customFieldParams.containsKey(CustomFieldUtils.getParamKeyIssueId()) || issue == null) {
            return customFieldParams;
        }
        CustomFieldParamsImpl params = new CustomFieldParamsImpl(customFieldParams.getCustomField(), (Object)customFieldParams);
        if (issue.getId() != null) {
            params.put(CustomFieldUtils.getParamKeyIssueId(), (Collection)ImmutableList.of((Object)issue.getId().toString()));
        }
        if (issue.getProjectId() != null) {
            params.put(CustomFieldUtils.getParamKeyProjectId(), (Collection)ImmutableList.of((Object)issue.getProjectId().toString()));
        }
        params.put(CustomFieldUtils.getParamKeyRequireProjectIds(), (Collection)ImmutableList.of((Object)Boolean.TRUE.toString()));
        return params;
    }

    public CustomFieldParams getCustomFieldValues(Map customFieldValuesHolder) {
        if (customFieldValuesHolder == null) {
            return new NullCustomFieldParams();
        }
        CustomFieldParams customFieldParams = (CustomFieldParams)customFieldValuesHolder.get(this.getId());
        if (customFieldParams == null) {
            return new NullCustomFieldParams();
        }
        return customFieldParams;
    }

    public Set<Long> remove() throws DataAccessException {
        CustomFieldType customFieldType = this.getCustomFieldType();
        Set issueIds = customFieldType != null ? customFieldType.remove((CustomField)this) : Collections.emptySet();
        try {
            GenericValue gv = this.toCustomFieldDTO().toGenericValue(this.ofBizDelegator);
            OFBizPropertyUtils.removePropertySet(gv);
            gv.remove();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.eventPublisher.publish((Object)new CustomFieldDeletedEvent((CustomField)this));
        return issueIds;
    }

    public String toString() {
        return this.getName();
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Object customFieldValue = this.getRendererCustomFieldValue(fieldLayoutItem, issue, displayParams);
        return this.getCustomFieldType().getDescriptor().getColumnViewHtml((CustomField)this, customFieldValue, issue, displayParams, fieldLayoutItem);
    }

    private Object getRendererCustomFieldValue(FieldLayoutItem fieldLayoutItem, Issue issue, Map displayParams) {
        String renderedContent;
        Object customFieldValue = issue.getCustomFieldValue((CustomField)this);
        if (this.isRenderable() && displayParams.get("excel_view") == null && StringUtils.isNotBlank((CharSequence)(renderedContent = this.rendererManager.getRenderedContent(fieldLayoutItem, issue)))) {
            customFieldValue = renderedContent;
        }
        return customFieldValue;
    }

    private Object getRendererCustomFieldValue(FieldLayoutItem fieldLayoutItem, Issue issue, Object value) {
        Object customFieldValue;
        if (this.isRenderable() && value instanceof String) {
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            customFieldValue = this.rendererManager.getRenderedContent(rendererType, (String)value, issue.getIssueRenderContext());
        } else {
            customFieldValue = value;
        }
        return customFieldValue;
    }

    protected I18nHelper getI18nHelper() {
        return this.getCustomFieldType().getDescriptor().getI18nBean();
    }

    public String getHiddenFieldId() {
        return this.getId();
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getCreateHtml(fieldLayoutItem, operationContext, action, issue, new HashMap());
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, dispayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, new HashMap());
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getCustomFieldType().getDescriptor().getEditHtml(this.getRelevantConfig(issue), operationContext.getFieldValuesHolder(), issue, action, dispayParameters, fieldLayoutItem);
    }

    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Assertions.notNull((String)"bulkEditBean", (Object)bulkEditBean);
        Assertions.notEmpty((String)"selectedIssues", (Collection)bulkEditBean.getSelectedIssues());
        FieldLayoutItem fieldLayoutItem = null;
        if (bulkEditBean.getTargetFieldLayout() != null) {
            fieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem((OrderableField)this);
            if (this.isCustomFieldTypeSupportedForDistinctValueMapping(fieldLayoutItem)) {
                return this.getBulkMoveHtmlWithMapping(fieldLayoutItem, operationContext, action, bulkEditBean, displayParameters);
            }
            return this.getEditHtml(fieldLayoutItem, operationContext, action, bulkEditBean.getFirstTargetIssueObject(), displayParameters);
        }
        if (!bulkEditBean.getFieldLayouts().isEmpty()) {
            fieldLayoutItem = ((FieldLayout)bulkEditBean.getFieldLayouts().iterator().next()).getFieldLayoutItem((OrderableField)this);
        }
        return this.getEditHtml(fieldLayoutItem, operationContext, action, (Issue)bulkEditBean.getSelectedIssues().iterator().next(), displayParameters);
    }

    private String getBulkMoveHtmlWithMapping(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Issue issue = bulkEditBean.getFirstTargetIssueObject();
        DefaultBulkMoveHelper bulkMoveHelper = new DefaultBulkMoveHelper();
        com.atlassian.jira.util.Function<Issue, Collection<Object>> issueValueResolver = new com.atlassian.jira.util.Function<Issue, Collection<Object>>(){

            public Collection<Object> apply(Issue issue) {
                LinkedHashMap<String, Object> fieldValuesHolder = new LinkedHashMap<String, Object>();
                ImmutableCustomField.this.populateFromIssue(fieldValuesHolder, issue);
                Object o = fieldValuesHolder.get(ImmutableCustomField.this.getId());
                CustomFieldParams customFieldParams = (CustomFieldParams)o;
                return customFieldParams.getValuesForNullKey();
            }
        };
        com.atlassian.jira.util.Function<Object, String> nameResolver = new com.atlassian.jira.util.Function<Object, String>(){

            public String apply(Object input) {
                Object result = ImmutableCustomField.this.getCustomFieldType().getSingularObjectFromString((String)input);
                if (result == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Could not resolve name for input '" + input + "'.");
                    }
                } else {
                    if (result instanceof Version) {
                        return ((Version)result).getName();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Type '" + result.getClass() + "' currently not supported for bulk move.");
                    }
                }
                return null;
            }
        };
        Map distinctValues = bulkMoveHelper.getDistinctValuesForMove(bulkEditBean, (OrderableField)this, (com.atlassian.jira.util.Function)issueValueResolver, (com.atlassian.jira.util.Function)nameResolver);
        return this.getCustomFieldType().getDescriptor().getBulkMoveHtml(this.getRelevantConfig(issue), operationContext.getFieldValuesHolder(), issue, action, displayParameters, fieldLayoutItem, distinctValues, (BulkMoveHelper)bulkMoveHelper);
    }

    private boolean isCustomFieldTypeSupportedForDistinctValueMapping(FieldLayoutItem fieldLayoutItem) {
        CustomField customField = (CustomField)fieldLayoutItem.getOrderableField();
        return customField.getCustomFieldType() instanceof VersionCFType;
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue) {
        return this.getViewHtml(fieldLayoutItem, action, issue, new HashMap());
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        return this.getCustomFieldType().getDescriptor().getViewHtml((CustomField)this, this.getRendererCustomFieldValue(fieldLayoutItem, issue, displayParameters), issue, fieldLayoutItem, displayParameters);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        return this.getCustomFieldType().getDescriptor().getViewHtml((CustomField)this, this.getRendererCustomFieldValue(fieldLayoutItem, issue, value), issue, fieldLayoutItem, displayParameters);
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public Object getDefaultValue(Issue issue) {
        FieldConfig config = this.getRelevantConfig(issue);
        if (config == null) {
            return null;
        }
        return this.getDefaultValueForConfig(config);
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        try {
            if (fieldValueHolder.containsKey(this.getId())) {
                CustomFieldParams customFieldParams = (CustomFieldParams)fieldValueHolder.get(this.getId());
                issue.setCustomFieldValue((CustomField)this, this.getCustomFieldType().getValueFromCustomFieldParams(this.addAdditionalParametersForValidation(customFieldParams, (Issue)issue)));
            }
        }
        catch (FieldValidationException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Object originalIssue1 : originalIssues) {
            String targetRendererType;
            String rendererType;
            Issue originalIssue = (Issue)originalIssue1;
            if (!this.isInScope(originalIssue.getProjectObject(), (List<String>)ImmutableList.of((Object)originalIssue.getIssueTypeId()))) {
                return new MessagedResult(true);
            }
            if (!this.doesFieldHaveValue(originalIssue) && targetFieldLayoutItem != null && targetFieldLayoutItem.isRequired()) {
                return new MessagedResult(true);
            }
            if (this.doesFieldHaveValue(originalIssue)) {
                CustomFieldParams customFieldParams = this.getCustomFieldParamsFromIssue(originalIssue);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                FieldConfig config = this.getRelevantConfig(targetIssue);
                if (this.getCustomFieldType().isUserInputRequiredForMove(customFieldParams, config, targetIssue.getProjectId(), targetIssue.getIssueTypeId())) {
                    return new MessagedResult(true);
                }
                if (this.getCustomFieldType() instanceof VersionCFType && !originalIssue.getProjectId().equals(targetIssue.getProjectId())) {
                    return new MessagedResult(true);
                }
                this.getCustomFieldType().validateFromParams(customFieldParams, (ErrorCollection)errorCollection, config);
                if (errorCollection.hasAnyErrors()) {
                    log.debug("Move required. Errors occurred in automatic moving: " + ToStringBuilder.reflectionToString((Object)errorCollection.getErrorMessages()));
                    return new MessagedResult(true);
                }
            }
            if (!this.isRenderable() || !this.doesFieldHaveValue(originalIssue)) continue;
            FieldLayoutItem fieldLayoutItem = null;
            try {
                fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(originalIssue.getProjectObject(), originalIssue.getIssueTypeId()).getFieldLayoutItem(this.getId());
            }
            catch (DataAccessException e) {
                log.warn(this.getName() + " field was unable to resolve the field layout item for issue " + originalIssue.getId(), (Throwable)e);
            }
            if (this.rendererTypesEqual(rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null, targetRendererType = targetFieldLayoutItem != null ? targetFieldLayoutItem.getRendererType() : null)) continue;
            if (originalIssues.size() > 1) {
                return new MessagedResult(false, this.getI18nHelper().getText("renderer.bulk.move.warning"), 1);
            }
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        if (this.isRenderable()) {
            fieldValuesHolder.put(this.getId(), this.getCustomFieldParamsFromIssue(originalIssue));
        } else {
            this.populateDefaults(fieldValuesHolder, targetIssue);
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setCustomFieldValue((CustomField)this, null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return this.getValue(issue) != null;
    }

    private boolean doesFieldHaveValue(Issue issue) {
        Object value = this.getValue(issue);
        if (value != null && this.getCustomFieldType() instanceof LabelsCFType && value instanceof Collection) {
            Collection c = (Collection)value;
            return !c.isEmpty();
        }
        return value != null;
    }

    public String getId() {
        return this.customFieldId;
    }

    public String getValueFromIssue(Issue issue) {
        Object value = this.getValue(issue);
        if (!(value instanceof String)) {
            return null;
        }
        return (String)value;
    }

    public Long getIdAsLong() {
        return this.id;
    }

    public Timestamp getLastValueUpdate() {
        return this.lastValueUpdate;
    }

    public Long getIssuesWithValue() {
        return this.issuesWithValue;
    }

    public List<FieldConfigScheme> getConfigurationSchemes() {
        return this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)this);
    }

    public String getNameKey() {
        return this.getName();
    }

    private CustomFieldParams getCustomFieldParamsFromIssue(Issue issue) {
        Object valueFromIssue = this.getCustomFieldType().getValueFromIssue((CustomField)this, issue);
        if (valueFromIssue != null) {
            CustomFieldParamsImpl paramsFromIssue = new CustomFieldParamsImpl((CustomField)this, valueFromIssue);
            paramsFromIssue.transformObjectsToStrings();
            return paramsFromIssue;
        }
        return new CustomFieldParamsImpl((CustomField)this);
    }

    @Nonnull
    public List<Project> getAssociatedProjectObjects() {
        return (List)this.getConfigurationSchemes().stream().map(FieldConfigScheme::getAssociatedProjectObjects).flatMap(Collection::stream).sorted(NameComparator.COMPARATOR).collect(CollectorsUtil.toImmutableList());
    }

    @Nonnull
    public List<IssueType> getAssociatedIssueTypes() {
        return this.getConfigurationSchemes().stream().map(FieldConfigScheme::getAssociatedIssueTypes).flatMap(Collection::stream).sorted(NameComparator.COMPARATOR).distinct().collect(Collectors.toList());
    }

    public List<IssueType> getAssociatedIssueTypeObjects() {
        return this.getAssociatedIssueTypes();
    }

    public boolean isGlobal() {
        return this.isAllProjects() && this.isAllIssueTypes();
    }

    public boolean isAllProjects() {
        return this.getConfigurationSchemes().stream().anyMatch(FieldConfigScheme::isAllProjects);
    }

    public boolean isAllIssueTypes() {
        return this.getAssociatedIssueTypes().contains(null);
    }

    public boolean isEnabled() {
        return this.getConfigurationSchemes().stream().anyMatch(FieldConfigScheme::isEnabled);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        String customFieldAvailabilityString = customFieldType.availableForBulkEdit(bulkEditBean);
        if (TextUtils.stringSet((String)customFieldAvailabilityString)) {
            return customFieldAvailabilityString;
        }
        for (Object o : bulkEditBean.getFieldLayouts()) {
            FieldLayout fieldLayout = (FieldLayout)o;
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return "bulk.edit.unavailable.hidden";
        }
        FieldConfig config = null;
        boolean first = true;
        for (Object o : bulkEditBean.getSelectedIssues()) {
            Issue issue = (Issue)o;
            if (!this.hasBulkUpdatePermission(bulkEditBean, issue)) {
                return "bulk.edit.unavailable.permission";
            }
            FieldConfig currentConfig = this.getRelevantConfig(issue);
            if (first) {
                if (currentConfig == null) {
                    return "bulk.edit.incompatible.customfields";
                }
                config = currentConfig;
                first = false;
                continue;
            }
            if (!ImmutableCustomField.areDifferent(config, currentConfig)) continue;
            return "bulk.edit.incompatible.customfields";
        }
        if (this.isRenderable()) {
            String rendererType = null;
            for (Object o : bulkEditBean.getFieldLayouts()) {
                FieldLayout fieldLayout = (FieldLayout)o;
                String tempRendererType = fieldLayout.getRendererTypeForField(this.getId());
                if (rendererType == null) {
                    rendererType = tempRendererType;
                    continue;
                }
                if (rendererType.equals(tempRendererType)) continue;
                return "bulk.edit.unavailable.inconsistent.rendertypes";
            }
        }
        return null;
    }

    protected static boolean areDifferent(Object obj1, Object obj2) {
        return obj1 != null && !obj1.equals(obj2) || obj1 == null && obj2 != null;
    }

    protected boolean hasBulkUpdatePermission(BulkEditBean bulkEditBean, Issue issue) {
        return "BulkWorkflowTransition".equals(bulkEditBean.getOperationName()) || this.permissionManager.hasPermission(12, issue, this.authenticationContext.getUser());
    }

    public String getName() {
        String translatedName = this.translationManager.getCustomFieldNameTranslation((CustomField)this);
        if (StringUtils.isNotEmpty((CharSequence)translatedName)) {
            return translatedName;
        }
        return this.name;
    }

    public String getUntranslatedName() {
        return this.name;
    }

    public String getFieldName() {
        return TextUtils.htmlEncode((String)this.getName());
    }

    public String getDescription() {
        String translatedDesc = this.translationManager.getCustomFieldDescriptionTranslation((CustomField)this);
        if (StringUtils.isNotEmpty((CharSequence)translatedDesc)) {
            return translatedDesc;
        }
        return this.description;
    }

    public String getUntranslatedDescription() {
        return this.description;
    }

    @Nonnull
    public RenderableProperty getDescriptionProperty() {
        return this.customFieldDescription.createRenderablePropertyFor(this);
    }

    @Nonnull
    public RenderableProperty getUntranslatedDescriptionProperty() {
        return this.customFieldDescription.createRenderablePropertyFor(this.getUntranslatedDescription());
    }

    public CustomFieldSearcher getCustomFieldSearcher() {
        try {
            return this.searcherRef.get();
        }
        catch (SearcherNotFoundException e) {
            log.debug("getCustomFieldSearcher potentially called on Custom Field before plugin enabled. Will retry on next call and return null from this execution", (Throwable)e);
            return null;
        }
    }

    public CustomFieldType getCustomFieldType() {
        try {
            return this.typeRef.get();
        }
        catch (TypeNotFoundException e) {
            log.debug("getCustomFieldType potentially called on Custom Field before plugin enabled. Will retry on next call and return null from this execution", (Throwable)e);
            return null;
        }
    }

    public String getColumnHeadingKey() {
        return this.getName();
    }

    public String getColumnCssClass() {
        return this.getId();
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    private boolean isSortable() {
        return !this.getSortFields(false).isEmpty();
    }

    boolean valuesEqual(Object v1, Object v2) {
        return this.getCustomFieldType().valuesEqual(v1, v2);
    }

    public int compare(Issue issue1, Issue issue2) throws IllegalArgumentException {
        Object v2;
        if (!this.isSortable()) {
            log.error("Called compare method, even though not comparable");
            return 0;
        }
        if (issue1 == null && issue2 == null) {
            throw new IllegalArgumentException("issue1 and issue2 are null");
        }
        if (issue1 == null) {
            throw new IllegalArgumentException("issue1 is null");
        }
        if (issue2 == null) {
            throw new IllegalArgumentException("issue2 is null");
        }
        Object v1 = issue1.getCustomFieldValue((CustomField)this);
        if (v1 == (v2 = issue2.getCustomFieldValue((CustomField)this))) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof SortableCustomField) {
            SortableCustomField sortable = (SortableCustomField)customFieldType;
            FieldConfig c1 = this.getRelevantConfig(issue1);
            FieldConfig c2 = this.getRelevantConfig(issue2);
            if (c1 == null || !c1.equals(c2)) {
                log.info("Sort order for custom field " + this + " for issues " + issue1 + " and " + issue2 + " contexts did not match. Sort order may be incorrect");
            }
            return sortable.compare(v1, v2, c1);
        }
        return 0;
    }

    public LuceneFieldSorter getSorter() {
        if (this.getCustomFieldSearcher() instanceof SortableCustomFieldSearcher) {
            return ((SortableCustomFieldSearcher)this.getCustomFieldSearcher()).getSorter((CustomField)this);
        }
        return null;
    }

    public FieldComparatorSource getSortComparatorSource() {
        LuceneFieldSorter sorter = this.getSorter();
        if (sorter != null) {
            return new MappedSortComparator(sorter);
        }
        if (this.getCustomFieldType() instanceof SortableCustomField) {
            return new DocumentSortComparatorSource(new DefaultIssueSortComparator(new CustomFieldIssueSortComparator(this)));
        }
        return null;
    }

    public List<SortField> getSortFields(final boolean sortOrder) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        CustomFieldSearcher customFieldSearcher = this.getCustomFieldSearcher();
        if (customFieldSearcher instanceof NaturallyOrderedCustomFieldSearcher) {
            String fieldName = ((NaturallyOrderedCustomFieldSearcher)customFieldSearcher).getSortField((CustomField)this);
            SortField.Type sortFieldType = ((NaturallyOrderedCustomFieldSearcher)customFieldSearcher).getSortFieldType();
            SortField sortField = new SortField(fieldName, this.comparatorFromType(sortFieldType), sortOrder);
            sortFields.add(sortField);
        } else if (customFieldSearcher instanceof MultiSortableCustomFieldSearcher) {
            Iterable sorters = ((MultiSortableCustomFieldSearcher)customFieldSearcher).getSorters((CustomField)this);
            Iterables.addAll(sortFields, (Iterable)Iterables.transform((Iterable)sorters, (Function)new Function<LuceneFieldSorter, SortField>(){

                public SortField apply(@Nullable LuceneFieldSorter input) {
                    return new SortField(input.getDocumentConstant(), (FieldComparatorSource)new MappedSortComparator(input), sortOrder);
                }
            }));
        } else {
            FieldComparatorSource sorter = this.getSortComparatorSource();
            if (sorter != null) {
                String fieldName = this.customFieldId;
                SortField sortField = new SortField(fieldName, sorter, sortOrder);
                sortFields.add(sortField);
            }
        }
        return sortFields;
    }

    private FieldComparatorSource comparatorFromType(SortField.Type type) {
        if (SortField.Type.LONG.equals((Object)type)) {
            return new LongSortComparatorSource();
        }
        return new StringSortComparatorSource(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field field = (Field)o;
        String id = this.getId();
        String fieldId = field.getId();
        return !(id == null ? fieldId != null : !id.equals(fieldId));
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    @Nullable
    private CustomFieldSearcher loadCustomFieldSearcher() {
        if (StringUtils.isBlank((CharSequence)this.customFieldSearcherKey)) {
            return null;
        }
        Option customFieldSearcher = this.customFieldSearcherModuleDescriptors.getCustomFieldSearcher(this.customFieldSearcherKey);
        CustomFieldSearcher searcher = (CustomFieldSearcher)customFieldSearcher.getOrThrow(() -> new SearcherNotFoundException("Custom Field Searcher '" + this.customFieldSearcherKey + "' not found"));
        try {
            searcher.init((SearchableField)this);
            return searcher;
        }
        catch (Exception exception) {
            log.error(String.format("Exception during searcher initialization of the custom field %s (Custom field ID: %d):", this.customFieldSearcherKey, this.id), (Throwable)exception);
            throw new SearcherNotFoundException(exception.getMessage(), exception);
        }
        catch (LinkageError error) {
            log.error(String.format("Error during searcher initialization of the custom field %s (Custom field ID: %d):", this.customFieldSearcherKey, this.id), (Throwable)error);
            throw new SearcherNotFoundException(error.getMessage(), error);
        }
    }

    @Nullable
    private CustomFieldType loadCustomFieldType() {
        if (StringUtils.isBlank((CharSequence)this.customFieldTypeKey)) {
            return null;
        }
        return (CustomFieldType)this.customFieldTypeModuleDescriptors.getCustomFieldType(this.customFieldTypeKey).getOrThrow(() -> new TypeNotFoundException("Custom Field Type '" + this.customFieldTypeKey + "' not found"));
    }

    public GenericValue getGenericValue() {
        return this.toCustomFieldDTO().toGenericValue(this.ofBizDelegator);
    }

    private CustomFieldDTO toCustomFieldDTO() {
        return new CustomFieldDTO(this.id, this.customFieldTypeKey, this.customFieldSearcherKey, this.name, this.description, this.defaultValue, this.fieldType, this.project, this.issueType, this.lastValueUpdate, this.issuesWithValue);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof Field) {
            Field field = (Field)o;
            if (this.getName() == null) {
                if (field.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (field.getName() == null) {
                return 1;
            }
            return this.getName().compareTo(field.getName());
        }
        throw new IllegalArgumentException("Can only compare Field objects.");
    }

    private boolean rendererTypesEqual(String oldRendererType, String newRendererType) {
        return oldRendererType == null && newRendererType == null || oldRendererType != null && oldRendererType.equals(newRendererType);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestAwareCustomFieldType) {
            return ((RestAwareCustomFieldType)customFieldType).getFieldTypeInfo(fieldTypeInfoContext);
        }
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestAwareCustomFieldType) {
            return ((RestAwareCustomFieldType)customFieldType).getJsonSchema((CustomField)this);
        }
        return JsonTypeBuilder.custom((String)"any", (String)customFieldType.getKey(), (Long)this.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, FieldLayoutItem fieldLayoutItem) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestAwareCustomFieldType) {
            return ((RestAwareCustomFieldType)customFieldType).getJsonFromIssue((CustomField)this, issue, renderedVersionRequested, fieldLayoutItem);
        }
        Object value = customFieldType.getValueFromIssue((CustomField)this, issue);
        if (value instanceof Collection) {
            ArrayList<String> list = new ArrayList<String>(((Collection)value).size());
            for (Object v : (Collection)value) {
                list.add(v.toString());
            }
            return new FieldJsonRepresentation(new JsonData(list));
        }
        if (value != null) {
            return new FieldJsonRepresentation(new JsonData((Object)value.toString()));
        }
        return new FieldJsonRepresentation(new JsonData(null));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestCustomFieldTypeOperations) {
            return ((RestCustomFieldTypeOperations)customFieldType).getRestFieldOperation((CustomField)this);
        }
        return new TextCustomFieldOperationsHandler((CustomField)this, this.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        CustomFieldType customFieldType = this.getCustomFieldType();
        if (customFieldType instanceof RestCustomFieldTypeOperations) {
            return ((RestCustomFieldTypeOperations)customFieldType).getJsonDefaultValue(issueCtx, (CustomField)this);
        }
        if (!this.isRelevantForIssueContext(issueCtx)) {
            return null;
        }
        FieldConfig config = this.getRelevantConfig(issueCtx);
        Object defaultValueForConfig = this.getDefaultValueForConfig(config);
        return defaultValueForConfig == null ? null : new JsonData(defaultValueForConfig);
    }

    public DefaultValueOperations<Object> getDefaultValueOperations() {
        return new DefaultValueOperationsCF<Object>(this.getCustomFieldType());
    }

    protected EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    public PropertySet getPropertySet() {
        return (PropertySet)this.propertySetRef.get();
    }

    private static class TypeNotFoundException
    extends RuntimeException {
        TypeNotFoundException(String message) {
            super(message);
        }
    }

    private static class SearcherNotFoundException
    extends RuntimeException {
        SearcherNotFoundException(String message) {
            super(message);
        }

        SearcherNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class CustomFieldIssueSortComparator
    implements IssueComparator {
        private final CustomField customField;

        public CustomFieldIssueSortComparator(CustomField customField) {
            if (customField == null) {
                throw new NullPointerException("Custom field cannot be null.");
            }
            this.customField = customField;
        }

        @Override
        public int compare(Issue issue1, Issue issue2) {
            return this.customField.compare(issue1, issue2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomFieldIssueSortComparator that = (CustomFieldIssueSortComparator)o;
            return this.customField.getId().equals(that.customField.getId());
        }

        public int hashCode() {
            return this.customField.getId().hashCode();
        }
    }
}

