/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfigPredicate;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PrioritySchemeMigratorFinder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@WebSudoRequired
public class DefaultPrioritySchemeService
implements PrioritySchemeService {
    private static final Logger log = Logger.getLogger(DefaultPrioritySchemeService.class);
    public static final ProjectAction PROJECT_ACTION_PERMISSION = ProjectAction.EDIT_PROJECT_CONFIG;
    private final GlobalPermissionManager globalPermissionManager;
    private final PrioritySchemeManager prioritySchemeManager;
    private final I18nHelper i18nHelper;
    private final PrioritySchemeMigratorFinder prioritySchemeMigratorFinder;
    private final ProjectService projectService;
    private final FeatureManager featureManager;

    public DefaultPrioritySchemeService(GlobalPermissionManager globalPermissionManager, PrioritySchemeManager prioritySchemeManager, ProjectService projectService, I18nHelper i18nHelper, PrioritySchemeMigratorFinder prioritySchemeMigratorFinder, FeatureManager featureManager) {
        this.projectService = projectService;
        this.featureManager = featureManager;
        this.prioritySchemeMigratorFinder = prioritySchemeMigratorFinder;
        Null.not("GlobalPermissionManager", globalPermissionManager);
        Null.not("PrioritySchemeManager", prioritySchemeManager);
        Null.not("I18nHelper", i18nHelper);
        this.globalPermissionManager = globalPermissionManager;
        this.prioritySchemeManager = prioritySchemeManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> assignProjects(@Nonnull ApplicationUser user, @Nullable FieldConfigScheme priorityFieldConfig, @Nonnull Collection<Project> projects) throws NoPermissionException {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (!ec.hasAnyErrors() && !projects.isEmpty()) {
            FieldConfigScheme finalPriorityFieldConfig = priorityFieldConfig != null ? priorityFieldConfig : this.prioritySchemeManager.getDefaultScheme();
            HashSet currentProjects = new HashSet(this.prioritySchemeManager.getProjectsWithScheme(finalPriorityFieldConfig));
            HashSet<Project> destinationProjects = new HashSet<Project>(projects);
            Sets.SetView toAdd = Sets.difference(destinationProjects, currentProjects);
            if (this.prioritySchemeManager.isDefaultScheme(finalPriorityFieldConfig)) {
                this.prioritySchemeManager.unassignProjects(finalPriorityFieldConfig, (Set)toAdd);
            } else {
                if (this.hasAnyNotPossibleToAssociateProject(projects)) {
                    return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.issuesettings.priorities.associate.error.sd"));
                }
                Sets.SetView toRemove = Sets.difference(currentProjects, destinationProjects);
                this.prioritySchemeManager.assignProjects(finalPriorityFieldConfig, (Set)toAdd);
                this.prioritySchemeManager.unassignProjects(finalPriorityFieldConfig, (Set)toRemove);
            }
            return ServiceOutcomeImpl.ok(this.prioritySchemeManager.getScheme(finalPriorityFieldConfig.getId()));
        }
        return ServiceOutcomeImpl.from((ErrorCollection)ec);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> assignProject(@Nonnull ApplicationUser user, @Nullable FieldConfigScheme priorityFieldConfig, @Nonnull Project project) {
        FieldConfigScheme finalPriorityFieldConfig = priorityFieldConfig != null ? priorityFieldConfig : this.prioritySchemeManager.getDefaultScheme();
        HashSet<Project> currentProjects = new HashSet<Project>(this.prioritySchemeManager.getProjectsWithScheme(finalPriorityFieldConfig));
        currentProjects.add(project);
        return this.assignProjects(user, finalPriorityFieldConfig, currentProjects);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> assignProject(@Nonnull ApplicationUser user, @Nullable Long schemeId, @Nonnull Either<Long, String> projectKeyOrId, boolean blockMigration) {
        ServiceResult migrationNeeded;
        FieldConfigScheme scheme;
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (ec.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)ec);
        }
        FieldConfigScheme fieldConfigScheme = scheme = Objects.isNull(schemeId) ? this.prioritySchemeManager.getDefaultScheme() : this.prioritySchemeManager.getScheme(schemeId);
        if (Objects.isNull(scheme)) {
            return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.schemes.priority.not_found", (Object)schemeId), ErrorCollection.Reason.NOT_FOUND);
        }
        ProjectService.GetProjectResult getProjectResponse = this.getProjectForAction(user, projectKeyOrId, PROJECT_ACTION_PERMISSION);
        if (!getProjectResponse.isValid()) {
            return ServiceOutcomeImpl.error(getProjectResponse);
        }
        Project project = getProjectResponse.get();
        if (blockMigration && !(migrationNeeded = this.validateMigrationNeeded(project, this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(this.prioritySchemeManager.getFieldConfigForDefaultMapping(scheme))))).isValid()) {
            return ServiceOutcomeImpl.from(migrationNeeded.getErrorCollection());
        }
        return this.assignProject(user, scheme, project);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> unassignProject(@Nonnull ApplicationUser user, @Nonnull Long schemeId, @Nonnull Either<Long, String> projectKeyOrId) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (ec.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)ec);
        }
        FieldConfigScheme scheme = this.prioritySchemeManager.getScheme(schemeId);
        if (Objects.isNull(scheme)) {
            return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.schemes.priority.not_found", (Object)schemeId), ErrorCollection.Reason.NOT_FOUND);
        }
        if (this.prioritySchemeManager.isDefaultScheme(scheme)) {
            return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.schemes.priority.unassign.default_scheme"));
        }
        ProjectService.GetProjectResult getProjectResponse = this.getProjectForAction(user, projectKeyOrId, PROJECT_ACTION_PERMISSION);
        if (!getProjectResponse.isValid()) {
            return ServiceOutcomeImpl.error(getProjectResponse);
        }
        Project project = getProjectResponse.get();
        if (!scheme.getAssociatedProjectIds().contains(project.getId())) {
            return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.schemes.priority.unassign.not.assigned.to.scheme", (String)projectKeyOrId.fold(id -> id.toString(), key -> key), schemeId.toString()));
        }
        this.prioritySchemeManager.unassignProject(scheme, project);
        return ServiceOutcomeImpl.ok(this.prioritySchemeManager.getScheme(scheme.getId()));
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> editScheme(@Nonnull ApplicationUser user, @Nonnull FieldConfigScheme priorityFieldConfig, @Nonnull List<String> optionIds, @Nullable String defaultOption) throws NoPermissionException {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (ec.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)ec);
        }
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT_EDIT_DEFAULT_SCHEME) && this.prioritySchemeManager.isDefaultScheme(priorityFieldConfig)) {
            ec.addErrorMessage(this.i18nHelper.getText("admin.schemes.priority.service.error.cant.edit.default"));
        }
        if (!ec.hasAnyErrors()) {
            FieldConfigScheme updated = this.prioritySchemeManager.updateWithDefaultMapping(priorityFieldConfig, optionIds);
            if (StringUtils.isBlank((CharSequence)defaultOption)) {
                defaultOption = null;
            }
            this.prioritySchemeManager.setDefaultOption(priorityFieldConfig.getOneAndOnlyConfig(), defaultOption);
            return ServiceOutcomeImpl.ok(updated);
        }
        return ServiceOutcomeImpl.from((ErrorCollection)ec);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> editScheme(@Nonnull ApplicationUser user, @Nonnull PrioritySchemeService.PrioritySchemeData data, boolean failIfMigrationNeeded) {
        ServiceResult validate = this.schemeDataValidate(user, data);
        if (!validate.isValid()) {
            return ServiceOutcomeImpl.from(validate.getErrorCollection());
        }
        FieldConfigScheme fieldConfigScheme = this.prioritySchemeManager.getScheme(data.getId());
        if (Objects.isNull(fieldConfigScheme)) {
            return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.schemes.priority.not_found", (Object)data.getId()), ErrorCollection.Reason.NOT_FOUND);
        }
        if (failIfMigrationNeeded) {
            Set projects = this.prioritySchemeManager.getProjectsWithScheme(fieldConfigScheme);
            for (Project project : projects) {
                ServiceResult migrationNeeded = this.validateMigrationNeeded(project, this.prioritySchemeManager.getPrioritiesFromIds(data.getPriorityIds()));
                if (migrationNeeded.isValid()) continue;
                return ServiceOutcomeImpl.from(migrationNeeded.getErrorCollection());
            }
        }
        FieldConfigScheme configSchemeForUpdate = new FieldConfigScheme.Builder(fieldConfigScheme).setName(data.getName()).setDescription(data.getDescription()).toFieldConfigScheme();
        return this.editScheme(user, configSchemeForUpdate, data.getPriorityIds(), data.getDefaultPriorityId());
    }

    @Override
    public ServiceResult deleteScheme(@Nonnull ApplicationUser user, @Nonnull Long id) {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (ec.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)ec);
        }
        FieldConfigScheme fieldConfigScheme = this.prioritySchemeManager.getScheme(id);
        if (Objects.isNull(fieldConfigScheme)) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.i18nHelper.getText("admin.schemes.priority.not_found", (Object)id), ErrorCollection.Reason.NOT_FOUND);
            return new ServiceResultImpl((ErrorCollection)errorCollection);
        }
        return this.deleteScheme(user, fieldConfigScheme);
    }

    @Override
    public ServiceResult deleteScheme(@Nonnull ApplicationUser user, @Nonnull FieldConfigScheme priorityFieldConfig) throws NoPermissionException {
        SimpleErrorCollection ec = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (ec.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)ec);
        }
        if (this.prioritySchemeManager.isDefaultScheme(priorityFieldConfig)) {
            ec.addErrorMessage(this.i18nHelper.getText("admin.schemes.priority.service.error.cant.delete.default"));
        }
        if (!ec.hasAnyErrors()) {
            Set projectsForScheme = this.prioritySchemeManager.getProjectsWithScheme(priorityFieldConfig);
            if (!projectsForScheme.isEmpty()) {
                this.assignProjects(user, null, projectsForScheme);
            }
            this.prioritySchemeManager.delete(priorityFieldConfig);
        }
        return new ServiceResultImpl((ErrorCollection)ec);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> createScheme(@Nonnull ApplicationUser user, @Nonnull PrioritySchemeService.PrioritySchemeData prioritySchemeData) {
        ServiceResult validate = this.schemeDataValidate(user, prioritySchemeData);
        if (!validate.isValid()) {
            return ServiceOutcomeImpl.from(validate.getErrorCollection());
        }
        FieldConfigScheme configScheme = this.prioritySchemeManager.createWithDefaultMapping(prioritySchemeData.getName(), prioritySchemeData.getDescription(), prioritySchemeData.getPriorityIds());
        if (StringUtils.isNotBlank((CharSequence)prioritySchemeData.getDefaultPriorityId())) {
            this.prioritySchemeManager.setDefaultOption(this.prioritySchemeManager.getFieldConfigForDefaultMapping(configScheme), prioritySchemeData.getDefaultPriorityId());
        }
        log.info((Object)("Config scheme '" + configScheme.getName() + "' created successfully. "));
        return ServiceOutcomeImpl.ok(configScheme);
    }

    @Override
    public ServiceResult schemeDataValidate(ApplicationUser user, PrioritySchemeService.PrioritySchemeData prioritySchemeData) {
        SimpleErrorCollection errors = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (errors.hasAnyErrors()) {
            return new ServiceResultImpl((ErrorCollection)errors);
        }
        if (CollectionUtils.exists((Collection)this.prioritySchemeManager.getAllSchemes(), (Predicate)new FieldConfigPredicate(prioritySchemeData.getId(), prioritySchemeData.getName()))) {
            errors.addError("name", this.i18nHelper.getText("admin.errors.issuetypes.duplicate.name"));
        }
        if (StringUtils.isBlank((CharSequence)prioritySchemeData.getName())) {
            errors.addError("name", this.i18nHelper.getText("admin.common.errors.validname"));
        }
        if (prioritySchemeData.getName().length() > 60) {
            errors.addError("name", this.i18nHelper.getText("admin.common.errors.exceeds.max.name.length", (Object)60));
        }
        if (prioritySchemeData.getPriorityIds().isEmpty()) {
            errors.addErrorMessage(this.i18nHelper.getText("admin.errors.issuetypes.must.select.option"));
        } else {
            for (String selectedPriority : prioritySchemeData.getPriorityIds()) {
                Priority priority = this.prioritySchemeManager.getPriority(selectedPriority);
                if (priority != null) continue;
                errors.addErrorMessage(this.i18nHelper.getText("admin.errors.issuetypes.invalid.option.id", selectedPriority));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)prioritySchemeData.getDefaultPriorityId()) && !prioritySchemeData.getPriorityIds().contains(prioritySchemeData.getDefaultPriorityId())) {
            errors.addError("defaultPriority", this.i18nHelper.getText("admin.errors.issuetypes.default.option.must.be.in.selected"));
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> getScheme(@Nonnull ApplicationUser user, @Nonnull Long id) {
        SimpleErrorCollection errors = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        FieldConfigScheme scheme = this.prioritySchemeManager.getScheme(id);
        if (Objects.isNull(scheme)) {
            return ServiceOutcomeImpl.error(this.i18nHelper.getText("admin.schemes.priority.not_found", (Object)id), ErrorCollection.Reason.NOT_FOUND);
        }
        return ServiceOutcomeImpl.ok(scheme);
    }

    @Override
    public ServiceOutcome<Collection<FieldConfigScheme>> getSchemes(@Nonnull ApplicationUser user) {
        SimpleErrorCollection errors = this.genericPermissionCheck(user, "admin.schemes.priority.service.error.no.admin.permission");
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        List schemes = this.prioritySchemeManager.getAllSchemes();
        return ServiceOutcomeImpl.ok(schemes);
    }

    @Override
    public ServiceOutcome<FieldConfigScheme> getSchemeForProject(@Nonnull ApplicationUser user, @Nonnull Either<Long, String> projectKeyOrId) {
        ProjectService.GetProjectResult getProjectResult = this.getProjectForAction(user, projectKeyOrId, PROJECT_ACTION_PERMISSION);
        if (!getProjectResult.isValid()) {
            return ServiceOutcomeImpl.error(getProjectResult);
        }
        Project project = getProjectResult.get();
        return ServiceOutcomeImpl.ok(this.prioritySchemeManager.getScheme(project));
    }

    private ServiceResult validateMigrationNeeded(@Nonnull Project project, Collection<Priority> prioritiesValidInScheme) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Set<Priority> toMigrate = this.prioritySchemeMigratorFinder.findUnmappedPriorities(project, prioritiesValidInScheme);
        if (!toMigrate.isEmpty()) {
            errors.addErrorMessage(this.i18nHelper.getText("admin.schemes.priority.migration.needed", toMigrate.stream().map(IssueConstant::getId).collect(Collectors.joining(","))));
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    @Override
    public List<Project> filterProjectsNotPossibleToAssociate(List<Project> projects) {
        Stream<Object> stream = projects.stream();
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT_JSD)) {
            stream = stream.filter(ProjectTypeKeys.projectTypePredicate(ProjectTypeKeys.SERVICE_DESK).negate());
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public boolean hasAnyNotPossibleToAssociateProject(Collection<Project> projects) {
        return !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT_JSD) && projects.stream().anyMatch(ProjectTypeKeys.projectTypePredicate(ProjectTypeKeys.SERVICE_DESK));
    }

    private ProjectService.GetProjectResult getProjectForAction(ApplicationUser user, Either<Long, String> projectKeyOrId, ProjectAction projectAction) {
        return (ProjectService.GetProjectResult)projectKeyOrId.fold(id -> this.projectService.getProjectByIdForAction(user, id, projectAction), key -> this.projectService.getProjectByKeyForAction(user, key, projectAction));
    }

    private SimpleErrorCollection genericPermissionCheck(ApplicationUser user, String errorMessage) {
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (!this.globalPermissionManager.hasPermission(0, user)) {
            ec.addErrorMessage(this.i18nHelper.getText(errorMessage), ErrorCollection.Reason.FORBIDDEN);
        }
        return ec;
    }
}

