/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.jira.bc.project.DefaultProjectService;
import com.atlassian.jira.issue.priority.PrioritySchemeMigrator;
import com.atlassian.jira.web.action.admin.customfields.ManageConfigurationScheme;
import com.atlassian.jira.web.action.admin.issuetypes.MigrateIssueTypes;
import com.atlassian.jira.web.action.admin.issuetypes.pro.SelectIssueTypeSchemeForProject;
import com.atlassian.jira.web.action.admin.priorities.AssociatePriorityScheme;
import com.atlassian.jira.web.action.admin.priorities.DeletePriorityScheme;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Pair;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

class StacktraceParser {
    private final Map<Pair<String, String>, String> classPlusMethodToMatchStrings;
    private static final Map<Pair<String, String>, String> fieldConfigSchemeManagerKnownCallers = new LinkedHashMap<Pair<String, String>, String>();

    StacktraceParser(String classNameFragment, String methodName, String matchString) {
        this.classPlusMethodToMatchStrings = new LinkedHashMap<Pair<String, String>, String>();
        this.classPlusMethodToMatchStrings.put((Pair<String, String>)new Pair((Object)classNameFragment, (Object)methodName), matchString);
    }

    StacktraceParser(Map<Pair<String, String>, String> classPlusMethodToMatchStrings) {
        this.classPlusMethodToMatchStrings = ImmutableMap.copyOf(classPlusMethodToMatchStrings);
    }

    String checkForKnownCallers(StackTraceElement[] stackTraceElements) {
        try {
            Optional<String> firstMatch = Arrays.stream(stackTraceElements).map(this::checkFrameForMatch).filter(Optional::isPresent).map(Optional::get).findFirst();
            return firstMatch.orElse("unknown");
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private Optional<String> checkFrameForMatch(StackTraceElement stackTraceElement) {
        return this.classPlusMethodToMatchStrings.entrySet().stream().filter(e -> this.classAndMethodMatch((Pair<String, String>)((Pair)e.getKey()), stackTraceElement)).map(Map.Entry::getValue).findFirst();
    }

    private boolean classAndMethodMatch(Pair<String, String> classAndMethod, StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().contains((CharSequence)classAndMethod.left()) && stackTraceElement.getMethodName().equals(classAndMethod.right());
    }

    static StacktraceParser createStacktraceParserForFieldConfigSchemeManager() {
        return new StacktraceParser(fieldConfigSchemeManagerKnownCallers);
    }

    private static Map<Pair<String, String>, String> makeEntry(String className, String methodName) {
        LinkedHashMap<Pair<String, String>, String> oneEntryMap = new LinkedHashMap<Pair<String, String>, String>();
        oneEntryMap.put(new Pair((Object)className, (Object)methodName), className + "." + methodName);
        return oneEntryMap;
    }

    static {
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("IssueTypeSchemeResource", "addProjectAssociationsToScheme"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("IssueTypeSchemeResource", "removeAllProjectAssociations"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("IssueTypeSchemeResource", "removeProjectAssociation"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("IssueTypeSchemeResource", "setProjectAssociatonsForScheme"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("IssueTypeSchemeResource", "updateIssueTypeScheme"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("PrioritySchemeResource", "deletePrioritySchemeResource"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("ProjectPrioritySchemeResource", "assignPriorityScheme"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(AssociatePriorityScheme.class.getSimpleName(), "doExecute"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(DeletePriorityScheme.class.getSimpleName(), "doExecute"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(DefaultProjectService.class.getSimpleName(), "createProject"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(ManageConfigurationScheme.class.getSimpleName(), "doExecute"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(MigrateIssueTypes.class.getSimpleName(), "doPerform"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry("MigratePrioritySchemeAction$MigrateSchemeTask", "call"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(PrioritySchemeMigrator.class.getSimpleName(), "migrateSingleProject"));
        fieldConfigSchemeManagerKnownCallers.putAll(StacktraceParser.makeEntry(SelectIssueTypeSchemeForProject.class.getSimpleName(), "doExecute"));
    }
}

