/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayout;
import java.util.ArrayList;
import java.util.List;

public abstract class EditableColumnLayoutImpl
extends ColumnLayoutImpl
implements EditableColumnLayout {
    public EditableColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems, ColumnLayout.ColumnConfig columnConfig) {
        super(new ArrayList<ColumnLayoutItem>(columnLayoutItems), columnConfig);
    }

    public EditableColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems) {
        this(columnLayoutItems, ColumnLayout.ColumnConfig.NONE);
    }

    public void addColumn(NavigableField navigableField) {
        ColumnLayoutItemImpl columnLayoutItem = new ColumnLayoutItemImpl(navigableField, this.getInternalList().size());
        this.getInternalList().add(columnLayoutItem);
    }

    public void removeColumn(ColumnLayoutItem columnLayoutItem) {
        this.getInternalList().remove(columnLayoutItem);
    }

    public void moveColumnLeft(ColumnLayoutItem columnLayoutItem) {
        if (columnLayoutItem.getPosition() <= 0) {
            throw new IllegalArgumentException("Trying to move left-most column left.");
        }
        List<ColumnLayoutItem> internalList = this.getInternalList();
        int moveLeftPosition = internalList.indexOf(columnLayoutItem);
        ColumnLayoutItem moveLeft = internalList.get(moveLeftPosition);
        ColumnLayoutItem moveRight = internalList.get(moveLeftPosition - 1);
        moveLeft = new ColumnLayoutItemImpl(moveLeft.getNavigableField(), moveLeft.getPosition() - 1);
        moveRight = new ColumnLayoutItemImpl(moveRight.getNavigableField(), moveRight.getPosition() + 1);
        internalList.set(moveLeftPosition - 1, moveLeft);
        internalList.set(moveLeftPosition, moveRight);
    }

    public void setColumns(List<NavigableField> selectedFields) {
        this.getInternalList().clear();
        for (NavigableField field : selectedFields) {
            this.addColumn(field);
        }
    }

    public void moveColumnRight(ColumnLayoutItem columnLayoutItem) {
        List<ColumnLayoutItem> internalList = this.getInternalList();
        int moveRightPosition = internalList.indexOf(columnLayoutItem);
        if (moveRightPosition >= internalList.size() - 1) {
            throw new IllegalArgumentException("Trying to move right-most column right.");
        }
        ColumnLayoutItem moveRight = internalList.get(moveRightPosition);
        ColumnLayoutItem moveLeft = internalList.get(moveRightPosition + 1);
        moveRight = new ColumnLayoutItemImpl(moveRight.getNavigableField(), moveRight.getPosition() + 1);
        moveLeft = new ColumnLayoutItemImpl(moveLeft.getNavigableField(), moveLeft.getPosition() - 1);
        internalList.set(moveRightPosition + 1, moveRight);
        internalList.set(moveRightPosition, moveLeft);
    }
}

