/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.EntityFunctions;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeAddedToProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCopiedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeDeletedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityRemovedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityUpdatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.AbstractFieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntityImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeImpl;
import com.atlassian.jira.issue.fields.layout.field.enterprise.ImmutableFieldConfigurationScheme;
import com.atlassian.jira.model.querydsl.QFieldLayoutItem;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultFieldLayoutManager
extends AbstractFieldLayoutManager
implements FieldLayoutManager {
    private static final String PROJECT_ENTITY_NAME = "Project";
    private static final String FIELD_LAYOUT_SCHEME_ASSOCIATION = "FieldLayoutScheme";
    private static final NodeAssocationType NODE_ASSOCATION_TYPE = new NodeAssocationType("ProjectScheme", "Project", "FieldLayoutScheme");
    private static final Logger log = LoggerFactory.getLogger(DefaultFieldLayoutManager.class);
    private final Cache<Long, CacheObject<Long>> fieldSchemeCache;
    private final Cache<Long, ImmutableFieldConfigurationScheme> fieldConfigurationSchemeCache;
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final ProjectManager projectManager;
    private final EventPublisher eventPublisher;
    private final NodeAssociationStore nodeAssociationStore;
    private final QueryDslAccessor queryDslAccessor;

    public DefaultFieldLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, SubTaskManager subTaskManager, ProjectManager projectManager, I18nHelper.BeanFactory i18nFactory, NodeAssociationStore nodeAssociationStore, CacheManager cacheManager, EventPublisher eventPublisher, ApplicationProperties applicationProperties, QueryDslAccessor queryDslAccessor) {
        super(fieldManager, ofBizDelegator, i18nFactory, cacheManager, applicationProperties);
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.constantsManager = Objects.requireNonNull(constantsManager, "constantsManager");
        this.subTaskManager = Objects.requireNonNull(subTaskManager, "subTaskManager");
        this.nodeAssociationStore = Objects.requireNonNull(nodeAssociationStore, "nodeAssociationStore");
        this.queryDslAccessor = Objects.requireNonNull(queryDslAccessor, "queryDslAccessor");
        this.fieldSchemeCache = cacheManager.getCache(DefaultFieldLayoutManager.class.getName() + ".fieldSchemeCache", (CacheLoader)new FieldSchemeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.fieldConfigurationSchemeCache = cacheManager.getCache(DefaultFieldLayoutManager.class.getName() + ".fieldConfigurationSchemeCache", (CacheLoader)new ConfigurationSchemeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public FieldLayout getFieldLayout(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("GenericValue must be an issue. It is a(n) " + issue.getEntityName() + '.');
        }
        return this.getFieldLayout(this.projectManager.getProjectObj(issue.getLong("project")), issue.getString("type"));
    }

    public FieldLayout getFieldLayout(Project project, String issueTypeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null.");
        }
        Set<FieldLayout> layouts = issueTypeId == null ? this.getUniqueFieldLayouts((Iterable<Long>)ImmutableList.of((Object)project.getId()), this.constantsManager.getAllIssueTypeIds()) : this.getUniqueFieldLayouts((Iterable<Long>)ImmutableList.of((Object)project.getId()), (Iterable<String>)ImmutableList.of((Object)issueTypeId));
        if (layouts.size() > 0) {
            return layouts.iterator().next();
        }
        return null;
    }

    public FieldLayout getFieldLayout(@Nonnull Long projectId, @Nonnull String issueTypeId) {
        Set<FieldLayout> layouts = this.getUniqueFieldLayouts((Iterable<Long>)ImmutableList.of((Object)projectId), (Iterable<String>)ImmutableList.of((Object)issueTypeId));
        if (layouts.size() > 0) {
            return layouts.iterator().next();
        }
        return null;
    }

    private ImmutableFieldConfigurationScheme buildFieldConfigurationScheme(GenericValue fieldLayoutSchemeGV) {
        Assertions.notNull((String)"fieldLayoutSchemeGV", (Object)fieldLayoutSchemeGV);
        Collection<GenericValue> schemeEntities = this.getFieldLayoutSchemeEntityGVs(fieldLayoutSchemeGV.getLong("id"));
        return new ImmutableFieldConfigurationScheme(fieldLayoutSchemeGV, schemeEntities);
    }

    private Collection<GenericValue> getFieldLayoutSchemeEntityGVs(Long fieldLayoutSchemeId) {
        try {
            return this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "scheme", (Object)fieldLayoutSchemeId);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while retrieving field layout scheme entities from the database.", (Throwable)e);
        }
    }

    public List<FieldLayoutScheme> getFieldLayoutSchemes() {
        LinkedList<FieldLayoutScheme> fieldLayoutSchemes = new LinkedList<FieldLayoutScheme>();
        List fieldLayoutSchemeGVs = this.ofBizDelegator.findAll(FIELD_LAYOUT_SCHEME_ASSOCIATION, Collections.singletonList("name ASC"));
        for (GenericValue fieldLayoutSchemeGV : fieldLayoutSchemeGVs) {
            fieldLayoutSchemes.add(this.buildFieldLayoutScheme(fieldLayoutSchemeGV));
        }
        return fieldLayoutSchemes;
    }

    public Collection<GenericValue> getRelatedProjects(FieldLayout fieldLayout) {
        ArrayList<GenericValue> relatedProjects = new ArrayList<GenericValue>();
        for (FieldConfigurationScheme fieldConfigurationScheme : this.getFieldConfigurationSchemes(fieldLayout)) {
            relatedProjects.addAll(this.getProjects(fieldConfigurationScheme));
        }
        if (fieldLayout.isDefault()) {
            relatedProjects.addAll(this.getProjects((FieldConfigurationScheme)null));
        }
        return relatedProjects;
    }

    public Collection<Project> getProjectsUsing(FieldLayout fieldLayout) {
        ArrayList<Project> relatedProjects = new ArrayList<Project>();
        for (FieldConfigurationScheme fieldConfigurationScheme : this.getFieldConfigurationSchemes(fieldLayout)) {
            relatedProjects.addAll(this.getProjectsUsing(fieldConfigurationScheme));
        }
        if (fieldLayout.isDefault()) {
            relatedProjects.addAll(this.getProjectsUsing((FieldConfigurationScheme)null));
        }
        return relatedProjects;
    }

    public List<EditableFieldLayout> getEditableFieldLayouts() {
        LinkedList<EditableFieldLayout> fieldLayouts = new LinkedList<EditableFieldLayout>();
        fieldLayouts.add((EditableFieldLayout)this.getEditableDefaultFieldLayout());
        List fieldLayoutGVs = this.ofBizDelegator.findByField("FieldLayout", "type", null, "name");
        for (GenericValue editableFieldLayoutGV : fieldLayoutGVs) {
            FieldLayout fieldLayout = this.getRelevantFieldLayout(editableFieldLayoutGV.getLong("id"));
            fieldLayouts.add((EditableFieldLayout)new EditableFieldLayoutImpl(fieldLayout.getGenericValue(), fieldLayout.getFieldLayoutItems()));
        }
        return fieldLayouts;
    }

    public EditableFieldLayout getEditableFieldLayout(Long id) {
        FieldLayout fieldLayout = this.getRelevantFieldLayout(id);
        return new EditableFieldLayoutImpl(fieldLayout.getGenericValue(), fieldLayout.getFieldLayoutItems());
    }

    public void updateFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        if (!TextUtils.stringSet((String)fieldLayoutScheme.getName())) {
            throw new IllegalArgumentException("Name passed must not be null.");
        }
        try {
            FieldLayoutScheme originalScheme = this.getMutableFieldLayoutScheme(fieldLayoutScheme.getId());
            this.clearCaches();
            fieldLayoutScheme.getGenericValue().store();
            if (fieldLayoutScheme.getEntities() != null) {
                for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : fieldLayoutScheme.getEntities()) {
                    fieldLayoutSchemeEntity.store();
                }
            }
            this.eventPublisher.publish((Object)new FieldLayoutSchemeUpdatedEvent(fieldLayoutScheme, originalScheme));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            this.nodeAssociationStore.removeAssociationsFromSink(fieldLayoutScheme.getGenericValue());
            fieldLayoutScheme.getGenericValue().remove();
            this.refresh();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeDeletedEvent(fieldLayoutScheme.getId(), fieldLayoutScheme.getName()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteFieldLayout(FieldLayout fieldLayout) {
        try {
            GenericValue genericValue = fieldLayout.getGenericValue();
            if (genericValue != null) {
                genericValue.removeRelated("ChildFieldLayoutItem");
                genericValue.remove();
            }
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<FieldLayoutSchemeEntity> getFieldLayoutSchemeEntities(FieldLayoutScheme fieldLayoutScheme) {
        try {
            LinkedList<FieldLayoutSchemeEntity> fieldLayoutSchemeEntities = new LinkedList<FieldLayoutSchemeEntity>();
            List fieldLayoutSchemeEntityGVs = this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "scheme", (Object)fieldLayoutScheme.getId());
            for (GenericValue fieldLayoutSchemeEntityGV : fieldLayoutSchemeEntityGVs) {
                FieldLayoutSchemeEntityImpl fieldLayoutSchemeEntity = new FieldLayoutSchemeEntityImpl(this, fieldLayoutSchemeEntityGV, ComponentAccessor.getConstantsManager());
                fieldLayoutSchemeEntity.setFieldLayoutScheme(fieldLayoutScheme);
                fieldLayoutSchemeEntities.add(fieldLayoutSchemeEntity);
            }
            return fieldLayoutSchemeEntities;
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while retrieving field layout scheme entities from the database.", (Throwable)e);
        }
    }

    public void createFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        this.createFieldLayoutSchemeEntity(fieldLayoutSchemeEntity.getFieldLayoutScheme(), fieldLayoutSchemeEntity.getIssueTypeId(), fieldLayoutSchemeEntity.getFieldLayoutId());
    }

    public void updateFieldLayoutSchemeEntity(final FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        Option originalEntity = io.atlassian.fugue.Iterables.first((Iterable)Iterables.filter(this.getFieldLayoutSchemeEntities(fieldLayoutSchemeEntity.getFieldLayoutScheme()), (Predicate)new Predicate<FieldLayoutSchemeEntity>(){

            public boolean apply(@Nullable FieldLayoutSchemeEntity input) {
                return StringUtils.equals((CharSequence)input.getIssueTypeId(), (CharSequence)fieldLayoutSchemeEntity.getIssueTypeId());
            }
        }));
        try {
            fieldLayoutSchemeEntity.getGenericValue().store();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeEntityUpdatedEvent(fieldLayoutSchemeEntity.getFieldLayoutScheme(), (FieldLayoutSchemeEntity)originalEntity.getOrElse((Object)fieldLayoutSchemeEntity), fieldLayoutSchemeEntity));
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while persisting field layout scheme entity.", (Throwable)e);
        }
    }

    protected void removeFieldLayoutSchemeEntityNoEvent(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        try {
            FieldLayoutScheme fieldLayoutScheme = fieldLayoutSchemeEntity.getFieldLayoutScheme();
            ((FieldLayoutSchemeImpl)fieldLayoutScheme).flushEntity(fieldLayoutSchemeEntity);
            fieldLayoutSchemeEntity.setFieldLayoutScheme(null);
            fieldLayoutSchemeEntity.getGenericValue().remove();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while removing field layout scheme entity.", (Throwable)e);
        }
    }

    public void removeFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        FieldLayoutScheme scheme = fieldLayoutSchemeEntity.getFieldLayoutScheme();
        this.removeFieldLayoutSchemeEntityNoEvent(fieldLayoutSchemeEntity);
        this.eventPublisher.publish((Object)new FieldLayoutSchemeEntityRemovedEvent(scheme, fieldLayoutSchemeEntity));
    }

    public void removeFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : fieldLayoutScheme.getEntities()) {
                this.removeFieldLayoutSchemeEntityNoEvent(fieldLayoutSchemeEntity);
            }
            fieldLayoutScheme.getGenericValue().remove();
            this.clearCaches();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeDeletedEvent(fieldLayoutScheme.getId(), fieldLayoutScheme.getName()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<FieldConfigurationScheme> getFieldConfigurationSchemes(FieldLayout fieldLayout) {
        Long id = fieldLayout.isDefault() ? null : fieldLayout.getId();
        HashSet<Long> fieldLayoutSchemeIds = new HashSet<Long>();
        List fieldLayoutSchemeEntitiyGVs = this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "fieldlayout", (Object)id);
        for (GenericValue fieldLayoutSchemeEntitiyGV : fieldLayoutSchemeEntitiyGVs) {
            fieldLayoutSchemeIds.add(fieldLayoutSchemeEntitiyGV.getLong("scheme"));
        }
        HashSet<FieldConfigurationScheme> fieldConfigurationSchemes = new HashSet<FieldConfigurationScheme>(fieldLayoutSchemeIds.size());
        for (Long schemeId : fieldLayoutSchemeIds) {
            fieldConfigurationSchemes.add(this.getFieldConfigurationScheme(schemeId));
        }
        return fieldConfigurationSchemes;
    }

    public Collection<GenericValue> getProjects(FieldConfigurationScheme fieldConfigurationScheme) {
        if (fieldConfigurationScheme == null) {
            return this.getProjectGVsWithDefaultFieldConfigurationScheme();
        }
        GenericValue fieldConfigurationSchemeGV = this.makeFieldLayoutSchemeGenericValue(fieldConfigurationScheme.getId());
        return this.nodeAssociationStore.getSourcesFromSink(fieldConfigurationSchemeGV, PROJECT_ENTITY_NAME, "ProjectScheme");
    }

    private Collection<GenericValue> getProjectGVsWithDefaultFieldConfigurationScheme() {
        List projects = this.projectManager.getProjectObjects();
        ArrayList<GenericValue> filteredProjects = new ArrayList<GenericValue>(projects.size());
        for (Project project : projects) {
            if (this.getFieldConfigurationScheme(project) != null) continue;
            filteredProjects.add(project.getGenericValue());
        }
        return filteredProjects;
    }

    public Collection<Project> getProjectsUsing(FieldConfigurationScheme fieldConfigurationScheme) {
        if (fieldConfigurationScheme == null) {
            return this.getProjectObjectsWithDefaultFieldConfigurationScheme();
        }
        GenericValue fieldConfigurationSchemeGV = this.makeFieldLayoutSchemeGenericValue(fieldConfigurationScheme.getId());
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(fieldConfigurationSchemeGV, PROJECT_ENTITY_NAME, "ProjectScheme");
        return this.projectManager.convertToProjectObjects(projectIds);
    }

    private Collection<Project> getProjectObjectsWithDefaultFieldConfigurationScheme() {
        List allProjects = this.projectManager.getProjectObjects();
        ArrayList<Project> projects = new ArrayList<Project>(allProjects.size());
        for (Project project : allProjects) {
            if (this.getFieldConfigurationScheme(project) != null) continue;
            projects.add(project);
        }
        return projects;
    }

    public Collection<GenericValue> getProjects(FieldLayoutScheme fieldLayoutScheme) {
        return this.nodeAssociationStore.getSourcesFromSink(fieldLayoutScheme.getGenericValue(), PROJECT_ENTITY_NAME, "ProjectScheme");
    }

    public Collection<Project> getProjectsUsing(FieldLayoutScheme fieldLayoutScheme) {
        if (fieldLayoutScheme == null) {
            return this.getProjectObjectsWithDefaultFieldConfigurationScheme();
        }
        GenericValue fieldConfigurationSchemeGV = this.makeFieldLayoutSchemeGenericValue(fieldLayoutScheme.getId());
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(fieldConfigurationSchemeGV, PROJECT_ENTITY_NAME, "ProjectScheme");
        return this.projectManager.convertToProjectObjects(projectIds);
    }

    public FieldLayoutScheme createFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        return this.createFieldLayoutScheme(fieldLayoutScheme.getName(), fieldLayoutScheme.getDescription());
    }

    public FieldLayoutScheme createFieldLayoutScheme(@Nonnull String name, @Nullable String description) {
        FieldLayoutScheme fieldLayoutScheme = this.createFieldLayoutSchemeNoEvent(name, description);
        this.createFieldLayoutSchemeEntityNoEvent(fieldLayoutScheme, null, null);
        this.eventPublisher.publish((Object)new FieldLayoutSchemeCreatedEvent(fieldLayoutScheme));
        return fieldLayoutScheme;
    }

    public FieldLayoutSchemeEntity createFieldLayoutSchemeEntity(@Nonnull FieldLayoutScheme fieldLayoutScheme, @Nullable String issueTypeId, @Nullable Long fieldLayoutId) {
        FieldLayoutSchemeEntity entity = this.createFieldLayoutSchemeEntityNoEvent(fieldLayoutScheme, issueTypeId, fieldLayoutId);
        this.eventPublisher.publish((Object)new FieldLayoutSchemeEntityCreatedEvent(fieldLayoutScheme, entity));
        return entity;
    }

    protected FieldLayoutSchemeEntity createFieldLayoutSchemeEntityNoEvent(@Nonnull FieldLayoutScheme fieldLayoutScheme, @Nullable String issueTypeId, @Nullable Long fieldLayoutId) {
        FieldLayoutSchemeEntityImpl entity = new FieldLayoutSchemeEntityImpl(this, null, ComponentAccessor.getConstantsManager());
        entity.setIssueTypeId(issueTypeId);
        entity.setFieldLayoutId(fieldLayoutId);
        entity.setFieldLayoutScheme(fieldLayoutScheme);
        GenericValue fieldLayoutSchemeEntityGV = EntityUtils.createValue("FieldLayoutSchemeEntity", MapBuilder.build((Object)"scheme", (Object)fieldLayoutScheme.getId(), (Object)"issuetype", (Object)issueTypeId, (Object)"fieldlayout", (Object)fieldLayoutId));
        entity.setGenericValue(fieldLayoutSchemeEntityGV);
        this.clearCaches();
        ((FieldLayoutSchemeImpl)fieldLayoutScheme).cacheEntity(entity);
        return entity;
    }

    private FieldLayoutScheme createFieldLayoutSchemeNoEvent(String name, String description) {
        FieldLayoutSchemeImpl fieldLayoutScheme = new FieldLayoutSchemeImpl(this, null);
        fieldLayoutScheme.setName(name);
        fieldLayoutScheme.setDescription(description);
        GenericValue genericValue = EntityUtils.createValue(FIELD_LAYOUT_SCHEME_ASSOCIATION, (Map<String, Object>)FieldMap.build((String)"name", (Object)fieldLayoutScheme.getName(), (String)"description", (Object)fieldLayoutScheme.getDescription()));
        fieldLayoutScheme.setGenericValue(genericValue);
        return fieldLayoutScheme;
    }

    public FieldLayoutScheme copyFieldLayoutScheme(@Nonnull FieldLayoutScheme scheme, @Nonnull String name, @Nullable String description) {
        FieldLayoutScheme fieldLayoutScheme = this.createFieldLayoutSchemeNoEvent(name, description);
        for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : scheme.getEntities()) {
            this.createFieldLayoutSchemeEntityNoEvent(fieldLayoutScheme, fieldLayoutSchemeEntity.getIssueTypeId(), fieldLayoutSchemeEntity.getFieldLayoutId());
        }
        this.eventPublisher.publish((Object)new FieldLayoutSchemeCopiedEvent(scheme, fieldLayoutScheme));
        return fieldLayoutScheme;
    }

    private FieldLayoutScheme buildFieldLayoutScheme(GenericValue genericValue) {
        if (genericValue != null) {
            return new FieldLayoutSchemeImpl(this, genericValue);
        }
        return null;
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(Long schemeId) {
        return (FieldConfigurationScheme)this.fieldConfigurationSchemeCache.get((Object)schemeId);
    }

    public FieldLayoutScheme getMutableFieldLayoutScheme(Long schemeId) {
        return this.buildFieldLayoutScheme(this.ofBizDelegator.findById(FIELD_LAYOUT_SCHEME_ASSOCIATION, schemeId));
    }

    public boolean fieldConfigurationSchemeExists(String schemeName) {
        return !this.ofBizDelegator.findByField(FIELD_LAYOUT_SCHEME_ASSOCIATION, "name", (Object)schemeName).isEmpty();
    }

    public Set<FieldLayout> getUniqueFieldLayouts(Project project) {
        return this.getUniqueFieldLayouts((Iterable<Long>)ImmutableList.of((Object)project.getId()), this.constantsManager.getAllIssueTypeIds());
    }

    @Nonnull
    public Set<FieldLayout> getUniqueFieldLayouts(@Nonnull Collection<Project> projects, @Nonnull Collection<String> issueTypeIds) {
        return this.getUniqueFieldLayouts(Iterables.transform(projects, EntityFunctions.TO_ID), issueTypeIds);
    }

    @Nonnull
    private Set<FieldLayout> getUniqueFieldLayouts(@Nonnull Iterable<Long> projects, @Nonnull Iterable<String> issueTypeIds) {
        HashSet<FieldLayout> uniqueLayouts = new HashSet<FieldLayout>();
        boolean includeDefaultScheme = false;
        HashMap<Long, FieldConfigurationScheme> schemes = new HashMap<Long, FieldConfigurationScheme>();
        for (Long projectId : projects) {
            FieldConfigurationScheme scheme = this.getFieldConfigurationSchemeForProject(projectId);
            if (scheme != null) {
                schemes.put(scheme.getId(), scheme);
                continue;
            }
            includeDefaultScheme = true;
        }
        HashSet<Long> layoutIds = new HashSet<Long>();
        for (FieldConfigurationScheme scheme : schemes.values()) {
            for (String issueTypeId : issueTypeIds) {
                layoutIds.add(scheme.getFieldLayoutId(issueTypeId));
            }
        }
        for (Long layoutId : layoutIds) {
            FieldLayout fieldLayout = this.getFieldLayout(layoutId);
            if (fieldLayout == null) continue;
            uniqueLayouts.add(fieldLayout);
        }
        if (includeDefaultScheme) {
            CollectionUtils.addIgnoreNull(uniqueLayouts, (Object)SafePluginPointAccess.call((Callable)new Callable<FieldLayout>(){

                @Override
                public FieldLayout call() throws Exception {
                    return DefaultFieldLayoutManager.this.getFieldLayout();
                }
            }).getOrNull());
        }
        return uniqueLayouts;
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        return this.getFieldConfigurationSchemeForProject(project.getId());
    }

    public FieldConfigurationScheme getFieldConfigurationSchemeForProject(@Nonnull Long projectId) {
        CacheObject cacheObject = (CacheObject)this.fieldSchemeCache.get((Object)projectId);
        if (cacheObject.getValue() == null) {
            return null;
        }
        return this.getFieldConfigurationScheme((Long)cacheObject.getValue());
    }

    @Nullable
    private FieldConfigurationScheme getFieldConfigurationScheme(GenericValue project) {
        if (project == null) {
            log.error("Project passed must not be null.");
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        return this.getFieldConfigurationSchemeForProject(project.getLong("id"));
    }

    public void addSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        this.addSchemeAssociation(this.projectManager.getProjectObj(project.getLong("id")), fieldLayoutSchemeId);
    }

    public void addSchemeAssociation(Project project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        FieldConfigurationScheme oldScheme = this.getFieldConfigurationScheme(project);
        if (oldScheme != null) {
            this.removeSchemeAssociation(project, oldScheme.getId());
        }
        if (fieldLayoutSchemeId != null) {
            this.nodeAssociationStore.createAssociation(NODE_ASSOCATION_TYPE, project.getId(), fieldLayoutSchemeId);
            this.clearCaches();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeAddedToProjectEvent(this.getMutableFieldLayoutScheme(fieldLayoutSchemeId), project));
        }
    }

    private GenericValue makeFieldLayoutSchemeGenericValue(Long fieldLayoutSchemeId) {
        GenericValue gvFieldLayoutScheme = this.ofBizDelegator.makeValue(FIELD_LAYOUT_SCHEME_ASSOCIATION);
        gvFieldLayoutScheme.set("id", (Object)fieldLayoutSchemeId);
        return gvFieldLayoutScheme;
    }

    public void removeSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null.");
        }
        this.removeSchemeAssociation(this.projectManager.getProjectObj(project.getLong("id")), fieldLayoutSchemeId);
    }

    public void removeSchemeAssociation(Project project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        this.nodeAssociationStore.removeAssociation(NODE_ASSOCATION_TYPE, project.getId(), fieldLayoutSchemeId);
        this.clearCaches();
        FieldLayoutScheme mutableFieldLayoutScheme = this.getMutableFieldLayoutScheme(fieldLayoutSchemeId);
        if (mutableFieldLayoutScheme != null) {
            this.eventPublisher.publish((Object)new FieldLayoutSchemeRemovedFromProjectEvent(mutableFieldLayoutScheme, project));
        }
    }

    public FieldLayout getFieldLayout(Long id) {
        return this.getRelevantFieldLayout(id);
    }

    @Override
    public void refresh() {
        this.clearCaches();
        super.refresh();
    }

    protected void clearCaches() {
        this.fieldSchemeCache.removeAll();
        this.fieldConfigurationSchemeCache.removeAll();
    }

    public boolean isFieldLayoutSchemesVisiblyEquivalent(Long fieldConfigurationSchemeId1, Long fieldConfigurationSchemeId2) {
        if (fieldConfigurationSchemeId1 == null && fieldConfigurationSchemeId2 == null) {
            return true;
        }
        FieldConfigurationScheme scheme1 = this.getNotNullFieldConfigurationScheme(fieldConfigurationSchemeId1);
        FieldConfigurationScheme scheme2 = this.getNotNullFieldConfigurationScheme(fieldConfigurationSchemeId2);
        for (String issueType : this.getAllRelevantIssueTypeIds()) {
            if (this.isFieldLayoutsVisiblyEquivalent(scheme1.getFieldLayoutId(issueType), scheme2.getFieldLayoutId(issueType))) continue;
            return false;
        }
        return true;
    }

    private FieldConfigurationScheme getNotNullFieldConfigurationScheme(Long fieldConfigurationSchemeId) {
        if (fieldConfigurationSchemeId == null) {
            return new DefaultFieldConfigurationScheme();
        }
        return this.getFieldConfigurationScheme(fieldConfigurationSchemeId);
    }

    public boolean isFieldLayoutsVisiblyEquivalent(Long fieldLayoutId1, Long fieldLayoutId2) {
        Map<String, Boolean> map1 = this.createFieldIdToVisibilityMap(fieldLayoutId1);
        Map<String, Boolean> map2 = this.createFieldIdToVisibilityMap(fieldLayoutId2);
        return map1.equals(map2);
    }

    public void updateFieldLayoutItemAttributesForCustomField(@Nonnull CustomField customField, @Nonnull String description, boolean isRequired, boolean isHidden) {
        this.queryDslAccessor.execute(dbConnection -> {
            long count = dbConnection.update((RelationalPath<?>)QFieldLayoutItem.FIELD_LAYOUT_ITEM).set((Path)QFieldLayoutItem.FIELD_LAYOUT_ITEM.description, (Object)description).set((Path)QFieldLayoutItem.FIELD_LAYOUT_ITEM.ishidden, (Object)Boolean.toString(isHidden)).set((Path)QFieldLayoutItem.FIELD_LAYOUT_ITEM.isrequired, (Object)Boolean.toString(isRequired)).where((com.querydsl.core.types.Predicate)QFieldLayoutItem.FIELD_LAYOUT_ITEM.fieldidentifier.eq((Object)customField.getId())).execute();
            if (count > 0L) {
                this.refresh();
            }
        });
    }

    private Map<String, Boolean> createFieldIdToVisibilityMap(Long fieldLayoutId) {
        FieldLayout fieldLayout = this.getFieldLayout(fieldLayoutId);
        List list = fieldLayout.getFieldLayoutItems();
        HashMap map = Maps.newHashMapWithExpectedSize((int)list.size());
        for (FieldLayoutItem item : list) {
            map.put(item.getOrderableField().getId(), item.isHidden());
        }
        return map;
    }

    protected List<String> getAllRelevantIssueTypeIds() {
        if (this.subTaskManager.isSubTasksEnabled()) {
            return this.constantsManager.getAllIssueTypeIds();
        }
        return CollectionUtil.transform(this.constantsManager.getRegularIssueTypeObjects().iterator(), input -> input.getId());
    }

    private class ConfigurationSchemeCacheLoader
    implements CacheLoader<Long, ImmutableFieldConfigurationScheme> {
        private ConfigurationSchemeCacheLoader() {
        }

        public ImmutableFieldConfigurationScheme load(@Nonnull Long schemeId) {
            GenericValue fieldLayoutSchemeGV = DefaultFieldLayoutManager.this.ofBizDelegator.findById(DefaultFieldLayoutManager.FIELD_LAYOUT_SCHEME_ASSOCIATION, schemeId);
            if (fieldLayoutSchemeGV == null) {
                throw new DataAccessException("No FieldLayoutScheme found for id " + schemeId);
            }
            return DefaultFieldLayoutManager.this.buildFieldConfigurationScheme(fieldLayoutSchemeGV);
        }
    }

    private class FieldSchemeCacheLoader
    implements CacheLoader<Long, CacheObject<Long>> {
        private FieldSchemeCacheLoader() {
        }

        public CacheObject<Long> load(@Nonnull Long projectId) {
            GenericValue fieldLayoutSchemeGV = EntityUtil.getOnly(DefaultFieldLayoutManager.this.nodeAssociationStore.getSinksFromSource(DefaultFieldLayoutManager.PROJECT_ENTITY_NAME, projectId, DefaultFieldLayoutManager.FIELD_LAYOUT_SCHEME_ASSOCIATION, "ProjectScheme"));
            if (fieldLayoutSchemeGV != null) {
                return new CacheObject<Long>(fieldLayoutSchemeGV.getLong("id"));
            }
            return new CacheObject<Object>(null);
        }
    }

    static class DefaultFieldConfigurationScheme
    implements FieldConfigurationScheme {
        DefaultFieldConfigurationScheme() {
        }

        public Long getId() {
            return null;
        }

        public String getName() {
            return "Default Field Configuration Scheme";
        }

        public String getDescription() {
            return "";
        }

        public Long getFieldLayoutId(String issueTypeId) {
            return null;
        }

        public Set<Long> getAllFieldLayoutIds(Collection<String> allIssueTypeIds) {
            return Collections.singleton(null);
        }
    }
}

