/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.jira.issue.fields.renderer.wiki.embedded.ConditionalEmbeddedRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.PlaceholderImageRenderer;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraPlaceholderImageRenderer
extends PlaceholderImageRenderer
implements ConditionalEmbeddedRenderer {
    private static final Logger log = LoggerFactory.getLogger(JiraPlaceholderImageRenderer.class);
    private final RendererAttachmentManager attachmentManager;

    public JiraPlaceholderImageRenderer(RendererAttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    protected String outputParameters(Map params) {
        StringBuffer buff = new StringBuffer(20);
        TreeMap sortedParams = new TreeMap(params);
        for (String key : sortedParams.keySet()) {
            buff.append(HtmlEscaper.escapeAll((String)key, (boolean)true)).append("=\"").append(HtmlEscaper.escapeAll((String)((String)sortedParams.get(key)), (boolean)true)).append("\" ");
        }
        return buff.toString();
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        if (Objects.isNull(context.getParam((Object)"com.atlassian.renderer.embedded.placeholder.image.name"))) {
            context.addParam((Object)"com.atlassian.renderer.embedded.placeholder.image.name", (Object)"/icons/attach/noimage.png");
        }
        return context.addRenderedContent((Object)String.format("<img src=\"%s%s\" imagetext=\"%s\" %s/>", HtmlEscaper.escapeAll((String)context.getImagePath(), (boolean)true), HtmlEscaper.escapeAll((String)context.getParam((Object)"com.atlassian.renderer.embedded.placeholder.image.name").toString(), (boolean)true), HtmlEscaper.escapeAll((String)resource.getOriginalLinkText(), (boolean)true), this.outputParameters(resource.getProperties())));
    }

    @Override
    public boolean shouldRenderResource(EmbeddedResource resource, RenderContext context) {
        if (!(resource instanceof EmbeddedImage)) {
            return false;
        }
        if (resource.isInternal()) {
            RendererAttachment attachment = null;
            try {
                attachment = this.attachmentManager.getAttachment(context, resource);
            }
            catch (Exception e) {
                log.warn("Unable to obtain attachment " + e.getMessage());
            }
            if (attachment == null) {
                return true;
            }
        }
        return false;
    }
}

