/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.auditing.handlers.AccessDeniedAuditHandler;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.IssueFinderV2;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class IssueFinderV2Impl
implements IssueFinderV2 {
    private final Pattern ISSUE_ID_PATTERN = Pattern.compile("^[1-9]\\d*$");
    private final JiraAuthenticationContext authContext;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final AccessDeniedAuditHandler auditHandler;

    public IssueFinderV2Impl(JiraAuthenticationContext authContext, IssueManager issueManager, PermissionManager permissionManager, AccessDeniedAuditHandler accessDeniedAuditHandler) {
        this.authContext = authContext;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.auditHandler = accessDeniedAuditHandler;
    }

    @Nonnull
    public Either<IssueFinderV2.SearchResult, Issue> findIssue(@Nullable String issueIdOrKey) {
        if (StringUtils.isNotBlank((CharSequence)issueIdOrKey) && this.isIssueId(issueIdOrKey)) {
            return this.findIssueById(Long.parseLong(issueIdOrKey));
        }
        if (StringUtils.isNotBlank((CharSequence)issueIdOrKey)) {
            return this.findIssueByKey(issueIdOrKey);
        }
        return Either.left((Object)IssueFinderV2.SearchResult.INCORRECT_PARAM);
    }

    private boolean isIssueId(@Nonnull String issueIdOrKey) {
        return this.ISSUE_ID_PATTERN.matcher(issueIdOrKey).matches();
    }

    private Either<IssueFinderV2.SearchResult, Issue> findIssueById(@Nonnull Long id) {
        MutableIssue issue = this.issueManager.getIssueObject(id);
        return this.checkIssuePermission((Issue)issue);
    }

    private Either<IssueFinderV2.SearchResult, Issue> findIssueByKey(@Nonnull String key) {
        MutableIssue issue = this.issueManager.getIssueObject(key);
        if (issue == null) {
            issue = this.issueManager.getIssueObject(key.toUpperCase());
        }
        return this.checkIssuePermission((Issue)issue);
    }

    private Either<IssueFinderV2.SearchResult, Issue> checkIssuePermission(Issue issue) {
        if (issue == null) {
            return Either.left((Object)IssueFinderV2.SearchResult.ISSUE_DOES_NOT_EXIST);
        }
        ApplicationUser user = this.authContext.getLoggedInUser();
        if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user)) {
            this.auditHandler.handleIssueAccessDenied(issue.getKey());
            return Either.left((Object)IssueFinderV2.SearchResult.USER_HAS_NO_ACCESS);
        }
        return Either.right((Object)issue);
    }
}

