/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class WorklogRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final ProjectRoleManager projectRoleManager;
    private final I18nHelper i18n;
    private static final String TIME_SPENT_INPUT = "timeSpent";
    private static final String STARTED_INPUT = "started";
    public static final String ADJUST_REMAINING_ESTIMATE_INPUT = "adjustEstimate";
    public static final String NEW_ESTIMATE_INPUT = "newEstimate";
    public static final String REDUCE_BY_INPUT = "reduceBy";
    public static final String INCREASE_BY_INPUT = "increaseBy";

    public WorklogRestFieldOperationsHandler(DateTimeFormatterFactory dateTimeFormatterFactory, ProjectRoleManager projectRoleManager, I18nHelper i18n) {
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.projectRoleManager = projectRoleManager;
        this.i18n = i18n;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName());
    }

    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (operations.size() > 1) {
            errors.addError("worklog", this.i18n.getText("rest.worklog.error.tomanyoperations"));
            return errors;
        }
        block3: for (FieldOperationHolder op : operations) {
            StandardOperation standardOperation = StandardOperation.valueOf((String)op.getOperation().toUpperCase());
            JsonData data = op.getData();
            if (!data.isObject()) {
                errors.addError("worklog", this.i18n.getText("rest.worklog.error.requiredObject"));
                continue;
            }
            switch (standardOperation) {
                case ADD: {
                    this.performAddOperation(issue, data, inputParameters, (ErrorCollection)errors);
                    continue block3;
                }
            }
            errors.addError("worklog", this.i18n.getText("rest.worklog.error.operationsSupported"));
        }
        return errors;
    }

    private void performAddOperation(Issue issue, JsonData data, IssueInputParameters inputParameters, ErrorCollection errors) {
        String timeSpent = data.getObjectStringProperty(TIME_SPENT_INPUT, TIME_SPENT_INPUT, errors);
        Date start = data.getObjectDateProperty(STARTED_INPUT, errors);
        if (!errors.hasAnyErrors()) {
            Map actionParameters = inputParameters.getActionParameters();
            actionParameters.put("worklog", new String[0]);
            actionParameters.put("worklog_activate", new String[]{"true"});
            if (issue == null) {
                actionParameters.put("isCreateIssue", new String[]{"true"});
            }
            if (timeSpent != null) {
                actionParameters.put("worklog_timeLogged", new String[]{timeSpent});
            }
            DateTimeFormatter userDateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER);
            actionParameters.put("worklog_startDate", new String[]{userDateTimeFormatter.format(start != null ? start : new Date())});
            this.addAdjustmentParams(data, actionParameters, errors);
            this.addCommentParams(data, actionParameters, errors);
            this.addVisibilityParams(data, actionParameters, errors);
        }
    }

    private void addCommentParams(JsonData data, Map<String, String[]> actionParameters, ErrorCollection errors) {
        String comment = data.getObjectStringProperty("comment", "comment", errors);
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            actionParameters.put("worklog_description", new String[]{comment});
        }
    }

    private void addVisibilityParams(JsonData data, Map<String, String[]> actionParameters, ErrorCollection errors) {
        String visibilityType;
        Map stringObjectMap = data.asObject();
        Map visibilityData = (Map)stringObjectMap.get("visibility");
        if (visibilityData != null && (visibilityType = (String)visibilityData.get("type")) != null) {
            VisibilityJsonBean.VisibilityType type = VisibilityJsonBean.VisibilityType.valueOf((String)visibilityType.toLowerCase());
            if (type != null) {
                String securityLevel = null;
                if (type.equals((Object)VisibilityJsonBean.VisibilityType.group)) {
                    String group = (String)visibilityData.get("value");
                    if (StringUtils.isNotEmpty((CharSequence)group)) {
                        securityLevel = CommentVisibility.getCommentLevelFromLevels(group, null);
                    } else {
                        errors.addError("comment", this.i18n.getText("rest.worklog.error.visibility.group.missing"));
                    }
                } else {
                    String roleLevel = (String)visibilityData.get("value");
                    if (StringUtils.isNotEmpty((CharSequence)roleLevel)) {
                        Long roleLevelId;
                        ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleLevel);
                        if (projectRole != null) {
                            roleLevelId = projectRole.getId();
                        } else {
                            try {
                                roleLevelId = Long.valueOf(roleLevel);
                            }
                            catch (NumberFormatException ex) {
                                errors.addError("comment", this.i18n.getText("rest.worklog.error.visibility.role.invalid"));
                                return;
                            }
                        }
                        securityLevel = CommentVisibility.getCommentLevelFromLevels(null, roleLevelId);
                    } else {
                        errors.addError("comment", this.i18n.getText("rest.worklog.error.visibility.role.missing"));
                    }
                }
                ArrayList<String> commentSecurity = new ArrayList<String>();
                commentSecurity.add(securityLevel);
                actionParameters.put("worklog_visibilityLevel", commentSecurity.toArray(new String[commentSecurity.size()]));
            } else {
                errors.addError("visibility", this.i18n.getText("rest.worklog.error.visibility.type.invalid", visibilityType));
            }
        }
    }

    private void addAdjustmentParams(JsonData data, Map<String, String[]> actionParameters, ErrorCollection errors) {
        String adjustmentString = data.getObjectStringProperty(ADJUST_REMAINING_ESTIMATE_INPUT, ADJUST_REMAINING_ESTIMATE_INPUT, errors);
        if (adjustmentString == null) {
            actionParameters.put("worklog_adjustEstimate", new String[]{WorklogSystemField.WorklogValue.AdjustEstimate.AUTO.name()});
            return;
        }
        WorklogSystemField.WorklogValue.AdjustEstimate mode = WorklogSystemField.WorklogValue.AdjustEstimate.valueOf(adjustmentString.toUpperCase());
        if (mode == null) {
            errors.addError(ADJUST_REMAINING_ESTIMATE_INPUT, this.i18n.getText("rest.worklog.error.adjustEstimate.invalid", Arrays.toString((Object[])WorklogSystemField.WorklogValue.AdjustEstimate.values())));
            return;
        }
        actionParameters.put("worklog_adjustEstimate", new String[]{mode.name()});
        switch (mode) {
            case NEW: {
                String newEstimate = data.getObjectStringProperty(NEW_ESTIMATE_INPUT, NEW_ESTIMATE_INPUT, errors);
                if (newEstimate == null) {
                    errors.addError(NEW_ESTIMATE_INPUT, this.i18n.getText("rest.worklog.error.adjustEstimate.new.newEstimate.missing"));
                    break;
                }
                actionParameters.put("worklog_newEstimate", new String[]{newEstimate});
                break;
            }
            case MANUAL: {
                String reduceBy = data.getObjectStringProperty(REDUCE_BY_INPUT, REDUCE_BY_INPUT, errors);
                if (reduceBy == null) {
                    errors.addError(REDUCE_BY_INPUT, this.i18n.getText("rest.worklog.error.adjustEstimate.manual.reduceBy.missing"));
                    break;
                }
                actionParameters.put("worklog_adjustmentAmount", new String[]{reduceBy});
            }
        }
    }
}

