/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;

public class FieldScreenTabImpl
extends AbstractGVBean
implements FieldScreenTab {
    private final FieldScreenManager fieldScreenManager;
    private Long id;
    private String name;
    private int position;
    private FieldScreen fieldScreen;
    private AtomicReference<LayoutItems> layoutItemsAtomicReference = new AtomicReference<Object>(null);

    public FieldScreenTabImpl(FieldScreenManager fieldScreenManager) {
        this(fieldScreenManager, null);
    }

    public FieldScreenTabImpl(FieldScreenManager fieldScreenManager, GenericValue genericValue) {
        this.fieldScreenManager = fieldScreenManager;
        this.setGenericValue(genericValue);
    }

    private LayoutItems getLayoutItems() {
        LayoutItems layoutItems = this.layoutItemsAtomicReference.get();
        if (layoutItems == null) {
            layoutItems = new LayoutItems(this.fieldScreenManager.getFieldScreenLayoutItems((FieldScreenTab)this));
            if (this.layoutItemsAtomicReference.compareAndSet(null, layoutItems)) {
                return layoutItems;
            }
            return this.layoutItemsAtomicReference.get();
        }
        return layoutItems;
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            if (this.getGenericValue().getLong("sequence") != null) {
                this.position = this.getGenericValue().getLong("sequence").intValue();
            }
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        this.updateGV("sequence", position);
    }

    public void store() {
        LayoutItems layoutItems;
        if (this.isModified()) {
            if (this.id == null) {
                this.fieldScreenManager.createFieldScreenTab((FieldScreenTab)this);
            } else {
                this.fieldScreenManager.updateFieldScreenTab((FieldScreenTab)this);
                this.setModified(false);
            }
        }
        if ((layoutItems = this.layoutItemsAtomicReference.get()) != null) {
            layoutItems.store();
        }
    }

    public void remove() {
        this.fieldScreenManager.removeFieldScreenLayoutItems((FieldScreenTab)this);
        this.fieldScreenManager.removeFieldScreenTab(this.getId());
    }

    public FieldScreen getFieldScreen() {
        return this.fieldScreen;
    }

    public void rename(String newName) {
        this.setName(newName);
        this.store();
    }

    public void setFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreen = fieldScreen;
        if (fieldScreen == null) {
            this.updateGV("fieldscreen", null);
        } else {
            this.updateGV("fieldscreen", fieldScreen.getId());
        }
    }

    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems() {
        return Collections.unmodifiableList(this.getLayoutItems().getInternalLayoutItems());
    }

    public FieldScreenLayoutItem getFieldScreenLayoutItem(int poistion) {
        return (FieldScreenLayoutItem)this.getLayoutItems().getInternalLayoutItems().get(poistion);
    }

    public void addFieldScreenLayoutItem(String orderableFieldId) {
        this.addFieldScreenLayoutItem(orderableFieldId, this.getLayoutItems().getInternalLayoutItems().size());
    }

    public void addFieldScreenLayoutItem(String orderableFieldId, int position) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.fieldScreenManager.buildNewFieldScreenLayoutItem(orderableFieldId);
        fieldScreenLayoutItem.setFieldScreenTab((FieldScreenTab)this);
        this.getLayoutItems().add(position, fieldScreenLayoutItem);
        this.store();
    }

    public void moveFieldScreenLayoutItemFirst(int fieldPosition) {
        this.getLayoutItems().moveFirst(fieldPosition);
        this.store();
    }

    public void moveFieldScreenLayoutItemUp(int fieldPosition) {
        this.getLayoutItems().moveUp(fieldPosition);
        this.store();
    }

    public void moveFieldScreenLayoutItemDown(int fieldPosition) {
        this.getLayoutItems().moveDown(fieldPosition);
        this.store();
    }

    public void moveFieldScreenLayoutItemLast(int fieldPosition) {
        this.getLayoutItems().moveLast(fieldPosition);
        this.store();
    }

    public FieldScreenLayoutItem removeFieldScreenLayoutItem(int fieldPosition) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.getLayoutItems().remove(fieldPosition);
        fieldScreenLayoutItem.remove();
        this.store();
        return fieldScreenLayoutItem;
    }

    public void moveFieldScreenLayoutItemToPosition(Map<Integer, FieldScreenLayoutItem> positionsToFields) {
        if (positionsToFields.isEmpty()) {
            return;
        }
        this.getLayoutItems().moveToPosition(positionsToFields);
        this.store();
    }

    public FieldScreenLayoutItem getFieldScreenLayoutItem(String fieldId) {
        return (FieldScreenLayoutItem)this.getLayoutItems().getInternalLayoutItemsMap().get(fieldId);
    }

    public boolean isContainsField(String fieldId) {
        return this.getLayoutItems().getInternalLayoutItemsMap().containsKey(fieldId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenTab)) {
            return false;
        }
        FieldScreenTab fieldScreenTab = (FieldScreenTab)o;
        if (this.position != fieldScreenTab.getPosition()) {
            return false;
        }
        if (this.id != null ? !this.id.equals(fieldScreenTab.getId()) : fieldScreenTab.getId() != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(fieldScreenTab.getName()) : fieldScreenTab.getName() != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + this.position;
        return result;
    }

    private static class LayoutItems {
        private final List<FieldScreenLayoutItem> layoutItems;
        private final Map<String, FieldScreenLayoutItem> layoutItemsMap;

        private LayoutItems(List<FieldScreenLayoutItem> layoutItems) {
            this.layoutItems = layoutItems;
            this.layoutItemsMap = this.layoutItems.stream().collect(Collectors.toMap(FieldScreenLayoutItem::getFieldId, Function.identity()));
        }

        private List<FieldScreenLayoutItem> getInternalLayoutItems() {
            return this.layoutItems;
        }

        private Map<String, FieldScreenLayoutItem> getInternalLayoutItemsMap() {
            return this.layoutItemsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(int position, FieldScreenLayoutItem fieldScreenLayoutItem) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                this.layoutItems.add(position, fieldScreenLayoutItem);
                this.layoutItemsMap.put(fieldScreenLayoutItem.getFieldId(), fieldScreenLayoutItem);
                this.resequence(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FieldScreenLayoutItem remove(int fieldPosition) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                FieldScreenLayoutItem fieldScreenLayoutItem = this.layoutItems.remove(fieldPosition);
                this.layoutItemsMap.remove(fieldScreenLayoutItem.getFieldId());
                this.resequence();
                return fieldScreenLayoutItem;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void store() {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                for (FieldScreenLayoutItem fieldScreenLayoutItem : this.layoutItems) {
                    fieldScreenLayoutItem.store();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveFirst(int fieldPosition) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                CollectionReorderer.moveToStart(this.layoutItems, this.layoutItems.get(fieldPosition));
                this.resequence();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveUp(int fieldPosition) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                CollectionReorderer.increasePosition(this.layoutItems, this.layoutItems.get(fieldPosition));
                this.resequence();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveDown(int fieldPosition) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                CollectionReorderer.decreasePosition(this.layoutItems, this.layoutItems.get(fieldPosition));
                this.resequence();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveLast(int fieldPosition) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                CollectionReorderer.moveToEnd(this.layoutItems, this.layoutItems.get(fieldPosition));
                this.resequence();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveToPosition(Map<Integer, FieldScreenLayoutItem> positionsToFields) {
            if (positionsToFields.isEmpty()) {
                return;
            }
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                CollectionReorderer.moveToPosition(this.layoutItems, positionsToFields);
                this.resequence();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resequence() {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                this.resequence(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resequence(int startIndex) {
            LayoutItems layoutItems = this;
            synchronized (layoutItems) {
                for (int i = startIndex; i < this.layoutItems.size(); ++i) {
                    this.layoutItems.get(i).setPosition(i);
                }
            }
        }
    }
}

