/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageCalculationEvent;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageDAO;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageDataWriter;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageEnabledCheck;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageIdentificationDisabledException;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.Closeable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldUsageDataService {
    public static final Set<String> DEFAULT_TRUSTED_CUSTOM_FIELD_TYPE_KEYS = ImmutableSet.of((Object)"com.atlassian.jira.plugin.system.customfieldtypes:textfield", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:textarea", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:float", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:importid", (Object[])new String[]{"com.atlassian.jira.plugin.system.customfieldtypes:select", "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", "com.atlassian.jira.plugin.system.customfieldtypes:project", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion", "com.atlassian.jira.plugin.system.customfieldtypes:version", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:multiselect", "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", "com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", "com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", "com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield"});
    public static final int DEFAULT_DATA_COLLECTION_QUERY_MAX_IDS = 1000;
    private static final String DATA_COLLECTION_QUERY_MAX_IDS_PROPERTY_KEY = "com.atlassian.jira.issue.fields.usage.query.max.ids";
    public static final String CF_USAGE_CLUSTER_LOCK_NAME = CustomFieldUsageDataService.class.getName() + ".calculate.from.db";
    private static final Logger log = LoggerFactory.getLogger(CustomFieldUsageDataService.class);
    private final CustomFieldManager customFieldManager;
    private final CustomFieldUsageDAO dao;
    private final CustomFieldUsageDataWriter lastUpdateDataWriter;
    private final ApplicationProperties applicationProperties;
    private final CustomFieldUsageEnabledCheck featureEnabledCheck;
    private final ClusterLockService clusterLockService;
    private final EventPublisher eventPublisher;
    private static final String NO_CUSTOM_FIELDS_MESSAGE = "No custom fields in the system, skipping usage calculation";
    private final ScheduledExecutorService watchdogExecutor;

    public CustomFieldUsageDataService(CustomFieldManager customFieldManager, CustomFieldUsageDAO dao, CustomFieldUsageDataWriter lastUpdateDataWriter, ApplicationProperties applicationProperties, CustomFieldUsageEnabledCheck featureEnabledCheck, ClusterLockService clusterLockService, EventPublisher eventPublisher) {
        this.customFieldManager = customFieldManager;
        this.dao = dao;
        this.lastUpdateDataWriter = lastUpdateDataWriter;
        this.applicationProperties = applicationProperties;
        this.featureEnabledCheck = featureEnabledCheck;
        this.clusterLockService = clusterLockService;
        this.watchdogExecutor = Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory((String)"CustomFieldUsageQueriesWatchdog"));
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    public void updateLastValueUpdateForCustomFields(Set<Long> customFieldsId) {
        this.lastUpdateDataWriter.reportCustomFieldUpdates(customFieldsId, Timestamp.from(Instant.now()));
    }

    private Map<Long, Timestamp> calculateLastUpdateDateFromDBData(List<CustomField> customFields) {
        if (customFields.isEmpty()) {
            log.debug(NO_CUSTOM_FIELDS_MESSAGE);
            return Collections.emptyMap();
        }
        Map<Long, Timestamp> historyMap = this.calculateLatestUsageFromHistory(customFields);
        log.info("Found 'Last Value Update' for {} Custom Fields in Change History", (Object)historyMap.size());
        Map<Long, Timestamp> issuesMap = this.calculateLatestUsageFromIssues(customFields);
        log.info("Found 'Last Value Update' for {} Custom Fields in Issues' create values", (Object)issuesMap.size());
        return Stream.concat(historyMap.entrySet().stream(), issuesMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1.after((Timestamp)v2) ? v1 : v2));
    }

    void calculateIssuesWithValueData() {
        List<Long> allCustomFieldIds = this.getAllCustomFieldsIds(this.customFieldManager.getCustomFieldObjects());
        long startTime = System.currentTimeMillis();
        if (allCustomFieldIds.isEmpty()) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), 0, true, false));
            log.debug(NO_CUSTOM_FIELDS_MESSAGE);
            return;
        }
        ClusterLock lock = this.clusterLockService.getLockForName(CF_USAGE_CLUSTER_LOCK_NAME);
        if (!lock.tryLock()) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), 0, false, false));
            throw new LockNotAcquiredException("Could not acquire lock for calculating last value update data from database");
        }
        try {
            Map allDbResults = this.getDataInBatches("Issues with values", allCustomFieldIds, this.dao::collectIssuesWithValueData);
            log.info("Found info about `Issues with values` for {} of {} custom fields", (Object)allDbResults.size(), (Object)allCustomFieldIds.size());
            Map<Long, Long> cfsToUsageMap = allCustomFieldIds.stream().map(id -> Pair.of((Object)id, (Object)allDbResults.getOrDefault(id, 0L))).collect(Collectors.toMap(Pair::first, Pair::second));
            allCustomFieldIds.forEach(id -> cfsToUsageMap.computeIfAbsent((Long)id, v -> 0L));
            log.info("Writing initial values of `Issues with values` for {} custom fields", (Object)cfsToUsageMap.size());
            this.dao.updateCustomFieldsWithIssuesWithValueData(cfsToUsageMap);
            log.info("Refreshing custom field cache...");
            this.customFieldManager.clear();
            log.info("Calculating values of `Issues with values` for custom fields - finished");
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), allCustomFieldIds.size(), true, false));
        }
        catch (RuntimeException e) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), 0, false, false));
            throw e;
        }
        catch (Exception e) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), 0, false, false));
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    void writeInitialLastValueUpdateDates() {
        ClusterLock lock = this.clusterLockService.getLockForName(CF_USAGE_CLUSTER_LOCK_NAME);
        long startTime = System.currentTimeMillis();
        List customFields = Collections.emptyList();
        if (!lock.tryLock()) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), 0, true, true));
            throw new LockNotAcquiredException("Could not acquire lock for calculating last value update data from database");
        }
        try {
            log.info("Calculating initial values of `Last Value Update` for custom fields");
            customFields = this.customFieldManager.getCustomFieldObjects();
            Map<Long, Timestamp> latestValuesForCF = this.calculateLastUpdateDateFromDBData(customFields);
            log.info("Writing initial values of `Last Value Update` for {} custom fields", (Object)latestValuesForCF.size());
            latestValuesForCF.forEach(this.dao::updateCustomFieldWithLatestValueUpdate);
            if (!latestValuesForCF.isEmpty()) {
                log.info("Refreshing custom field cache...");
                this.customFieldManager.clear();
            }
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), latestValuesForCF.size(), true, true));
            log.info("Calculating initial values of `Last Value Update` for custom fields - Finished");
        }
        catch (RuntimeException e) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), customFields.size(), false, true));
            throw e;
        }
        catch (Exception e) {
            this.eventPublisher.publish((Object)new CustomFieldUsageCalculationEvent(startTime, System.currentTimeMillis(), customFields.size(), false, true));
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private Map<Long, Timestamp> calculateLatestUsageFromHistory(List<CustomField> customFields) {
        List allCustomFieldNames = customFields.stream().map(CustomField::getFieldName).collect(Collectors.toList());
        Map allDbResults = this.getDataInBatches("'Last Value Update' from Issues", allCustomFieldNames, this.dao::collectLatestValueUpdatesFromHistory);
        return allDbResults.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).flatMap(t -> {
            Collection customFieldObjects = this.customFieldManager.getCustomFieldObjectsByName((String)t.getKey());
            if (customFieldObjects == null || customFieldObjects.isEmpty()) {
                log.warn("Could not find existing custom field named {} when pre-calculating usage data basing on Issue history. If the field was renamed it might be missing 'Last value update'", t.getKey());
                return Stream.empty();
            }
            if (customFieldObjects.size() > 1) {
                log.warn("Detected more than one custom field named: {} when pre-calculating usage data basing on Issue history. Last update date values might be incorrect for the following fields: {}", t.getKey(), (Object)customFieldObjects);
            }
            return customFieldObjects.stream().map(cf -> Pair.nicePairOf((Object)cf.getIdAsLong(), t.getValue()));
        }).filter(p -> p.first() != null && p.second() != null).collect(Collectors.toMap(Pair::first, Pair::second, (existing, replacement) -> existing));
    }

    private Map<Long, Timestamp> calculateLatestUsageFromIssues(List<CustomField> customFields) {
        List<Long> allCustomFieldIds = this.getAllCustomFieldsIds(customFields);
        Map allDbResults = this.getDataInBatches("'Last Value Update' from Issues", allCustomFieldIds, this.dao::collectLatestValueUpdatesFromIssues);
        return allDbResults.entrySet().stream().map(e -> Pair.nicePairOf(e.getKey(), e.getValue())).filter(p -> p.first() != null && p.second() != null).collect(Collectors.toMap(Pair::first, Pair::second, (existing, replacement) -> existing));
    }

    private <T, R> Map<T, R> getDataInBatches(String dataName, List<T> allCustomFieldsIds, Function<Collection<T>, Map<T, R>> daoCall) {
        int queryMaxIds = this.getQueryMaxIds();
        int allCustomFieldsCount = allCustomFieldsIds.size();
        List allCustomFieldsIdsNoDuplicates = allCustomFieldsIds.stream().distinct().collect(Collectors.toList());
        List partitionedCustomFields = Lists.partition(allCustomFieldsIdsNoDuplicates, (int)queryMaxIds);
        log.info("Start collecting db data about `{}` for {} custom fields, batches: {}, max batch size {} ", new Object[]{dataName, allCustomFieldsCount, partitionedCustomFields.size(), queryMaxIds});
        HashMap allDbResults = new HashMap(allCustomFieldsIdsNoDuplicates.size());
        Instant fullDataCollectionStart = Instant.now();
        int currentBatch = 1;
        for (List customFieldIdsBatch : partitionedCustomFields) {
            this.throwIfFeatureDisabled();
            Instant queryStart = Instant.now();
            String startingQueryInfo = String.format("Collecting db data about `%s` for %d of %d custom fields, for batch %d of %d ", dataName, customFieldIdsBatch.size(), allCustomFieldsCount, currentBatch, partitionedCustomFields.size());
            log.info(startingQueryInfo);
            try (QueryWatchdog ignore = this.watch(startingQueryInfo);){
                allDbResults.putAll((Map)daoCall.apply((Object)customFieldIdsBatch));
            }
            Instant queryEnd = Instant.now();
            log.info("Finished collecting db data about `{}` for {} of {} custom fields, for batch {} of {}. Query duration: {} ms, all queries duration: {} ms ", new Object[]{dataName, customFieldIdsBatch.size(), allCustomFieldsCount, currentBatch, partitionedCustomFields.size(), ChronoUnit.MILLIS.between(queryStart, queryEnd), ChronoUnit.MILLIS.between(fullDataCollectionStart, queryEnd)});
            ++currentBatch;
        }
        return allDbResults;
    }

    private void throwIfFeatureDisabled() {
        RequestCacheController.clearAll();
        if (!this.featureEnabledCheck.isCustomFieldUsageIdentificationEnabled()) {
            throw new CustomFieldUsageIdentificationDisabledException();
        }
    }

    private List<Long> getAllCustomFieldsIds(List<CustomField> customFields) {
        return customFields.stream().map(CustomField::getIdAsLong).collect(Collectors.toList());
    }

    private int getQueryMaxIds() {
        int intProperty = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)DATA_COLLECTION_QUERY_MAX_IDS_PROPERTY_KEY, (int)1000);
        if (intProperty > 0) {
            return intProperty;
        }
        log.warn("Batch size property {} set to incorrect value {}, using default {}", new Object[]{DATA_COLLECTION_QUERY_MAX_IDS_PROPERTY_KEY, intProperty, 1000});
        return 1000;
    }

    public Set<String> getTrustedKeys() {
        return DEFAULT_TRUSTED_CUSTOM_FIELD_TYPE_KEYS;
    }

    private QueryWatchdog watch(String watchedOpName) {
        return new QueryWatchdog(this.watchdogExecutor, watchedOpName);
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        this.watchdogExecutor.shutdownNow();
    }

    private static class QueryWatchdog
    implements Closeable {
        private final String watchedOpName;
        private final ScheduledFuture<?> watchdogJob;
        private final Instant startTime;
        public static final Duration INFORM_AFTER_DURATION = Duration.of(5L, ChronoUnit.MINUTES);
        public static final Duration WARN_AFTER_DURATION = Duration.of(15L, ChronoUnit.MINUTES);
        public static final long JOB_INTERVAL_MINUTES = 1L;

        QueryWatchdog(ScheduledExecutorService executor, String watchedOpName) {
            this.watchedOpName = watchedOpName;
            this.startTime = Instant.now();
            this.watchdogJob = executor.scheduleWithFixedDelay(() -> {
                Duration timeSinceStart = this.timeSinceStarted();
                long minutesSinceStart = timeSinceStart.toMinutes();
                if (this.shouldWarn(timeSinceStart)) {
                    log.warn("[{}] started {} minutes ago and is still in progress. Consider decreasing amount of custom field data to be collected within a single batch by overriding {}", new Object[]{watchedOpName, minutesSinceStart, CustomFieldUsageDataService.DATA_COLLECTION_QUERY_MAX_IDS_PROPERTY_KEY});
                } else if (this.shouldInform(timeSinceStart)) {
                    log.info("[{}] started {} minutes ago and is still in progress.", (Object)watchedOpName, (Object)minutesSinceStart);
                }
            }, 1L, 1L, TimeUnit.MINUTES);
        }

        private boolean shouldInform(Duration jobDuration) {
            return INFORM_AFTER_DURATION.compareTo(jobDuration) < 1;
        }

        private boolean shouldWarn(Duration jobDuration) {
            return WARN_AFTER_DURATION.compareTo(jobDuration) < 1;
        }

        @Override
        public void close() {
            log.debug("Finished [{}] in {} minutes", (Object)this.watchedOpName, (Object)this.timeSinceStarted().toMinutes());
            this.watchdogJob.cancel(true);
        }

        private Duration timeSinceStarted() {
            return Duration.between(this.startTime, Instant.now());
        }
    }

    public static class LockNotAcquiredException
    extends RuntimeException {
        LockNotAcquiredException(String message) {
            super(message);
        }
    }
}

