/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.LicenseChangedEvent;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.function.Supplier;

public class CustomFieldUsageEnabledCheck {
    private final ClusterManager clusterManager;
    private final FeatureManager featureManager;
    private final ApplicationProperties applicationProperties;
    private final ResettableLazyReference<Boolean> isDcLicensed = Lazy.resettable((Supplier)new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return CustomFieldUsageEnabledCheck.this.clusterManager.isClusterLicensed();
        }
    });

    public CustomFieldUsageEnabledCheck(ClusterManager clusterManager, EventPublisher eventPublisher, FeatureManager featureManager, ApplicationProperties applicationProperties) {
        this.clusterManager = clusterManager;
        this.featureManager = featureManager;
        this.applicationProperties = applicationProperties;
        eventPublisher.register((Object)this);
    }

    public boolean isCustomFieldUsageIdentificationEnabled() {
        return this.isEnabledForLicense() && this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CUSTOMFIELDS_IDENTIFICATION);
    }

    public boolean isCustomFieldUsageIdentificationInitRequired() {
        return this.isEnabledForLicense() && this.applicationProperties.getOption("com.atlassian.jira.issue.fields.usage.init.required");
    }

    public boolean isEnabledForLicense() {
        return (Boolean)this.isDcLicensed.get();
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.isDcLicensed.reset();
    }
}

